/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.tile.IWrenchable;
import com.denfop.blocks.TileBlockCreator;
import com.denfop.blocks.blockitem.ItemBlockTileEntity;
import com.denfop.blocks.state.HarvestTool;
import com.denfop.blocks.state.State;
import com.denfop.blocks.state.TypeProperty;
import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.datagen.blocktags.IBlockTag;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ModUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class BlockTileEntity<T extends Enum<T>>
extends Block
implements EntityBlock,
IWrenchable,
IBlockTag {
    public static final Map<BlockPos, TileEntityBlock> teBlockDrop = new HashMap<BlockPos, TileEntityBlock>();
    public static final Property<Direction> ALL_FACING_PROPERTY = DirectionProperty.create((String)"facing", ModUtils.allFacings);
    public static final Property<Direction> HORIZONTAL_FACING_PROPERTY = DirectionProperty.create((String)"facing", ModUtils.horizontalFacings);
    public static final Property<Direction> VERTICAL_FACING_PROPERTY = DirectionProperty.create((String)"facing", ModUtils.verticalFacings);
    public static final Property<Direction> DOWN_FACING_PROPERTY = DirectionProperty.create((String)"facing", ModUtils.downSideFacings);
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.class), p_55164_ -> {
        p_55164_.put(Direction.NORTH, NORTH);
        p_55164_.put(Direction.EAST, EAST);
        p_55164_.put(Direction.SOUTH, SOUTH);
        p_55164_.put(Direction.WEST, WEST);
        p_55164_.put(Direction.UP, UP);
        p_55164_.put(Direction.DOWN, DOWN);
    })));
    private static final BlockEntityTicker<TileEntityBlock> TICKER = (level, blockPos, blockState, tileEntityBlock) -> tileEntityBlock.tick();
    public static TypeProperty currentTypeProperty;
    private static IMultiTileBlock preValue;
    public final Property<Direction> facingProperty;
    public final TileBlockCreator.InfoAboutTile<?> teInfo;
    private final ResourceLocation identifier;
    private final T value;
    public ItemBlockTileEntity<T> item;
    public TypeProperty typeProperty = this.getTypeProperty();
    public static LinkedList<TileEntityBlock> drops;

    public BlockTileEntity(BlockBehaviour.Properties properties, T value, ResourceLocation identifier, TileBlockCreator.InfoAboutTile<T> teInfo) {
        super(properties);
        this.value = value;
        this.teInfo = teInfo;
        this.identifier = identifier;
        this.facingProperty = this.stateDefinition.getProperty("facing");
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)this.typeProperty, (Comparable)this.typeProperty.getState((IMultiTileBlock)value, ""));
        if (this.facingProperty != null) {
            state = (BlockState)state.setValue(this.facingProperty, (Comparable)this.getPlacementFacing(null, Direction.SOUTH));
        }
        if (((IMultiTileBlock)value).getMaterial() == IMultiTileBlock.CABLE) {
            ((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(state);
        ((IMultiTileBlock)value).setDefaultState(this.defaultBlockState());
        BlockTagsProvider.list.add(this);
    }

    public static <T extends Enum<T>> BlockTileEntity<T> create(T value, ResourceLocation identifier, TileBlockCreator.InfoAboutTile<T> infoAboutTile) {
        currentTypeProperty = new TypeProperty(identifier, (IMultiTileBlock)((Object)value));
        preValue = (IMultiTileBlock)((Object)value);
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.of().mapColor(((IMultiTileBlock)((Object)value)).getMaterial()).instrument(NoteBlockInstrument.FLUTE).strength(((IMultiTileBlock)((Object)value)).getHardness()).isRedstoneConductor((p_61036_, p_61037_, p_61038_) -> {
            TileEntityBlock te = BlockTileEntity.getTe(p_61037_, p_61038_);
            return te != null && te.canConnectRedstone();
        }).noOcclusion().sound(((IMultiTileBlock)((Object)value)).getMaterial() == MapColor.WOOL ? SoundType.WOOL : SoundType.STONE);
        if (((IMultiTileBlock)((Object)value)).getMaterial() == MapColor.PLANT) {
            prop = prop.noCollission();
        }
        if (((IMultiTileBlock)((Object)value)).getMaterial() == MapColor.WOOL) {
            prop = prop.explosionResistance(300.0f);
        }
        if (((IMultiTileBlock)((Object)value)).getHarvestTool() != HarvestTool.None) {
            prop = prop.requiresCorrectToolForDrops();
        }
        BlockTileEntity<T> ret = new BlockTileEntity<T>(prop, value, identifier, infoAboutTile);
        currentTypeProperty = null;
        return ret;
    }

    private static TileEntityBlock getTe(Level world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        return te instanceof TileEntityBlock ? (TileEntityBlock)te : null;
    }

    private static TileEntityBlock getTe(BlockGetter getter, BlockPos pos) {
        BlockEntity blockEntity = getter.getBlockEntity(pos);
        if (blockEntity instanceof TileEntityBlock) {
            TileEntityBlock te = (TileEntityBlock)blockEntity;
            return te;
        }
        return null;
    }

    public boolean hasDynamicShape() {
        return true;
    }

    public float getShadeBrightness(BlockState p_48731_, BlockGetter p_48732_, BlockPos p_48733_) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState p_48740_, BlockGetter p_48741_, BlockPos p_48742_) {
        return true;
    }

    public boolean skipRendering(BlockState p_53972_, BlockState p_53973_, Direction p_53974_) {
        if (!p_53973_.hasProperty((Property)this.typeProperty)) {
            return super.skipRendering(p_53972_, p_53973_, p_53974_);
        }
        IMultiTileBlock type = ((State)p_53973_.getValue((Property)this.typeProperty)).teBlock;
        return this.value == type || super.skipRendering(p_53972_, p_53973_, p_53974_);
    }

    public void setItem(ItemBlockTileEntity<T> item) {
        this.item = item;
    }

    public T getValue() {
        return this.value;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileEntityBlock) {
            TileEntityBlock te = (TileEntityBlock)blockEntity;
            te.onEntityCollision(entity);
        }
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        TileEntityBlock tileEntityBlock = BlockTileEntity.getTe(level, blockPos);
        if (tileEntityBlock != null) {
            tileEntityBlock.onPlaced(itemStack, livingEntity, tileEntityBlock.getFacing());
        }
    }

    public int getLightBlock(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof TileEntityBlock) {
            return ((TileEntityBlock)te).getLightOpacity();
        }
        return 0;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof TileEntityBlock) {
            return ((TileEntityBlock)te).getComparatorInputOverride();
        }
        return 0;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext collisionContext) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te == null ? super.getShape(state, world, pos, collisionContext) : Shapes.create((AABB)te.getVisualBoundingBox());
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof TileEntityBlock) {
            return Shapes.create((AABB)((TileEntityBlock)te).getOutlineBoundingBox().move(pos));
        }
        return super.getInteractionShape(state, world, pos);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (!this.hasCollision) {
            return Shapes.empty();
        }
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof TileEntityBlock) {
            return Shapes.create((AABB)((TileEntityBlock)te).getPhysicsBoundingBox());
        }
        return super.getCollisionShape(state, world, pos, context);
    }

    @NotNull
    public VoxelShape getOcclusionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te == null ? super.getOcclusionShape(state, world, pos) : Shapes.create((AABB)te.getPhysicsBoundingBox());
    }

    private TypeProperty getTypeProperty() {
        if (this.typeProperty != null) {
            return this.typeProperty;
        }
        this.typeProperty = currentTypeProperty;
        return this.typeProperty;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49915_) {
        super.createBlockStateDefinition(p_49915_);
        Set<Direction> set = preValue.getSupportedFacings();
        if (set.equals(ModUtils.allFacings)) {
            p_49915_.add(new Property[]{ALL_FACING_PROPERTY});
        } else if (set.equals(ModUtils.horizontalFacings)) {
            p_49915_.add(new Property[]{HORIZONTAL_FACING_PROPERTY});
        } else if (set.equals(ModUtils.verticalFacings)) {
            p_49915_.add(new Property[]{VERTICAL_FACING_PROPERTY});
        } else if (set.equals(ModUtils.downSideFacings)) {
            p_49915_.add(new Property[]{DOWN_FACING_PROPERTY});
        }
        p_49915_.add(new Property[]{this.getTypeProperty()});
        if (preValue.getMaterial() == IMultiTileBlock.CABLE) {
            PROPERTY_BY_DIRECTION.values().forEach(xva$0 -> p_49915_.add(new Property[]{xva$0}));
        }
    }

    @Override
    public Direction getFacing(Level world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te == null ? Direction.DOWN : te.getFacing();
    }

    @Override
    public boolean setFacing(Level world, BlockPos pos, Direction newDirection, Player player) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te != null && te.canSetFacingWrench(newDirection, player);
    }

    @Override
    public boolean wrenchCanRemove(Level world, BlockPos pos, Player player) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te != null && te.wrenchCanRemove(player);
    }

    @Override
    public List<ItemStack> getWrenchDrops(Level var1, BlockPos var2, BlockState var3, BlockEntity te, Player player, int fortune) {
        List<ItemStack> list = ((TileEntityBlock)te).getWrenchDrops(player, fortune);
        return list;
    }

    @Override
    public void wrenchBreak(Level world, BlockPos pos) {
        TileEntityBlock tileEntityBlock = (TileEntityBlock)world.getBlockEntity(pos);
        if (tileEntityBlock != null) {
            tileEntityBlock.wrenchBreak();
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        try {
            return Objects.requireNonNull(((IMultiTileBlock)this.value).getTeClass()).getConstructor(BlockPos.class, BlockState.class).newInstance(blockPos, blockState);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy(LevelAccessor p_49860_, BlockPos p_49861_, BlockState p_49862_) {
    }

    public BlockState playerWillDestroy(Level p_176208_1_, BlockPos p_176208_2_, BlockState p_176208_3_, Player p_176208_4_) {
        this.spawnDestroyParticles(p_176208_1_, p_176208_4_, p_176208_2_, p_176208_3_);
        p_176208_1_.playSound(p_176208_4_, p_176208_2_, this.soundType.getBreakSound(), SoundSource.BLOCKS, this.soundType.getVolume() * 0.5f, this.soundType.getPitch() * 0.75f);
        return p_176208_3_;
    }

    public boolean hasAnalogOutputSignal(BlockState p_60457_) {
        return true;
    }

    public int getSignal(BlockState p_60483_, BlockGetter p_60484_, BlockPos p_60485_, Direction p_60486_) {
        BlockEntity te = p_60484_.getBlockEntity(p_60485_);
        if (te instanceof TileEntityBlock) {
            return ((TileEntityBlock)te).getWeakPower(p_60486_);
        }
        return 0;
    }

    public void playerDestroy(Level p_49827_, Player p_49828_, BlockPos p_49829_, BlockState p_49830_, @Nullable BlockEntity p_49831_, ItemStack p_49832_) {
        super.playerDestroy(p_49827_, p_49828_, p_49829_, p_49830_, p_49831_, p_49832_);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te != null) {
            if (!te.onRemovedByPlayer(player, willHarvest)) {
                return false;
            }
            drops.add(te);
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.item, 1);
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos neighbor, boolean p_60514_) {
        this.onNeighborChange(state, (LevelReader)level, pos, neighbor);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileEntityBlock) {
            TileEntityBlock te = (TileEntityBlock)blockEntity;
            te.onNeighborChange(level.getBlockState(neighbor), neighbor);
        }
    }

    public <E extends BlockEntity> BlockEntityTicker<E> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<E> blockEntityType) {
        return TICKER;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileEntityBlock) {
            TileEntityBlock te = (TileEntityBlock)blockEntity;
            return te.getLightValue();
        }
        return super.getLightEmission(state, level, pos);
    }

    private Direction getPlacementFacing(LivingEntity livingEntity, Direction direction) {
        Set<Direction> set = ((IMultiTileBlock)this.value).getSupportedFacings();
        if (set.isEmpty()) {
            return Direction.DOWN;
        }
        if (livingEntity != null) {
            Vec3 vec3 = livingEntity.getLookAngle();
            Direction direction2 = null;
            double d = Double.NEGATIVE_INFINITY;
            for (Direction direction3 : set) {
                double d2 = vec3.dot(Vec3.atLowerCornerOf((Vec3i)direction3.getOpposite().getNormal()));
                if (!(d2 > d)) continue;
                d = d2;
                direction2 = direction3;
            }
            return direction2;
        }
        return direction != null && set.contains(direction.getOpposite()) ? direction.getOpposite() : ((IMultiTileBlock)this.value).getSupportedFacings().iterator().next();
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        BlockState blockState = super.getStateForPlacement(blockPlaceContext);
        if (this.facingProperty != null) {
            blockState = (BlockState)blockState.setValue(this.facingProperty, (Comparable)this.getPlacementFacing((LivingEntity)blockPlaceContext.getPlayer(), blockPlaceContext.getNearestLookingDirection()));
        }
        blockState = (BlockState)blockState.setValue((Property)this.typeProperty, (Comparable)this.typeProperty.getState((IMultiTileBlock)this.value));
        if (((IMultiTileBlock)this.value).getMaterial() == IMultiTileBlock.CABLE) {
            blockState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false));
        }
        return blockState;
    }

    protected ItemInteractionResult useItemOn(ItemStack p_316304_, BlockState p_316362_, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player.isSecondaryUseActive()) {
            TileEntityBlock te = BlockTileEntity.getTe(level, blockPos);
            return te == null ? ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION : this.getResult(te.onSneakingActivated(player, interactionHand, blockHitResult.getDirection(), blockHitResult.getLocation()));
        }
        TileEntityBlock te = BlockTileEntity.getTe(level, blockPos);
        return te == null ? ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION : (te.getCooldownTracker().getTick() == 0 ? this.getResult(te.onActivated(player, interactionHand, blockHitResult.getDirection(), blockHitResult.getLocation())) : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
    }

    protected InteractionResult useWithoutItem(BlockState p_60503_, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (player.isSecondaryUseActive()) {
            TileEntityBlock te = BlockTileEntity.getTe(level, blockPos);
            return te == null ? InteractionResult.PASS : (te.getCooldownTracker().getTick() == 0 ? this.getResult1(te.onSneakingActivated(player, InteractionHand.MAIN_HAND, blockHitResult.getDirection(), blockHitResult.getLocation())) : InteractionResult.PASS);
        }
        TileEntityBlock te = BlockTileEntity.getTe(level, blockPos);
        return te == null ? InteractionResult.PASS : (te.getCooldownTracker().getTick() == 0 ? this.getResult1(te.onActivated(player, InteractionHand.MAIN_HAND, blockHitResult.getDirection(), blockHitResult.getLocation())) : InteractionResult.PASS);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        TileEntityBlock te = BlockTileEntity.getTe((BlockGetter)level, pos);
        return te == null ? ModUtils.emptyStack : te.getPickBlock(player, target);
    }

    public List<ItemStack> getDrops(BlockState p_60537_, LootParams.Builder p_60538_) {
        BlockEntity blockEntity = null;
        try {
            blockEntity = (BlockEntity)p_60538_.getParameter(LootContextParams.BLOCK_ENTITY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (blockEntity == null) {
            Vec3 vec3 = (Vec3)p_60538_.getParameter(LootContextParams.ORIGIN);
            return this.getDrops((Level)p_60538_.getLevel(), new BlockPos((int)vec3.x, (int)vec3.y, (int)vec3.z), p_60537_, (Entity)p_60538_.getParameter(LootContextParams.THIS_ENTITY));
        }
        Entity entity = null;
        try {
            entity = (Entity)p_60538_.getParameter(LootContextParams.THIS_ENTITY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getDrops((Level)p_60538_.getLevel(), blockEntity.getBlockPos(), p_60537_, entity);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        boolean ret = super.canHarvestBlock(state, world, pos, player);
        if (ret) {
            return ret;
        }
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            return false;
        }
        if (te.canEntityDestroy((Entity)player)) {
            switch (te.teBlock.getHarvestTool()) {
                case None: {
                    return true;
                }
                case Axe: {
                    ItemStack stack = player.getMainHandItem();
                    if (stack.isEmpty()) break;
                    return stack.is(ItemTags.create((ResourceLocation)ResourceLocation.tryBuild((String)"c", (String)"tools/axes")));
                }
                case Pickaxe: {
                    ItemStack stack = player.getMainHandItem();
                    if (stack.isEmpty()) break;
                    return stack.is(ItemTags.create((ResourceLocation)ResourceLocation.tryBuild((String)"c", (String)"tools/pickaxes")));
                }
                case Shovel: {
                    ItemStack stack = player.getMainHandItem();
                    if (stack.isEmpty()) break;
                    return stack.is(ItemTags.create((ResourceLocation)ResourceLocation.tryBuild((String)"c", (String)"tools/shovels")));
                }
                case Wrench: {
                    ItemStack stack = player.getMainHandItem();
                    if (stack.isEmpty()) break;
                    return stack.is(ItemTags.create((ResourceLocation)ResourceLocation.tryBuild((String)"c", (String)"tools/wrench")));
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    public List<ItemStack> getDrops(Level world, BlockPos pos, BlockState state, Entity player) {
        ItemStack stack;
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            ItemStack stack2;
            te = drops.removeLast();
            if (te == null) {
                return new ArrayList<ItemStack>();
            }
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            boolean wasWrench = false;
            if (player instanceof Player && !(stack2 = ((Player)player).getMainHandItem()).isEmpty()) {
                wasWrench = stack2.is(ItemTags.create((ResourceLocation)ResourceLocation.tryBuild((String)"c", (String)"tools/wrench")));
            }
            int chance = te.getLevel().random.nextInt(100);
            ret.addAll(te.getSelfDrops(chance, wasWrench));
            ret.addAll(te.getAuxDrops(chance));
            return ret;
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        boolean wasWrench = false;
        if (player instanceof Player && !(stack = ((Player)player).getMainHandItem()).isEmpty()) {
            wasWrench = stack.is(ItemTags.create((ResourceLocation)ResourceLocation.tryBuild((String)"c", (String)"tools/wrench")));
        }
        int chance = te.getLevel().random.nextInt(100);
        ret.addAll(te.getSelfDrops(chance, wasWrench));
        ret.addAll(te.getAuxDrops(chance));
        return ret;
    }

    public void onRemove(BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, BlockState blockState2, boolean b) {
        TileEntityBlock te = BlockTileEntity.getTe(level, blockPos);
        if (te != null && blockState2.getBlock() != blockState.getBlock()) {
            te.onBlockBreak(false);
        }
        super.onRemove(blockState, level, blockPos, blockState2, b);
    }

    public void attack(BlockState p_60499_, Level world, BlockPos pos, Player player) {
        super.attack(p_60499_, world, pos, player);
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te != null) {
            te.onClicked(player);
        }
    }

    public boolean isCollisionShapeFullBlock(BlockState p_181242_, BlockGetter p_181243_, BlockPos p_181244_) {
        return super.isCollisionShapeFullBlock(p_181242_, p_181243_, p_181244_);
    }

    public ItemInteractionResult getResult(boolean result) {
        return result ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult getResult1(boolean result) {
        return result ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Pair<String, Integer> getHarvestLevel() {
        return new Pair((Object)((IMultiTileBlock)this.value).getHarvestTool().toolClass, (Object)1);
    }

    static {
        drops = new LinkedList();
    }
}

