/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.transport;

import com.denfop.api.sytem.InfoTile;
import com.denfop.api.transport.ITransportAcceptor;
import com.denfop.api.transport.ITransportConductor;
import com.denfop.api.transport.ITransportEmitter;
import com.denfop.api.transport.ITransportSink;
import com.denfop.api.transport.ITransportSource;
import com.denfop.api.transport.ITransportTile;
import com.denfop.api.transport.ItemFluidHandler;
import com.denfop.api.transport.TransportItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class TransportFluidItemSinkSource
implements ITransportSource,
ITransportSink {
    private final BlockPos pos;
    private final boolean isClientSide;
    Map<Direction, ItemFluidHandler> handlerMap = new HashMap<Direction, ItemFluidHandler>();
    Map<Direction, Integer> slotsMap = new HashMap<Direction, Integer>();
    Map<Direction, List<Integer>> limitsMap = new HashMap<Direction, List<Integer>>();
    Map<Direction, ITransportTile> energyConductorMap = new HashMap<Direction, ITransportTile>();
    boolean hasHashCode = false;
    int hashCodeSource;
    List<InfoTile<ITransportTile>> validReceivers = new LinkedList<InfoTile<ITransportTile>>();
    List<Integer> energyTickList = new LinkedList<Integer>();
    private boolean isSink;
    private boolean isSource;
    private boolean isSinkFluid;
    private boolean isSourceFluid;
    private long id;
    private int hashCode;

    public TransportFluidItemSinkSource(BlockEntity parent, BlockPos pos) {
        this.isClientSide = parent.getLevel().isClientSide;
        this.pos = pos;
        boolean isItem = false;
        boolean isFluid = false;
        for (Direction facing : Direction.values()) {
            int slots1;
            IItemHandler item_storage = (IItemHandler)parent.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)facing);
            IFluidHandler fluid_storage = (IFluidHandler)parent.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)facing);
            if (!isFluid && fluid_storage != null) {
                isFluid = true;
            }
            if (!isItem && item_storage != null) {
                isItem = true;
            }
            try {
                slots1 = item_storage.getSlots();
            }
            catch (Exception exception) {
                slots1 = 0;
            }
            this.handlerMap.put(facing, new ItemFluidHandler(item_storage, fluid_storage));
            this.slotsMap.put(facing, slots1);
            ArrayList<Integer> list_limits = new ArrayList<Integer>();
            for (int i = 0; i < slots1; ++i) {
                list_limits.add(item_storage.getSlotLimit(i));
            }
            this.limitsMap.put(facing, list_limits);
        }
        this.isSink = isItem;
        this.isSource = isItem;
        this.isSinkFluid = isFluid;
        this.isSourceFluid = isFluid;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void RemoveTile(ITransportTile tile, Direction facing1) {
        if (!this.isClientSide) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<ITransportTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<ITransportTile> tileInfoTile = iter.next();
                if (!((ITransportTile)tileInfoTile.tileEntity).getPos().equals((Object)tile.getPos())) continue;
                iter.remove();
                break;
            }
        }
    }

    public int hashCode() {
        if (!this.hasHashCode) {
            this.hasHashCode = true;
            this.hashCode = super.hashCode();
            return this.hashCode;
        }
        return this.hashCode;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public Map<Direction, ITransportTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public List<InfoTile<ITransportTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public void AddTile(ITransportTile tile, Direction facing1) {
        if (!this.isClientSide && !this.energyConductorMap.containsKey(facing1)) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<ITransportTile>(tile, facing1.getOpposite()));
        }
    }

    @Override
    public boolean emitsTo(ITransportAcceptor var1, Direction var2) {
        if (this.isSource && this.handlerMap.get(var2).getItemHandler() instanceof IItemHandler && var1 instanceof ITransportConductor) {
            return true;
        }
        return this.isSourceFluid && this.handlerMap.get(var2).getFluidHandler() instanceof IFluidHandler && var1 instanceof ITransportConductor;
    }

    public TransportItem<?> getOffered(int type, Direction facing) {
        TransportItem transportItem;
        if (type == 0) {
            TransportItem itemTransportItem = new TransportItem();
            LinkedList<ItemStack> itemStackList = new LinkedList<ItemStack>();
            LinkedList<Integer> integerList = new LinkedList<Integer>();
            int slots = this.slotsMap.get(facing);
            List<Integer> list_limits = this.limitsMap.get(facing);
            for (int i = 0; i < slots; ++i) {
                ItemStack stack = this.handlerMap.get(facing).getItemHandler().extractItem(i, list_limits.get(i).intValue(), true);
                if (stack.isEmpty()) continue;
                itemStackList.add(stack);
                integerList.add(i);
            }
            itemTransportItem.setList(itemStackList);
            itemTransportItem.setList1(integerList);
            transportItem = itemTransportItem;
        } else {
            TransportItem fluidTransportItem = new TransportItem();
            LinkedList<FluidStack> fluidStackList = new LinkedList<FluidStack>();
            IFluidHandler handler = this.handlerMap.get(facing).getFluidHandler();
            int fluidTanks = handler.getTanks();
            for (int i = 0; i < fluidTanks; ++i) {
                FluidStack contents = handler.getFluidInTank(i);
                if (handler.drain(contents, IFluidHandler.FluidAction.SIMULATE).isEmpty() || contents.isEmpty()) continue;
                fluidStackList.add(contents);
            }
            fluidTransportItem.setList(fluidStackList);
            transportItem = fluidTransportItem;
        }
        return transportItem;
    }

    public void draw(Object var, int col, Direction facing) {
        if (this.isSource && var instanceof ItemStack) {
            this.handlerMap.get(facing).getItemHandler().extractItem(col, ((ItemStack)var).getCount(), false);
        }
        if (this.isSourceFluid && var instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)var;
            fluidStack.setAmount(col);
            this.handlerMap.get(facing).getFluidHandler().drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public boolean isItem() {
        return this.isSource;
    }

    @Override
    public boolean isFluid() {
        return this.isSourceFluid;
    }

    @Override
    public boolean isSource() {
        return this.isSource || this.isSourceFluid;
    }

    @Override
    public Object getHandler(Direction facing) {
        ItemFluidHandler handler = this.handlerMap.get(facing);
        if (handler.getFluidHandler() != null && handler.getItemHandler() != null) {
            return handler;
        }
        if (handler.getFluidHandler() == null) {
            return handler.getItemHandler();
        }
        if (handler.getItemHandler() == null) {
            return handler.getFluidHandler();
        }
        return handler;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public boolean acceptsFrom(ITransportEmitter var1, Direction var2) {
        Object handler = var1.getHandler(var2);
        if (this.isSink && handler instanceof IItemHandler && var1 instanceof ITransportConductor) {
            return true;
        }
        return this.isSinkFluid && handler instanceof IFluidHandler && var1 instanceof ITransportConductor;
    }

    @Override
    public List<Integer> getDemanded(Direction facing) {
        if (!this.isSink) {
            return Collections.emptyList();
        }
        LinkedList<Integer> demandedSlots = new LinkedList<Integer>();
        List<Integer> list_limits = this.limitsMap.get(facing);
        for (int i = 0; i < list_limits.size(); ++i) {
            ItemStack stack = this.handlerMap.get(facing).getStackInSlot(i);
            int limit = list_limits.get(i);
            int maxStackSize = stack.getMaxStackSize();
            if (!stack.isEmpty() && stack.getCount() >= Math.min(limit, maxStackSize)) continue;
            demandedSlots.add(i);
        }
        return demandedSlots;
    }

    @Override
    public boolean isSink() {
        return this.isSink || this.isSinkFluid;
    }

    @Override
    public List<Integer> getEnergyTickList() {
        return this.energyTickList;
    }

    @Override
    public boolean isItemSink() {
        return this.isSink;
    }

    @Override
    public boolean isFluidSink() {
        return this.isSinkFluid;
    }
}

