/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.upgrades;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.api.space.rovers.enums.EnumTypeUpgrade;
import com.denfop.api.space.upgrades.api.ISpaceUpgradeSystem;
import com.denfop.api.space.upgrades.event.EventItemLoad;
import com.denfop.api.space.upgrades.info.SpaceUpgradeItemInform;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.UpgradeRover;
import com.denfop.recipe.IInputHandler;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;

public class BaseSpaceUpgradeSystem
implements ISpaceUpgradeSystem {
    public static List<Runnable> list = new ArrayList<Runnable>();
    int max = 0;

    public BaseSpaceUpgradeSystem() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public static void addupgrade(Item container, ItemStack fill) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("roverupgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)container, 1)), input.getInput(fill)), new RecipeOutput(null, new ItemStack((ItemLike)container, 1))));
    }

    @SubscribeEvent
    public void loadItem(EventItemLoad event) {
        this.updateListFromNBT(event.item, event.stack);
    }

    @Override
    public int getRemaining(ItemStack item) {
        return 24 - ((UpgradeRover)item.get(DataComponentsInit.UPGRADE_ROVER)).amount();
    }

    @Override
    public boolean hasInMap(ItemStack stack) {
        return stack.has(DataComponentsInit.UPGRADE_ROVER) && !((UpgradeRover)stack.get(DataComponentsInit.UPGRADE_ROVER)).equals(UpgradeRover.EMPTY);
    }

    @Override
    public List<SpaceUpgradeItemInform> getInformation(ItemStack item) {
        return ((UpgradeRover)item.getOrDefault(DataComponentsInit.UPGRADE_ROVER, (Object)UpgradeRover.EMPTY)).upgradeItemInforms();
    }

    @Override
    public SpaceUpgradeItemInform getModules(EnumTypeUpgrade module, ItemStack item) {
        List<SpaceUpgradeItemInform> list = this.getInformation(item);
        for (SpaceUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public boolean hasModules(EnumTypeUpgrade module, ItemStack item) {
        if (!(item.getItem() instanceof IRoversItem)) {
            return false;
        }
        List<SpaceUpgradeItemInform> list = this.getInformation(item);
        for (SpaceUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateListFromNBT(IRoversItem item, ItemStack stack) {
        int modesTagList;
        int ost;
        boolean hasID;
        UpgradeRover upgradeItem = (UpgradeRover)stack.getOrDefault(DataComponentsInit.UPGRADE_ROVER, (Object)UpgradeRover.EMPTY);
        boolean bl = hasID = upgradeItem == UpgradeRover.EMPTY;
        if (!hasID) {
            ++this.max;
            upgradeItem = (UpgradeRover)stack.set(DataComponentsInit.UPGRADE_ROVER, (Object)UpgradeRover.EMPTY.copy());
        }
        upgradeItem = upgradeItem.updateCanUpgrade(stack, (ost = 24 - (modesTagList = upgradeItem.amount())) > 0);
    }

    @Override
    public void setInformation(IRoversItem item, List<EnumTypeUpgrade> lst, ItemStack stack) {
        this.write(item, lst, stack);
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        this.max = 0;
    }

    @Override
    public void write(IRoversItem item, List<EnumTypeUpgrade> lst, ItemStack stack) {
    }

    private int getModulesValue(EnumTypeUpgrade module, ItemStack stack) {
        SpaceUpgradeItemInform modules = this.getModules(module, stack);
        if (modules == null) {
            return 0;
        }
        return modules.number;
    }

    @Override
    public void removeUpdate(ItemStack stack, Level world, int index) {
    }

    @Override
    public List<ItemStack> getListStack(ItemStack stack) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        return list;
    }

    @Override
    public void addRecipe(Item stack, EnumTypeUpgrade ... lst) {
        for (EnumTypeUpgrade upgrades : lst) {
            BaseSpaceUpgradeSystem.addupgrade(stack, new ItemStack((ItemLike)IUItem.spaceupgrademodule.getStack(upgrades.ordinal()), 1));
        }
    }

    @Override
    public boolean shouldUpdate(EnumTypeUpgrade type, ItemStack stack1) {
        List<SpaceUpgradeItemInform> list = this.getInformation(stack1);
        for (SpaceUpgradeItemInform inform : list) {
            if (inform.upgrade != type || inform.number < type.getMax()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getAvailableUpgrade(IRoversItem iUpgradeItem, ItemStack item) {
        UpgradeRover upgradeItem = (UpgradeRover)item.getOrDefault(DataComponentsInit.UPGRADE_ROVER, (Object)UpgradeRover.EMPTY);
        List<SpaceUpgradeItemInform> list = upgradeItem.upgradeItemInforms();
        List<EnumTypeUpgrade> list1 = iUpgradeItem.getUpgradeModules();
        LinkedList<CallSite> stringList = new LinkedList<CallSite>();
        block0: for (EnumTypeUpgrade enumInfoUpgradeModules : list1) {
            for (SpaceUpgradeItemInform upgradeItemInform : list) {
                if (!upgradeItemInform.upgrade.equals((Object)enumInfoUpgradeModules)) continue;
                if (upgradeItemInform.number >= upgradeItemInform.upgrade.getMax()) continue block0;
                stringList.add((CallSite)((Object)(String.valueOf(ChatFormatting.GREEN) + (upgradeItemInform.upgrade.getMax() - upgradeItemInform.number) + "x " + new ItemStack((ItemLike)IUItem.spaceupgrademodule.getStack(enumInfoUpgradeModules.ordinal()), 1).getDisplayName().getString())));
                continue block0;
            }
            stringList.add((CallSite)((Object)(String.valueOf(ChatFormatting.GREEN) + enumInfoUpgradeModules.getMax() + "x " + new ItemStack((ItemLike)IUItem.spaceupgrademodule.getStack(enumInfoUpgradeModules.ordinal()), 1).getDisplayName().getString())));
        }
        return list != null ? stringList : Collections.emptyList();
    }
}

