/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies.enums;

public enum EnumMiningFactory {
    LOW(10, 15, 15, 5, 1, 10),
    MEDIUM(20, 20, 25, 15, 2, 18),
    HIGH(40, 30, 40, 30, 5, 29);

    private final byte energy;
    private final byte needPeople;
    private final byte chance;
    private final byte maxValue;
    private final byte maxItemValue;
    private final byte level;

    private EnumMiningFactory(int energy, int needPeople, int chance, int maxValue, int maxValueItem, int level) {
        this.energy = (byte)energy;
        this.needPeople = (byte)needPeople;
        this.chance = (byte)chance;
        this.maxValue = (byte)maxValue;
        this.maxItemValue = (byte)maxValueItem;
        this.level = (byte)level;
    }

    public static EnumMiningFactory getID(int id) {
        return EnumMiningFactory.values()[id % EnumMiningFactory.values().length];
    }

    public byte getLevel() {
        return this.level;
    }

    public int getEnergy() {
        return this.energy;
    }

    public byte getChance() {
        return this.chance;
    }

    public byte getMaxValue() {
        return this.maxValue;
    }

    public byte getMaxItemValue() {
        return this.maxItemValue;
    }

    public int getNeedPeople() {
        return this.needPeople;
    }
}

