/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.multiblock;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.multiblock.IMainMultiBlock;
import com.denfop.api.multiblock.IMultiElement;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MultiBlockStructure {
    public final Map<BlockPos, Class<? extends IMultiElement>> blockPosMap = new HashMap<BlockPos, Class<? extends IMultiElement>>();
    public final Map<BlockPos, ItemStack> ItemStackMap = new HashMap<BlockPos, ItemStack>();
    public final List<ItemStack> itemStackList = new ArrayList<ItemStack>();
    public final Map<BlockPos, Direction> RotationMap = new HashMap<BlockPos, Direction>();
    public final Map<BlockPos, BakedModel> bakedModelMap = new HashMap<BlockPos, BakedModel>();
    public final BlockPos pos;
    private final Map<Class<? extends IMultiElement>, String> reportLaskBlock = new HashMap<Class<? extends IMultiElement>, String>();
    public boolean hasActivatedItem = false;
    public int height;
    public int weight;
    public int length;
    public int maxHeight;
    public int minHeight;
    public int maxWeight;
    public int minWeight;
    public int maxLength;
    public int minLength;
    public boolean ignoreMetadata = false;
    public ItemStack activateItem = ItemStack.EMPTY;
    public boolean hasUniqueModels = false;
    private Class<? extends IMainMultiBlock> main;

    public MultiBlockStructure() {
        this.pos = BlockPos.ZERO;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getHeight() {
        return this.height + 1;
    }

    public int getLength() {
        return this.length + 1;
    }

    public int getWeight() {
        return this.weight + 1;
    }

    public MultiBlockStructure setIgnoreMetadata(boolean ignoreMetadata) {
        this.ignoreMetadata = ignoreMetadata;
        return this;
    }

    public MultiBlockStructure setUniqueModel() {
        this.hasUniqueModels = true;
        return this;
    }

    public boolean isHasUniqueModels() {
        return this.hasUniqueModels;
    }

    public ItemStack getActivateItem() {
        return this.activateItem;
    }

    public MultiBlockStructure setActivateItem(ItemStack activateItem) {
        this.activateItem = activateItem;
        return this;
    }

    public boolean isActivateItem(ItemStack stack) {
        assert (stack != null);
        assert (!stack.isEmpty());
        return this.activateItem.getItem() == stack.getItem();
    }

    public boolean isHasActivatedItem() {
        return this.hasActivatedItem;
    }

    public MultiBlockStructure setHasActivatedItem(boolean hasActivatedItem) {
        this.hasActivatedItem = hasActivatedItem;
        return this;
    }

    public void add(BlockPos pos, Class<? extends IMultiElement> class1, ItemStack stack) {
        if (this.blockPosMap.containsKey(pos)) {
            return;
        }
        boolean found = false;
        for (ItemStack stack1 : this.itemStackList) {
            if (stack1.getItem() != stack.getItem()) continue;
            stack1.grow(stack.getCount());
            found = true;
            break;
        }
        if (!found) {
            this.itemStackList.add(stack.copy());
        }
        this.blockPosMap.put(pos, class1);
        this.ItemStackMap.put(pos, stack);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (y < this.minHeight) {
            this.minHeight = y;
        }
        if (y > this.maxHeight) {
            this.maxHeight = y;
        }
        if (x < this.minLength) {
            this.minLength = x;
        }
        if (x > this.maxLength) {
            this.maxLength = x;
        }
        if (z < this.minWeight) {
            this.minWeight = z;
        }
        if (z > this.maxWeight) {
            this.maxWeight = z;
        }
        this.height = this.maxHeight - this.minHeight;
        this.weight = this.maxWeight - this.minWeight;
        this.length = this.maxLength - this.minLength;
    }

    public List<ItemStack> getItemStackList() {
        return this.itemStackList;
    }

    public void add(BlockPos pos, Class<? extends IMultiElement> class1, ItemStack stack, Direction rotation) {
        if (this.blockPosMap.containsKey(pos)) {
            return;
        }
        boolean found = false;
        for (ItemStack stack1 : this.itemStackList) {
            if (stack1.getItem() != stack.getItem()) continue;
            stack1.grow(stack.getCount());
            found = true;
            break;
        }
        if (!found) {
            this.itemStackList.add(stack.copy());
        }
        this.blockPosMap.put(pos, class1);
        this.ItemStackMap.put(pos, stack);
        this.RotationMap.put(pos, rotation);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (y < this.minHeight) {
            this.minHeight = y;
        }
        if (y > this.maxHeight) {
            this.maxHeight = y;
        }
        if (x < this.minLength) {
            this.minLength = x;
        }
        if (x > this.maxLength) {
            this.maxLength = x;
        }
        if (z < this.minWeight) {
            this.minWeight = z;
        }
        if (z > this.maxWeight) {
            this.maxWeight = z;
        }
        this.height = this.maxHeight - this.minHeight;
        this.weight = this.maxWeight - this.minWeight;
        this.length = this.maxLength - this.minLength;
    }

    public List<BlockPos> getPosFromClass(Direction facing, BlockPos pos, Class<? extends IMultiElement> class1) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
            BlockPos pos1 = switch (facing) {
                case Direction.NORTH -> pos.offset((Vec3i)entry.getKey());
                case Direction.EAST -> pos.offset(entry.getKey().getZ() * -1, entry.getKey().getY(), entry.getKey().getX());
                case Direction.WEST -> pos.offset(entry.getKey().getZ(), entry.getKey().getY(), entry.getKey().getX() * -1);
                case Direction.SOUTH -> pos.offset(entry.getKey().getX() * -1, entry.getKey().getY(), entry.getKey().getZ() * -1);
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
            };
            if (entry.getValue() != class1) continue;
            blockPosList.add(pos1);
        }
        return blockPosList;
    }

    public List<BlockPos> getPoses(Direction facing, BlockPos pos) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
            blockPosList.add(switch (facing) {
                case Direction.NORTH -> pos.offset((Vec3i)entry.getKey());
                case Direction.EAST -> pos.offset(entry.getKey().getZ() * -1, entry.getKey().getY(), entry.getKey().getX());
                case Direction.WEST -> pos.offset(entry.getKey().getZ(), entry.getKey().getY(), entry.getKey().getX() * -1);
                case Direction.SOUTH -> pos.offset(entry.getKey().getX() * -1, entry.getKey().getY(), entry.getKey().getZ() * -1);
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
            });
        }
        return blockPosList;
    }

    public boolean getFull(Direction facing, BlockPos pos, Level world, Player player) {
        IMainMultiBlock mainTile = (IMainMultiBlock)world.getBlockEntity(pos);
        if (mainTile == null) {
            return false;
        }
        for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
            if (entry.getValue() == this.main) continue;
            BlockPos pos1 = switch (facing) {
                case Direction.NORTH -> pos.offset((Vec3i)entry.getKey());
                case Direction.EAST -> pos.offset(entry.getKey().getZ() * -1, entry.getKey().getY(), entry.getKey().getX());
                case Direction.WEST -> pos.offset(entry.getKey().getZ(), entry.getKey().getY(), entry.getKey().getX() * -1);
                case Direction.SOUTH -> pos.offset(entry.getKey().getX() * -1, entry.getKey().getY(), entry.getKey().getZ() * -1);
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
            };
            BlockEntity tile = world.getBlockEntity(pos1);
            if (entry.getValue() == null) {
                BlockState blockstate = world.getBlockState(pos1);
                if (blockstate.isAir()) continue;
                return false;
            }
            if (!entry.getValue().isInstance(tile)) {
                String report = this.reportLaskBlock.get(entry.getValue());
                if (report != null && !report.isEmpty()) {
                    if (!world.isClientSide) {
                        IUCore.proxy.messagePlayer(player, Localization.translate("iu.not.found") + "x: " + pos1.getX() + " y: " + pos1.getY() + " z: " + pos1.getZ() + " " + Localization.translate(report));
                    }
                } else if (!world.isClientSide) {
                    IUCore.proxy.messagePlayer(player, Localization.translate("iu.not.found") + "x: " + pos1.getX() + " y: " + pos1.getY() + " z: " + pos1.getZ() + " " + this.ItemStackMap.get(entry.getKey()).getDisplayName().getString());
                }
                return false;
            }
            IMultiElement element = (IMultiElement)tile;
            if (element.isMain() && element.getMain() != mainTile || element.getBlockLevel() != mainTile.getBlockLevel() && element.getBlockLevel() != -1 || !element.canCreateSystem(mainTile)) {
                return false;
            }
            if (element.getMain() != null && element.getMain() != mainTile) {
                IMainMultiBlock mainTwo = element.getMain();
                element.setMainMultiElement(mainTile);
                mainTwo.updateFull();
                if (!mainTwo.wasActivated()) continue;
                mainTwo.setActivated(false);
                continue;
            }
            if (element.getMain() != null) continue;
            element.setMainMultiElement(mainTile);
        }
        return true;
    }

    public boolean getFull(Direction facing, BlockPos pos, Level world) {
        IMainMultiBlock mainTile = (IMainMultiBlock)world.getBlockEntity(pos);
        for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
            if (entry.getValue() == this.main) continue;
            BlockPos pos1 = switch (facing) {
                case Direction.NORTH -> pos.offset((Vec3i)entry.getKey());
                case Direction.EAST -> pos.offset(entry.getKey().getZ() * -1, entry.getKey().getY(), entry.getKey().getX());
                case Direction.WEST -> pos.offset(entry.getKey().getZ(), entry.getKey().getY(), entry.getKey().getX() * -1);
                case Direction.SOUTH -> pos.offset(entry.getKey().getX() * -1, entry.getKey().getY(), entry.getKey().getZ() * -1);
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
            };
            BlockEntity tile = world.getBlockEntity(pos1);
            if (entry.getValue() == null) {
                BlockState blockstate = world.getBlockState(pos1);
                if (blockstate.isAir()) continue;
                return false;
            }
            if (!entry.getValue().isInstance(tile)) {
                return false;
            }
            IMultiElement element = (IMultiElement)tile;
            if (element.getMain() != null && element.getMain() != mainTile || element.getBlockLevel() != mainTile.getBlockLevel() && element.getBlockLevel() != -1 || !element.canCreateSystem(mainTile)) {
                return false;
            }
            if (element.getMain() != null) continue;
            element.setMainMultiElement(mainTile);
        }
        return true;
    }

    public MultiBlockStructure setMain(Class<? extends IMainMultiBlock> main) {
        this.main = main;
        return this;
    }

    public void addReport(Class<? extends IMultiElement> name, String report) {
        this.reportLaskBlock.put(name, report);
    }

    public void markDirty(TileMultiBlockBase tileMultiBlockBase, boolean full) {
        ArrayList<ChunkPos> passedChunk = new ArrayList<ChunkPos>();
        if (full) {
            for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
                BlockEntity tile;
                if (entry.getValue() == this.main) continue;
                Level world = tileMultiBlockBase.getLevel();
                BlockPos pos1 = null;
                BlockPos pos = tileMultiBlockBase.getBlockPos();
                if (!((tile = world.getBlockEntity(pos1 = (switch (tileMultiBlockBase.getFacing()) {
                    case Direction.NORTH -> pos.offset((Vec3i)entry.getKey());
                    case Direction.EAST -> pos.offset(entry.getKey().getZ() * -1, entry.getKey().getY(), entry.getKey().getX());
                    case Direction.WEST -> pos.offset(entry.getKey().getZ(), entry.getKey().getY(), entry.getKey().getX() * -1);
                    case Direction.SOUTH -> pos.offset(entry.getKey().getX() * -1, entry.getKey().getY(), entry.getKey().getZ() * -1);
                    default -> pos1;
                }))) instanceof TileEntityMultiBlockElement)) continue;
                TileEntityMultiBlockElement te = (TileEntityMultiBlockElement)world.getBlockEntity(pos1);
                te.setMainMultiElement(tileMultiBlockBase);
                ChunkPos chunkPos = new ChunkPos(pos1);
                if (passedChunk.contains(chunkPos)) continue;
                passedChunk.add(chunkPos);
            }
        } else {
            for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
                BlockEntity tile;
                if (entry.getValue() == this.main) continue;
                Level world = tileMultiBlockBase.getLevel();
                BlockPos pos1 = null;
                BlockPos pos = tileMultiBlockBase.getBlockPos();
                switch (tileMultiBlockBase.getFacing()) {
                    case NORTH: {
                        pos1 = pos.offset((Vec3i)entry.getKey());
                        break;
                    }
                    case EAST: {
                        pos1 = pos.offset(entry.getKey().getZ() * -1, entry.getKey().getY(), entry.getKey().getX());
                        break;
                    }
                    case WEST: {
                        pos1 = pos.offset(entry.getKey().getZ(), entry.getKey().getY(), entry.getKey().getX() * -1);
                        break;
                    }
                    case SOUTH: {
                        pos1 = pos.offset(entry.getKey().getX() * -1, entry.getKey().getY(), entry.getKey().getZ() * -1);
                    }
                }
                if (!((tile = world.getBlockEntity(pos1)) instanceof TileEntityMultiBlockElement)) continue;
                TileEntityMultiBlockElement te = (TileEntityMultiBlockElement)world.getBlockEntity(pos1);
                te.setMainMultiElement(null);
                ChunkPos chunkPos = new ChunkPos(pos1);
                if (passedChunk.contains(chunkPos)) continue;
                passedChunk.add(chunkPos);
            }
        }
    }
}

