/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.Localization;
import com.denfop.api.cool.ICoolSink;
import com.denfop.api.gui.EnumTypeRender;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.heat.IHeatSink;
import com.denfop.blocks.FluidName;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.ComponentBioFuelEnergy;
import com.denfop.componets.ComponentBioProcessRender;
import com.denfop.componets.ComponentButton;
import com.denfop.componets.ComponentProcessRender;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.ComponentSteamProcessRender;
import com.denfop.componets.ComponentTimer;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.PressureComponent;
import com.denfop.utils.ModUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class Component<T> {
    private final T component;

    public Component(T component) {
        this.component = component;
    }

    public T getComponent() {
        return this.component;
    }

    public boolean visible() {
        return true;
    }

    public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY, GuiComponent guiComponent) {
        if (this.visible()) {
            if (this.component instanceof Energy) {
                Energy component = (Energy)this.component;
                double fillratio = component.getFillRatio();
                fillratio = Math.min(1.0, fillratio);
                if (guiComponent.getType().getRender() == EnumTypeRender.HEIGHT) {
                    int chargeLevel = (int)(fillratio *= (double)guiComponent.getType().getHeight());
                    guiComponent.getGui().drawTexturedModalRect(poseStack, mouseX + guiComponent.getX() + guiComponent.getType().getEndX(), mouseY + guiComponent.getType().getEndY() + guiComponent.getY() + guiComponent.getType().getHeight() - chargeLevel, guiComponent.getType().getX1(), guiComponent.getType().getY1() + guiComponent.getType().getHeight() - chargeLevel, guiComponent.getType().getWeight(), chargeLevel);
                } else {
                    int chargeLevel = (int)(fillratio *= (double)guiComponent.getType().getWeight());
                    guiComponent.getGui().drawTexturedModalRect(poseStack, mouseX + guiComponent.getX() + guiComponent.getType().getEndX(), mouseY + guiComponent.getType().getEndY() + guiComponent.getY(), guiComponent.getType().getX1(), guiComponent.getType().getY1(), chargeLevel, guiComponent.getType().getHeight());
                }
            } else if (this.component instanceof ComponentSteamEnergy) {
                ComponentSteamEnergy component = (ComponentSteamEnergy)this.component;
                if (component != null && component.buffer.storage >= 1.0) {
                    FluidStack fs = new FluidStack((Fluid)FluidName.fluidsteam.getInstance().get(), 1);
                    int fluidX = guiComponent.x + 1;
                    int fluidY = guiComponent.y + 1;
                    int fluidWidth = 16;
                    int fluidHeight = 16;
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = GuiElement.getBlockTextureMap().getSprite(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    GuiElement.bindBlockTexture();
                    guiComponent.getGui().drawSprite(poseStack, mouseX + fluidX, mouseY + fluidY, fluidWidth, fluidHeight, sprite, color, 1.0, false, false);
                }
            } else if (this.component instanceof ComponentBioFuelEnergy) {
                ComponentBioFuelEnergy component = (ComponentBioFuelEnergy)this.component;
                if (component != null && component.buffer.storage >= 1.0) {
                    FluidStack fs = new FluidStack((Fluid)FluidName.fluidbiomass.getInstance().get(), 1);
                    int fluidX = guiComponent.x + 1;
                    int fluidY = guiComponent.y + 1;
                    int fluidWidth = 16;
                    int fluidHeight = 16;
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = GuiElement.getBlockTextureMap().getSprite(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    GuiElement.bindBlockTexture();
                    guiComponent.getGui().drawSprite(poseStack, mouseX + fluidX, mouseY + fluidY, fluidWidth, fluidHeight, sprite, color, 1.0, false, false);
                }
            } else if (this.component instanceof ComponentBaseEnergy) {
                ComponentBaseEnergy component = (ComponentBaseEnergy)this.component;
                double fillratio = component.buffer.storage / component.buffer.capacity;
                if (guiComponent.getType().getRender() == EnumTypeRender.HEIGHT) {
                    int chargeLevel = (int)(fillratio *= (double)guiComponent.getType().getHeight());
                    guiComponent.getGui().drawTexturedModalRect(poseStack, mouseX + guiComponent.getX() + guiComponent.getType().getEndX(), mouseY + guiComponent.getType().getEndY() + guiComponent.getY() + guiComponent.getType().getHeight() - chargeLevel, guiComponent.getType().getX1(), guiComponent.getType().getY1() + guiComponent.getType().getHeight() - chargeLevel, guiComponent.getType().getWeight(), chargeLevel);
                } else {
                    int chargeLevel = (int)(fillratio *= (double)guiComponent.getType().getWeight());
                    guiComponent.getGui().drawTexturedModalRect(poseStack, mouseX + guiComponent.getX() + guiComponent.getType().getEndX(), mouseY + guiComponent.getType().getEndY() + guiComponent.getY(), guiComponent.getType().getX1(), guiComponent.getType().getY1(), chargeLevel, guiComponent.getType().getHeight());
                }
            } else if (this.component instanceof CoolComponent) {
                CoolComponent component = (CoolComponent)this.component;
                double fillratio = component.buffer.storage / component.buffer.capacity;
                if (guiComponent.getType().getRender() == EnumTypeRender.HEIGHT) {
                    int chargeLevel = (int)(fillratio *= (double)guiComponent.getType().getHeight());
                    guiComponent.getGui().drawTexturedModalRect(poseStack, mouseX + guiComponent.getX() + guiComponent.getType().getEndX(), mouseY + guiComponent.getType().getEndY() + guiComponent.getY() + guiComponent.getType().getHeight() - chargeLevel, guiComponent.getType().getX1(), guiComponent.getType().getY1() + guiComponent.getType().getHeight() - chargeLevel, guiComponent.getType().getWeight(), chargeLevel);
                } else {
                    int chargeLevel = (int)(fillratio *= (double)guiComponent.getType().getWeight());
                    guiComponent.getGui().drawTexturedModalRect(poseStack, mouseX + guiComponent.getX() + guiComponent.getType().getEndX(), mouseY + guiComponent.getType().getEndY() + guiComponent.getY(), guiComponent.getType().getX1(), guiComponent.getType().getY1(), chargeLevel, guiComponent.getType().getHeight());
                }
            } else if (this.component instanceof HeatComponent) {
                HeatComponent component = (HeatComponent)this.component;
                double fillratio = component.buffer.storage / component.buffer.capacity;
                if (guiComponent.getType().getRender() == EnumTypeRender.HEIGHT) {
                    int chargeLevel = (int)(fillratio *= (double)guiComponent.getType().getHeight());
                    guiComponent.getGui().drawTexturedModalRect(poseStack, mouseX + guiComponent.getX() + guiComponent.getType().getEndX(), mouseY + guiComponent.getType().getEndY() + guiComponent.getY() + guiComponent.getType().getHeight() - chargeLevel, guiComponent.getType().getX1(), guiComponent.getType().getY1() + guiComponent.getType().getHeight() - chargeLevel, guiComponent.getType().getWeight(), chargeLevel);
                } else {
                    int chargeLevel = (int)(fillratio *= (double)guiComponent.getType().getWeight());
                    guiComponent.getGui().drawTexturedModalRect(poseStack, mouseX + guiComponent.getX() + guiComponent.getType().getEndX(), mouseY + guiComponent.getType().getEndY() + guiComponent.getY(), guiComponent.getType().getX1(), guiComponent.getType().getY1(), chargeLevel, guiComponent.getType().getHeight());
                }
            } else if (this.component instanceof FluidTank) {
                FluidTank component = (FluidTank)this.component;
                double fillratio = (double)component.getFluidAmount() * 1.0 / (double)component.getCapacity();
                if (guiComponent.getType().getRender() == EnumTypeRender.HEIGHT) {
                    int chargeLevel = (int)(fillratio *= (double)guiComponent.getType().getHeight());
                    guiComponent.getGui().drawTexturedModalRect(poseStack, mouseX + guiComponent.getX() + guiComponent.getType().getEndX(), mouseY + guiComponent.getType().getEndY() + guiComponent.getY() + guiComponent.getType().getHeight() - chargeLevel, guiComponent.getType().getX1(), guiComponent.getType().getY1() + guiComponent.getType().getHeight() - chargeLevel, guiComponent.getType().getWeight(), chargeLevel);
                } else {
                    int chargeLevel = (int)(fillratio *= (double)guiComponent.getType().getWeight());
                    guiComponent.getGui().drawTexturedModalRect(poseStack, mouseX + guiComponent.getX() + guiComponent.getType().getEndX(), mouseY + guiComponent.getType().getEndY() + guiComponent.getY(), guiComponent.getType().getX1(), guiComponent.getType().getY1(), chargeLevel + 1, guiComponent.getType().getHeight());
                }
            }
        }
    }

    public String getText(GuiComponent guiComponent) {
        Object text = "";
        if (this.component instanceof ComponentButton) {
            ComponentButton component = (ComponentButton)this.component;
            text = component.getText();
        } else if (this.component instanceof Energy) {
            Energy component = (Energy)this.component;
            text = ModUtils.getString(Math.min(component.getEnergy(), component.getCapacity())) + "/" + ModUtils.getString(component.getCapacity()) + " EF";
        } else if (this.component instanceof PressureComponent) {
            PressureComponent component = (PressureComponent)this.component;
            text = "Pressure: " + ModUtils.getString(Math.min(component.getEnergy(), component.getCapacity())) + "/" + ModUtils.getString(component.getCapacity());
        } else if (this.component instanceof ComponentTimer) {
            text = ((ComponentTimer)this.component).getTime();
        } else if (this.component instanceof ComponentProgress) {
            text = ModUtils.getString(Math.min(100.0, ((ComponentProgress)this.component).getBar() * 100.0)) + "%";
        } else if (this.component instanceof ComponentBaseEnergy) {
            ComponentBaseEnergy component = (ComponentBaseEnergy)this.component;
            text = ModUtils.getString(Math.min(component.getEnergy(), component.getCapacity())) + "/" + ModUtils.getString(component.getCapacity()) + component.getType().getPrefix();
        } else if (this.component instanceof ComponentProcessRender) {
            ComponentProcessRender component = (ComponentProcessRender)this.component;
            text = ModUtils.getString(component.getProcess().getProgress(guiComponent.getIndex()) * 100.0) + "%";
        } else if (this.component instanceof ComponentSteamProcessRender) {
            ComponentSteamProcessRender component = (ComponentSteamProcessRender)this.component;
            text = ModUtils.getString(component.getProcess().getProgress(guiComponent.getIndex()) * 100.0) + "%";
        } else if (this.component instanceof ComponentBioProcessRender) {
            ComponentBioProcessRender component = (ComponentBioProcessRender)this.component;
            text = ModUtils.getString(component.getProcess().getProgress(guiComponent.getIndex()) * 100.0) + "%";
        } else if (this.component instanceof CoolComponent) {
            CoolComponent component = (CoolComponent)this.component;
            if (component.delegate == null) {
                component.createDelegate();
            }
            if (component.delegate instanceof ICoolSink) {
                text = ModUtils.getString(component.getEnergy()) + "\u00b0C/" + ModUtils.getString(component.getCapacity()) + "\u00b0C";
                if (component.getEnergy() == 100.0) {
                    text = (String)text + "\n" + Localization.translate("iu.need_colling2");
                } else if (component.getEnergy() >= 50.0 && component.getEnergy() < 100.0) {
                    text = (String)text + "\n" + Localization.translate("iu.need_colling1");
                } else if (component.getEnergy() < 50.0 && component.getEnergy() > 10.0) {
                    text = (String)text + "\n" + Localization.translate("iu.need_colling");
                }
            } else {
                text = "-" + component.getEnergy() + "\u00b0C/-" + component.getCapacity();
            }
        } else if (this.component instanceof HeatComponent) {
            HeatComponent component = (HeatComponent)this.component;
            if (component.delegate == null) {
                component.createDelegate();
            }
            text = ModUtils.getString(component.getEnergy()) + "\u00b0C/" + ModUtils.getString(component.getCapacity()) + "\u00b0C";
            if (component.delegate instanceof IHeatSink && component.buffer.need) {
                text = (String)text + "\n" + Localization.translate("iu.need_heat");
            }
        } else if (this.component instanceof FluidTank) {
            FluidTank component = (FluidTank)this.component;
            String text1 = component.getFluid().getHoverName().getString();
            if (component.getFluid().getFluid() == Fluids.EMPTY) {
                text1 = "";
            }
            text = "Fluid " + text1 + ": " + ModUtils.getString(component.getFluidAmount()) + "/" + ModUtils.getString(component.getCapacity());
        }
        return text;
    }
}

