/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.bee;

import com.denfop.api.bee.BeeBase;
import com.denfop.api.bee.IBee;
import com.denfop.tiles.bee.TileEntityApiary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class BeeNetwork {
    public static BeeNetwork instance;
    Map<Integer, IBee> beeMap = new HashMap<Integer, IBee>();
    Map<ResourceKey<Level>, Map<ChunkPos, List<TileEntityApiary>>> mapWorldApiary = new HashMap<ResourceKey<Level>, Map<ChunkPos, List<TileEntityApiary>>>();

    public static void init() {
        if (instance == null) {
            instance = new BeeNetwork();
        }
    }

    public List<TileEntityApiary> getApiaryFromChunk(Level world, ChunkPos chunkPos) {
        Map map = this.mapWorldApiary.computeIfAbsent((ResourceKey<Level>)world.dimension(), k -> new HashMap());
        return map.computeIfAbsent(chunkPos, k -> new ArrayList());
    }

    public void addNewApiaryToWorld(TileEntityApiary apiary) {
        Map<ChunkPos, List<TileEntityApiary>> map = this.mapWorldApiary.get(apiary.getWorld().dimension());
        if (map == null) {
            map = new HashMap<ChunkPos, List<TileEntityApiary>>();
            ChunkPos chunkPos = new ChunkPos(apiary.getPos());
            ArrayList<TileEntityApiary> list = new ArrayList<TileEntityApiary>();
            list.add(apiary);
            map.put(chunkPos, list);
            this.mapWorldApiary.put((ResourceKey<Level>)apiary.getWorld().dimension(), map);
        } else {
            ChunkPos chunkPos = new ChunkPos(apiary.getPos());
            List<TileEntityApiary> list = map.get(chunkPos);
            if (list == null) {
                list = new ArrayList<TileEntityApiary>();
                list.add(apiary);
                map.put(chunkPos, list);
            } else {
                list.add(apiary);
            }
        }
    }

    public void removeApiaryFromWorld(TileEntityApiary apiary) {
        ChunkPos chunkPos;
        List<TileEntityApiary> list;
        Map<ChunkPos, List<TileEntityApiary>> map = this.mapWorldApiary.get(apiary.getWorld().dimension());
        if (map != null && (list = map.get(chunkPos = new ChunkPos(apiary.getPos()))) != null) {
            list.remove(apiary);
        }
    }

    public IBee getBee(int id) {
        return this.beeMap.get(id);
    }

    public Map<Integer, IBee> getBeeMap() {
        return this.beeMap;
    }

    public void addBee(BeeBase beeBase) {
        this.beeMap.putIfAbsent(beeBase.getId(), beeBase);
    }
}

