/*
 * Decompiled with CFR 0.152.
 */
package com.denfop;

import com.denfop.DataBlock;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.TileBlockCreator;
import com.denfop.blocks.blockitem.ItemBlockTileEntity;
import com.denfop.mixin.access.DeferredRegisterAccessor;
import com.denfop.register.Register;
import com.denfop.tiles.base.TileEntityBlock;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DataBlockEntity<T extends Enum<T>> {
    public static TileBlockCreator instance;
    public static List<DeferredHolder<Block, ? extends BlockTileEntity>> objectsBlock1;
    public static List<DeferredHolder<Item, ?>> objects;
    private final Map<T, DeferredHolder<Block, BlockTileEntity<T>>> block = new ConcurrentHashMap<T, DeferredHolder<Block, BlockTileEntity<T>>>();
    private final Map<Integer, T> elementsMeta = new ConcurrentHashMap<Integer, T>();
    private final T[] collections;
    public int index = 0;
    Map<T, DeferredHolder<Item, ItemBlockTileEntity<T>>> registryObjectList = new ConcurrentHashMap<T, DeferredHolder<Item, ItemBlockTileEntity<T>>>();

    public DataBlockEntity(Class<T> typeClass) {
        this(typeClass, "industrialupgrade", Register.BLOCKS, Register.BLOCK_ENTITIES, Register.ITEMS);
    }

    public DataBlockEntity(Class<T> typeClass, String location, DeferredRegister<Block> BLOCKS, DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES, DeferredRegister<Item> ITEMS) {
        Enum[] collections = (Enum[])typeClass.getEnumConstants();
        this.collections = collections;
        for (Enum type : collections) {
            this.elementsMeta.put(((ISubEnum)((Object)type)).getId(), type);
            try {
                ResourceLocation key = ResourceLocation.tryBuild((String)location, (String)(((ISubEnum)((Object)type)).getMainPath() + "/" + ((ISubEnum)((Object)type)).getSerializedName().toLowerCase()));
                Supplier<BlockTileEntity> supplier = () -> TileBlockCreator.instance.create(type, key);
                DeferredHolder ret = DeferredHolder.create((ResourceKey)BLOCKS.getRegistryKey(), (ResourceLocation)key);
                DataBlock.objectsBlock.add(ret);
                objectsBlock1.add((DeferredHolder<Block, ? extends BlockTileEntity>)ret);
                Map entries = ((DeferredRegisterAccessor)BLOCKS).getEntries();
                if (entries.putIfAbsent(ret, supplier) != null) {
                    throw new IllegalArgumentException("Duplicate registration " + ((ISubEnum)((Object)type)).getMainPath());
                }
                Supplier<BlockEntityType> supplierType = () -> this.create(((IMultiTileBlock)((Object)type)).getTeClass(), ret);
                DeferredHolder blockEntityType = DeferredHolder.create((ResourceKey)BLOCK_ENTITIES.getRegistryKey(), (ResourceLocation)key);
                ((IMultiTileBlock)((Object)type)).setType(blockEntityType);
                Map entries1 = ((DeferredRegisterAccessor)BLOCK_ENTITIES).getEntries();
                if (entries1.putIfAbsent(blockEntityType, supplierType) != null) {
                    throw new IllegalArgumentException("Duplicate registration " + ((ISubEnum)((Object)type)).getMainPath());
                }
                this.block.put(type, ret);
                this.registerBlockItem(type, ret, location, ITEMS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public BlockEntityType<? extends TileEntityBlock> create(Class<? extends TileEntityBlock> typeClass, DeferredHolder<Block, BlockTileEntity<T>> ... block) {
        Constructor<?> constructor = typeClass.getConstructors()[0];
        return BlockEntityType.Builder.of((pos, state) -> {
            try {
                return (TileEntityBlock)((Object)((Object)constructor.newInstance(pos, state)));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }, (Block[])((Block[])Arrays.stream(block).map(DeferredHolder::get).toArray(Block[]::new))).build(null);
    }

    private void registerBlockItem(T type, DeferredHolder<Block, BlockTileEntity<T>> block, String location, DeferredRegister<Item> ITEMS) {
        int indexMax = 0;
        if (!((ISubEnum)type).register()) {
            return;
        }
        try {
            ResourceLocation key = ResourceLocation.tryBuild((String)location, (String)(((ISubEnum)type).getMainPath() + "/" + ((ISubEnum)type).getSerializedName().toLowerCase()));
            Supplier<ItemBlockTileEntity> supplier = () -> new ItemBlockTileEntity<Enum>((BlockTileEntity)block.get(), (Enum)type, key);
            if (indexMax < ((ISubEnum)type).getId()) {
                indexMax = ((ISubEnum)type).getId();
            }
            DeferredHolder ret = DeferredHolder.create((ResourceKey)ITEMS.getRegistryKey(), (ResourceLocation)key);
            objects.add(ret);
            Map entries = ((DeferredRegisterAccessor)ITEMS).getEntries();
            if (entries.putIfAbsent(ret, supplier) != null) {
                throw new IllegalArgumentException("Duplicate registration " + String.valueOf(type));
            }
            this.registryObjectList.put(type, ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T getElementFromID(int meta) {
        return (T)((Enum)this.elementsMeta.get(meta));
    }

    public BlockTileEntity<T> getBlock(T element) {
        return (BlockTileEntity)this.block.get(element).get();
    }

    public BlockTileEntity<T> getBlock(int meta) {
        return (BlockTileEntity)this.block.get(this.getElementFromID(meta)).get();
    }

    public BlockTileEntity<T> getBlock() {
        return (BlockTileEntity)this.block.get(this.getElementFromID(0)).get();
    }

    public BlockState getBlockState(int meta) {
        return ((BlockTileEntity)this.block.get(this.getElementFromID(meta)).get()).defaultBlockState();
    }

    public BlockState getStateFromMeta(int meta) {
        return ((BlockTileEntity)this.block.get(this.getElementFromID(meta)).get()).defaultBlockState();
    }

    public BlockState getState(T element) {
        return ((BlockTileEntity)this.block.get(element).get()).defaultBlockState();
    }

    public BlockState getDefaultState() {
        return ((BlockTileEntity)this.block.get(this.collections[0]).get()).defaultBlockState();
    }

    public ItemBlockTileEntity<T> getItem(T element) {
        return (ItemBlockTileEntity)this.registryObjectList.get(element).get();
    }

    public ItemBlockTileEntity<T> getItem(int meta) {
        return (ItemBlockTileEntity)this.registryObjectList.get(this.getElementFromID(meta)).get();
    }

    public ItemBlockTileEntity<T> getItem() {
        return (ItemBlockTileEntity)this.registryObjectList.get(this.getElementFromID(0)).get();
    }

    public ItemStack getItemStack(T element) {
        return new ItemStack((ItemLike)this.registryObjectList.get(element).get());
    }

    public ItemStack getItemStack(T element, int col) {
        return new ItemStack((ItemLike)this.registryObjectList.get(element).get(), col);
    }

    public ItemStack getItemStack(int meta) {
        return new ItemStack((ItemLike)this.registryObjectList.get(this.getElementFromID(meta)).get());
    }

    public ItemStack getItemStack(int meta, int col) {
        return new ItemStack((ItemLike)this.registryObjectList.get(this.getElementFromID(meta)).get(), col);
    }

    public int getMetaFromItemStack(ItemStack itemStack) {
        for (DeferredHolder<Item, ItemBlockTileEntity<T>> item1 : this.registryObjectList.values()) {
            if (item1.get() != itemStack.getItem()) continue;
            return ((ISubEnum)((ItemBlockTileEntity)item1.get()).getElement()).getId();
        }
        return 0;
    }

    public boolean contains(ItemStack itemStack) {
        Item item = itemStack.getItem();
        for (DeferredHolder<Item, ItemBlockTileEntity<T>> item1 : this.registryObjectList.values()) {
            if (item1.get() != item) continue;
            return true;
        }
        return false;
    }

    public ItemBlockTileEntity<T> getItem(ItemStack itemStack) {
        Item item = itemStack.getItem();
        for (DeferredHolder<Item, ItemBlockTileEntity<T>> item1 : this.registryObjectList.values()) {
            if (item1.get() != item) continue;
            return (ItemBlockTileEntity)item1.get();
        }
        return null;
    }

    public BlockTileEntity<T> getBlock(IMultiTileBlock teBlock) {
        return (BlockTileEntity)this.block.get(this.getElementFromID(teBlock.getId())).get();
    }

    public DeferredHolder<Block, BlockTileEntity<T>> getObject(int i) {
        return this.block.get(this.getElementFromID(i));
    }

    static {
        objectsBlock1 = new ArrayList<DeferredHolder<Block, ? extends BlockTileEntity>>();
        objects = new ArrayList();
    }
}

