/*
 * Decompiled with CFR 0.152.
 */
package com.denfop;

import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.mixin.access.DeferredRegisterAccessor;
import com.denfop.register.Register;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DataBlock<T extends Enum<T>, E extends Block, F extends ItemBlockCore> {
    public static List<DeferredHolder<Item, ?>> objects = new ArrayList();
    public static List<DeferredHolder<Block, ?>> objectsBlock = new ArrayList();
    private final Map<T, DeferredHolder<Block, E>> block = new ConcurrentHashMap<T, DeferredHolder<Block, E>>();
    private final Map<Integer, T> elementsMeta = new ConcurrentHashMap<Integer, T>();
    private final T[] collections;
    Map<T, DeferredHolder<Item, F>> registryObjectList = new ConcurrentHashMap<T, DeferredHolder<Item, F>>();

    public DataBlock(Class<T> typeClass, Class<E> blockClass, Class<F> itemClass) {
        this(typeClass, blockClass, itemClass, Register.BLOCKS, Register.ITEMS, "industrialupgrade");
    }

    public DataBlock(Class<T> typeClass, Class<E> blockClass, Class<F> itemClass, DeferredRegister<Block> BLOCKS, DeferredRegister<Item> ITEMS, String modId) {
        Enum[] collections = (Enum[])typeClass.getEnumConstants();
        Enum element = collections[0];
        this.collections = collections;
        boolean needRegistryElements = ((ISubEnum)((Object)element)).register();
        for (Enum type : collections) {
            if (!((ISubEnum)((Object)type)).register()) continue;
            this.elementsMeta.put(((ISubEnum)((Object)type)).getId(), type);
            try {
                Constructor<?> constructor = blockClass.getConstructors()[0];
                Supplier<Block> supplier = () -> {
                    try {
                        return (Block)constructor.newInstance(collections, type, this);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                };
                ResourceLocation key = ResourceLocation.tryBuild((String)modId, (String)(((ISubEnum)((Object)type)).getMainPath() + "/" + ((ISubEnum)((Object)type)).getSerializedName().toLowerCase()));
                DeferredHolder ret = DeferredHolder.create((ResourceKey)BLOCKS.getRegistryKey(), (ResourceLocation)key);
                objectsBlock.add(ret);
                Map entries = ((DeferredRegisterAccessor)BLOCKS).getEntries();
                if (entries.putIfAbsent(ret, supplier) != null) {
                    throw new IllegalArgumentException("Duplicate registration " + ((ISubEnum)((Object)type)).getMainPath());
                }
                this.block.put(type, ret);
                if (!((ISubEnum)((Object)type)).registerOnlyBlock()) {
                    this.registerBlockItem(type, ret, itemClass, ITEMS, modId);
                    continue;
                }
                this.registerBlockItem(type, ret, itemClass, ITEMS, modId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void registerBlockItem(T type, DeferredHolder<Block, E> block, Class<F> itemClass, DeferredRegister<Item> ITEMS, String modId) {
        int indexMax = 0;
        if (!((ISubEnum)type).register()) {
            return;
        }
        try {
            Constructor<?> constructor = itemClass.getConstructors()[0];
            Supplier<ItemBlockCore> supplier = () -> {
                try {
                    return (ItemBlockCore)constructor.newInstance(block.get(), type);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            ResourceLocation key = ResourceLocation.tryBuild((String)modId, (String)(((ISubEnum)type).getMainPath() + "/" + ((ISubEnum)type).getSerializedName().toLowerCase()));
            if (indexMax < ((ISubEnum)type).getId()) {
                indexMax = ((ISubEnum)type).getId();
            }
            DeferredHolder ret = DeferredHolder.create((ResourceKey)ITEMS.getRegistryKey(), (ResourceLocation)key);
            objects.add(ret);
            Map entries = ((DeferredRegisterAccessor)ITEMS).getEntries();
            if (entries.putIfAbsent(ret, supplier) != null) {
                throw new IllegalArgumentException("Duplicate registration " + String.valueOf(type));
            }
            this.registryObjectList.put(type, ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T getElementFromID(int meta) {
        return (T)((Enum)this.elementsMeta.getOrDefault(meta, this.collections[0]));
    }

    public DeferredHolder<Block, E> getBlock(T element) {
        return this.block.get(element);
    }

    public E getBlock(int meta) {
        return (E)((Block)this.block.get(this.getElementFromID(meta)).get());
    }

    public BlockState getBlockState(int meta) {
        return ((Block)this.block.get(this.getElementFromID(meta)).get()).defaultBlockState();
    }

    public BlockState getStateFromMeta(int meta) {
        return ((Block)this.block.get(this.getElementFromID(meta)).get()).defaultBlockState();
    }

    public BlockState getState(T element) {
        return ((Block)this.block.get(element).get()).defaultBlockState();
    }

    public BlockState getDefaultState() {
        return ((Block)this.block.get(this.collections[0]).get()).defaultBlockState();
    }

    public F getItem(T element) {
        return (F)((ItemBlockCore)this.registryObjectList.get(element).get());
    }

    public F getItem() {
        return (F)((ItemBlockCore)this.registryObjectList.get(this.getElementFromID(0)).get());
    }

    public F getItemStack(int meta) {
        return (F)((ItemBlockCore)this.registryObjectList.get(this.getElementFromID(meta)).get());
    }

    public ItemStack getStack(int meta) {
        return new ItemStack((ItemLike)this.registryObjectList.get(this.getElementFromID(meta)).get());
    }

    public F getItem(int meta) {
        return (F)((ItemBlockCore)this.registryObjectList.get(this.getElementFromID(meta)).get());
    }

    public ItemStack getItemStack(T element) {
        return new ItemStack((ItemLike)this.registryObjectList.get(element).get());
    }

    public int getMeta(F item) {
        int i = 0;
        for (DeferredHolder<Item, F> registryObject : this.registryObjectList.values()) {
            if (registryObject.get() == item) {
                return ((ISubEnum)((ItemBlockCore)item).getElement()).getId();
            }
            ++i;
        }
        return 0;
    }
}

