/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.modcompat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class SereneSeasonsConfig {
    private final EnumMap<Season, ModConfigSpec.DoubleValue> seasons = new EnumMap(Season.class);
    private final EnumMap<Season.SubSeason, ModConfigSpec.DoubleValue> subSeasons = new EnumMap(Season.SubSeason.class);
    @Deprecated(forRemoval=true)
    private final ModConfigSpec.ConfigValue<List<? extends String>> seasonFallRate;
    @Deprecated(forRemoval=true)
    private Map<Enum<?>, Float> enabledSeasons = new HashMap();

    public SereneSeasonsConfig(ModConfigSpec.Builder builder) {
        ModConfigSpec.DoubleValue spring = builder.comment(new String[]{"Spring spawn rate modifier.", "This modified is multiplied to the default spawn rate."}).defineInRange("spring", 0.0, 0.0, 5.0);
        ModConfigSpec.DoubleValue summer = builder.comment(new String[]{"Summer spawn rate modifier.", "This modifier is multiplied to the default spawn rate."}).defineInRange("summer", 0.2, 0.0, 5.0);
        ModConfigSpec.DoubleValue autumn = builder.comment(new String[]{"Autumn spawn rate modifier.", "This modifier is multiplied to the default spawn rate."}).defineInRange("autumn", 1.0, 0.0, 5.0);
        ModConfigSpec.DoubleValue winter = builder.comment(new String[]{"Winter spawn rate modifier.", "This modifier is multiplied to the default spawn rate."}).defineInRange("winter", 0.3, 0.0, 5.0);
        builder.comment(new String[]{"Specify sub season modifier.", "These Modifier are multiplied with the season modifier."}).push("subseasons");
        ModConfigSpec.DoubleValue early_spring = builder.comment(new String[]{"Early Spring spawn rate modifier.", "This modified is multiplied to the season spawn rate."}).defineInRange("early_spring", 1.0, 0.0, 100.0);
        ModConfigSpec.DoubleValue mid_spring = builder.comment(new String[]{"Mid Spring spawn rate modifier.", "This modified is multiplied to the season spawn rate."}).defineInRange("mid_spring", 1.0, 0.0, 100.0);
        ModConfigSpec.DoubleValue late_spring = builder.comment(new String[]{"Late Spring spawn rate modifier.", "This modified is multiplied to the season spawn rate."}).defineInRange("late_spring", 1.0, 0.0, 100.0);
        ModConfigSpec.DoubleValue early_summer = builder.comment(new String[]{"Early Summer spawn rate modifier.", "This modified is multiplied to the season spawn rate."}).defineInRange("early_summer", 1.0, 0.0, 100.0);
        ModConfigSpec.DoubleValue mid_summer = builder.comment(new String[]{"Mid Summer spawn rate modifier.", "This modified is multiplied to the season spawn rate."}).defineInRange("mid_summer", 1.0, 0.0, 100.0);
        ModConfigSpec.DoubleValue late_summer = builder.comment(new String[]{"Late Summer spawn rate modifier.", "This modified is multiplied to the season spawn rate."}).defineInRange("late_summer", 1.0, 0.0, 100.0);
        ModConfigSpec.DoubleValue early_autumn = builder.comment(new String[]{"Early Autumn spawn rate modifier.", "This modified is multiplied to the season spawn rate."}).defineInRange("early_autumn", 1.0, 0.0, 100.0);
        ModConfigSpec.DoubleValue mid_autumn = builder.comment(new String[]{"Mid Autumn spawn rate modifier.", "This modified is multiplied to the season spawn rate."}).defineInRange("mid_autumn", 1.0, 0.0, 100.0);
        ModConfigSpec.DoubleValue late_autumn = builder.comment(new String[]{"Late Autumn spawn rate modifier.", "This modified is multiplied to the season spawn rate."}).defineInRange("late_autumn", 1.0, 0.0, 100.0);
        ModConfigSpec.DoubleValue early_winter = builder.comment(new String[]{"Early Winter spawn rate modifier.", "This modified is multiplied to the season spawn rate."}).defineInRange("early_winter", 1.0, 0.0, 100.0);
        ModConfigSpec.DoubleValue mid_winter = builder.comment(new String[]{"Mid Winter spawn rate modifier.", "This modified is multiplied to the season spawn rate."}).defineInRange("mid_winter", 1.0, 0.0, 100.0);
        ModConfigSpec.DoubleValue late_winter = builder.comment(new String[]{"Late Winter spawn rate modifier.", "This modified is multiplied to the season spawn rate."}).defineInRange("late_winter", 1.0, 0.0, 100.0);
        builder.pop();
        this.seasonFallRate = builder.comment(new String[]{"[Deprecated] spawnrate modifier per season/subseason", "Format: '<season>:<modifier>'; eg 'SUMMER:0.23'", "Subseasons override seasons", "Allowed seasons: " + Stream.concat(Arrays.stream(Season.values()), Arrays.stream(Season.SubSeason.values())).map(Enum::name).collect(Collectors.joining(","))}).defineList("seasonFallRate", new ArrayList(), () -> "", string -> string instanceof String && this.exists((String)string));
        this.seasons.put(Season.SPRING, spring);
        this.seasons.put(Season.SUMMER, summer);
        this.seasons.put(Season.AUTUMN, autumn);
        this.seasons.put(Season.WINTER, winter);
        this.subSeasons.put(Season.SubSeason.EARLY_SPRING, early_spring);
        this.subSeasons.put(Season.SubSeason.MID_SPRING, mid_spring);
        this.subSeasons.put(Season.SubSeason.LATE_SPRING, late_spring);
        this.subSeasons.put(Season.SubSeason.EARLY_SUMMER, early_summer);
        this.subSeasons.put(Season.SubSeason.MID_SUMMER, mid_summer);
        this.subSeasons.put(Season.SubSeason.LATE_SUMMER, late_summer);
        this.subSeasons.put(Season.SubSeason.EARLY_AUTUMN, early_autumn);
        this.subSeasons.put(Season.SubSeason.MID_AUTUMN, mid_autumn);
        this.subSeasons.put(Season.SubSeason.LATE_AUTUMN, late_autumn);
        this.subSeasons.put(Season.SubSeason.EARLY_WINTER, early_winter);
        this.subSeasons.put(Season.SubSeason.MID_WINTER, mid_winter);
        this.subSeasons.put(Season.SubSeason.LATE_WINTER, late_winter);
    }

    @Deprecated(forRemoval=true)
    public void updateCache() {
        this.enabledSeasons = ((List)this.seasonFallRate.get()).stream().filter(x -> {
            try {
                this.create((String)x);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }).map(this::create).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    public float getModifier(Level level) {
        ISeasonState state = SeasonHelper.getSeasonState((Level)level);
        if (this.enabledSeasons.containsKey(state.getSubSeason())) {
            return this.enabledSeasons.get(state.getSubSeason()).floatValue();
        }
        if (this.enabledSeasons.containsKey(state.getSeason())) {
            return this.enabledSeasons.get(state.getSeason()).floatValue();
        }
        return (float)(this.seasons.get(state.getSeason()).getAsDouble() * this.subSeasons.get(state.getSubSeason()).getAsDouble());
    }

    @Deprecated(forRemoval=true)
    public boolean exists(String string) {
        try {
            this.create(string);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @Deprecated(forRemoval=true)
    public Pair<Enum<?>, Float> create(String string) {
        Season season;
        String[] split = string.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("Invalid format");
        }
        float modifier = Float.parseFloat(split[1]);
        try {
            season = Season.valueOf((String)split[0]);
        }
        catch (IllegalArgumentException e) {
            try {
                season = Season.SubSeason.valueOf((String)split[0]);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException("Season could not be found");
            }
        }
        return Pair.of((Object)season, (Object)Float.valueOf(modifier));
    }
}

