/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.mixin;

import de.cheaterpaul.fallingleaves.EventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LeavesBlock.class})
public abstract class LeafTickMixin {
    @Shadow
    public abstract BlockState getStateForPlacement(BlockPlaceContext var1);

    @Inject(at={@At(value="HEAD")}, method={"animateTick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"})
    private void dropOnAnimate(BlockState state, Level world, BlockPos pos, RandomSource random, CallbackInfo ci) {
        EventHandler.spawnParticles(state, (ClientLevel)world, pos, random);
    }

    @Inject(method={"randomTick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;removeBlock(Lnet/minecraft/core/BlockPos;Z)Z")})
    private void dropOnDecay(BlockState state, ServerLevel world, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (Minecraft.getInstance().level != null) {
            EventHandler.spawnDecayingParticles(state, Minecraft.getInstance().level, pos, random);
        }
    }
}

