/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.data;

import de.cheaterpaul.fallingleaves.FallingLeavesMod;
import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class LeafSettingGenerator
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> holderLookup;

    public LeafSettingGenerator(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> holderLookup) {
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "fallingleaves/settings");
        this.holderLookup = holderLookup;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        return this.holderLookup.thenCompose(holder -> {
            HashSet set = new HashSet();
            ArrayList list = new ArrayList();
            BiConsumer<ResourceLocation, LeafSettingsEntry> consumer = (id, entry) -> {
                if (!set.add(id)) {
                    throw new IllegalStateException("Duplicate leaf setting entry " + String.valueOf(id));
                }
                Path path = this.pathProvider.json(id);
                list.add(DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)holder, LeafSettingsEntry.CODEC, (Object)entry, (Path)path));
            };
            this.registerLeafSettingEntries(consumer);
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    @NotNull
    public String getName() {
        return "leave settings generator";
    }

    protected void registerLeafSettingEntries(BiConsumer<ResourceLocation, LeafSettingsEntry> consumer) {
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"spruce_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"jungle_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.DEFAULT));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"cherry_leaves"), new LeafSettingsEntry(0.0));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"blue_spruce_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"cypress_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"fir_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"orange_spruce_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"pine_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"red_spruce_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"yellow_spruce_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"pink_cherry_leaves"), new LeafSettingsEntry(1.4));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"skyris_leaves"), new LeafSettingsEntry(1.4));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"white_cherry_leaves"), new LeafSettingsEntry(1.4));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"terrestria", (String)"cypress_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"terrestria", (String)"hemlock_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"terrestria", (String)"redwood_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"terrestria", (String)"japanese_maple_shrub_leaves"), new LeafSettingsEntry(0.0, FallingLeavesMod.MAPLE));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"terrestria", (String)"jungle_palm_leaves"), new LeafSettingsEntry(0.2, FallingLeavesMod.PALMS));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"terrestria", (String)"yucca_palm_leaves"), new LeafSettingsEntry(0.2, FallingLeavesMod.PALMS));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"terrestria", (String)"sakura_leaves"), new LeafSettingsEntry(1.4));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"traverse", (String)"fir_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"traverse", (String)"brown_autumnal_leaves"), new LeafSettingsEntry(1.8));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"traverse", (String)"orange_autumnal_leaves"), new LeafSettingsEntry(1.8));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"traverse", (String)"red_autumnal_leaves"), new LeafSettingsEntry(1.8));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"traverse", (String)"yellow_autumnal_leaves"), new LeafSettingsEntry(1.8));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"woods_and_mires", (String)"pine_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"fir_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"redwood_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"cypress_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.CONIFER));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"snowblossom_leaves"), new LeafSettingsEntry(0.0));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"red_maple_leaves"), new LeafSettingsEntry(0.0, FallingLeavesMod.MAPLE));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"orange_maple_leaves"), new LeafSettingsEntry(0.0, FallingLeavesMod.MAPLE));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"yellow_maple_leaves"), new LeafSettingsEntry(0.0, FallingLeavesMod.MAPLE));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"mahogany_leaves"), new LeafSettingsEntry(1.0, FallingLeavesMod.MAHOGANY));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"pine_leaves"), new LeafSettingsEntry(1.0));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"rainbow_birch_leaves"), new LeafSettingsEntry(1.0));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"jacaranda_leaves"), new LeafSettingsEntry(1.0));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"palm_leaves"), new LeafSettingsEntry(0.2, FallingLeavesMod.PALMS));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"willow_leaves"), new LeafSettingsEntry(1.0));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"dead_leaves"), new LeafSettingsEntry(1.0));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"magic_leaves"), new LeafSettingsEntry(1.0));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"umbran_leaves"), new LeafSettingsEntry(1.0));
        consumer.accept(ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"hellbark_leaves"), new LeafSettingsEntry(1.0));
    }
}

