/*
 * Decompiled with CFR 0.152.
 */
package moderndeco.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TelephoneBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public TelephoneBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.CANDLE).strength(0.5f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)TelephoneBlock.box((double)6.45, (double)-0.15, (double)6.35, (double)10.45, (double)6.85, (double)7.25), (VoxelShape[])new VoxelShape[]{TelephoneBlock.box((double)6.45, (double)-0.15, (double)7.25, (double)10.45, (double)6.85, (double)7.35), TelephoneBlock.box((double)8.35, (double)4.75, (double)6.15, (double)10.35, (double)6.75, (double)6.35), TelephoneBlock.box((double)10.45, (double)4.2, (double)6.55, (double)10.55, (double)5.6, (double)7.05)});
            case Direction.NORTH -> Shapes.or((VoxelShape)TelephoneBlock.box((double)5.55, (double)-0.15, (double)8.75, (double)9.55, (double)6.85, (double)9.65), (VoxelShape[])new VoxelShape[]{TelephoneBlock.box((double)5.55, (double)-0.15, (double)8.65, (double)9.55, (double)6.85, (double)8.75), TelephoneBlock.box((double)5.65, (double)4.75, (double)9.65, (double)7.65, (double)6.75, (double)9.85), TelephoneBlock.box((double)5.45, (double)4.2, (double)8.95, (double)5.55, (double)5.6, (double)9.45)});
            case Direction.EAST -> Shapes.or((VoxelShape)TelephoneBlock.box((double)6.35, (double)-0.15, (double)5.55, (double)7.25, (double)6.85, (double)9.55), (VoxelShape[])new VoxelShape[]{TelephoneBlock.box((double)7.25, (double)-0.15, (double)5.55, (double)7.35, (double)6.85, (double)9.55), TelephoneBlock.box((double)6.15, (double)4.75, (double)5.65, (double)6.35, (double)6.75, (double)7.65), TelephoneBlock.box((double)6.55, (double)4.2, (double)5.45, (double)7.05, (double)5.6, (double)5.55)});
            case Direction.WEST -> Shapes.or((VoxelShape)TelephoneBlock.box((double)8.75, (double)-0.15, (double)6.45, (double)9.65, (double)6.85, (double)10.45), (VoxelShape[])new VoxelShape[]{TelephoneBlock.box((double)8.65, (double)-0.15, (double)6.45, (double)8.75, (double)6.85, (double)10.45), TelephoneBlock.box((double)9.65, (double)4.75, (double)8.35, (double)9.85, (double)6.75, (double)10.35), TelephoneBlock.box((double)8.95, (double)4.2, (double)10.45, (double)9.45, (double)5.6, (double)10.55)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }
}

