/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.client;

import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.Button;
import de.ambertation.wunderlib.ui.layout.components.DropDown;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.Tabs;
import de.ambertation.wunderlib.ui.layout.components.Text;
import de.ambertation.wunderlib.ui.layout.components.VerticalScroll;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.layout.values.Size;
import de.ambertation.wunderlib.ui.layout.values.Value;
import de.ambertation.wunderlib.ui.vanilla.LayoutScreen;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_525;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7134;
import net.minecraft.class_7145;
import net.minecraft.class_7193;
import net.minecraft.class_7723;
import net.minecraft.class_7924;
import net.minecraft.class_8100;
import net.minecraft.class_9248;
import org.betterx.wover.config.api.Configs;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.api.client.biomesource.client.BiomeSourceConfigPanel;
import org.betterx.wover.generator.api.client.biomesource.client.BiomeSourceWithConfigScreen;
import org.betterx.wover.generator.impl.chunkgenerator.ChunkGeneratorManagerImpl;
import org.betterx.wover.generator.impl.chunkgenerator.ConfiguredChunkGenerator;
import org.betterx.wover.generator.impl.chunkgenerator.WoverChunkGeneratorImpl;
import org.betterx.wover.preset.api.WorldPresetInfo;
import org.betterx.wover.preset.api.WorldPresetInfoRegistry;
import org.betterx.wover.preset.api.WorldPresetManager;
import org.betterx.wover.preset.api.WorldPresetTags;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.ui.impl.client.WelcomeScreen;
import org.betterx.wover.ui.impl.client.WoverLayoutScreen;
import org.betterx.wover.util.PriorityLinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class WorldSetupScreen
extends LayoutScreen
implements BiomeSourceConfigPanel.DimensionUpdater {
    private final List<class_5321<class_2874>> sortedDimensions = List.of(class_7134.field_37667, class_7134.field_37668, class_7134.field_37666);
    private final Map<class_5321<class_2874>, DimensionContent> dimensions = Map.of(class_7134.field_37667, new DimensionContent((class_5321<class_5363>)class_5363.field_25413, (class_5321<class_2874>)class_7134.field_37667), class_7134.field_37668, new DimensionContent((class_5321<class_5363>)class_5363.field_25414, (class_5321<class_2874>)class_7134.field_37668), class_7134.field_37666, new DimensionContent((class_5321<class_5363>)class_5363.field_25412, (class_5321<class_2874>)class_7134.field_37666));
    private final class_7193 context;
    private final VerticalStack contentFallback;
    private final class_525 createWorldScreen;
    private Tabs mainTabs;
    Button netherButton;
    Button endButton;
    VerticalScroll<?> scroller;
    HorizontalStack title;

    public WorldSetupScreen(@Nullable class_525 parent, class_7193 context) {
        super((class_437)parent, (class_2561)class_2561.method_43471((String)"title.screen.wover.worldgen.main"), 2, 6, 10);
        this.context = context;
        this.createWorldScreen = parent;
        this.contentFallback = (VerticalStack)new VerticalStack(WorldSetupScreen.fit(), WorldSetupScreen.fit()).centerHorizontal();
        this.contentFallback.addSpacer(16);
        ((Text)this.contentFallback.addText(WorldSetupScreen.fit(), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.wover.worldgen.no_generator_config")).centerVertical()).setColor(ColorHelper.DARK_GRAY);
    }

    private void generatorChanged(DimensionContent content, DimensionValue selected) {
        if (content.stack != null) {
            int selectedPage = this.mainTabs == null ? 0 : this.mainTabs.getSelectedPage();
            class_1966 selectedBiomeSource = selected.dimension.comp_1013().method_12098();
            if (selectedBiomeSource instanceof BiomeSourceWithConfigScreen) {
                BiomeSourceWithConfigScreen bs = (BiomeSourceWithConfigScreen)selectedBiomeSource;
                content.configPanel = bs.biomeSourceConfigPanel((class_437)this);
                content.stack.replaceOrAdd(content.stackIndex, content.configPanel.getPanel());
            } else {
                content.configPanel = null;
                content.stack.replaceOrAdd(content.stackIndex, (LayoutComponent)this.contentFallback);
            }
            if (this.mainTabs != null) {
                content.stack.recalculateLayout();
                this.mainTabs.selectPage(selectedPage);
            }
        }
    }

    @Nullable
    private static class_5321<class_7145> getConfiguredGeneratorKey(@Nullable class_6880<class_7145> configuredPreset, @NotNull class_5321<class_5363> forDimension) {
        class_5321 overrideKey;
        class_2794 class_27942;
        class_5363 dimension;
        class_5321<class_7145> configuredKey = null;
        if (configuredPreset != null && (dimension = WorldPresetManager.getDimension(configuredPreset, forDimension)) != null && (class_27942 = dimension.comp_1013()) instanceof ConfiguredChunkGenerator) {
            ConfiguredChunkGenerator cfg = (ConfiguredChunkGenerator)class_27942;
            configuredKey = cfg.wover_getConfiguredWorldPreset();
        }
        if (configuredKey == null && configuredPreset != null) {
            configuredKey = configuredPreset.method_40230().orElse(null);
        }
        return (overrideKey = WorldPresetInfoRegistry.getFor(configuredKey).getPresetOverrideRecursive(forDimension)) != null ? overrideKey : configuredKey;
    }

    private String languageKey(class_6880<class_7145> key) {
        return this.languageKey(((class_5321)key.method_40230().orElseThrow()).method_29177());
    }

    private String languageKey(class_2960 key) {
        return "generator." + key.method_12836() + "." + key.method_12832();
    }

    protected void populateGenerators(@Nullable class_6880<class_7145> configuredPreset, @NotNull class_5321<class_5363> forDimension, @NotNull DropDown<DimensionValue> dimensions) {
        class_5321<class_7145> finalConfiguredKey = WorldSetupScreen.getConfiguredGeneratorKey(configuredPreset, forDimension);
        DimensionValue selectedStem = null;
        class_2378 worldPresets = WorldState.allStageRegistryAccess().method_30530(class_7924.field_41250);
        Optional normal = worldPresets.method_40266(WorldPresetTags.NORMAL);
        if (normal.isPresent()) {
            HashSet generators = new HashSet();
            class_2477 language = class_2477.method_10517();
            PriorityLinkedList options = new PriorityLinkedList();
            ((class_6885.class_6888)normal.get()).method_40239().filter(preset -> preset.method_40230().isPresent()).filter(preset -> WorldPresetInfoRegistry.getFor((class_6880)preset).getPresetOverride(forDimension) == null).sorted((a, b) -> language.method_48307(this.languageKey((class_6880<class_7145>)a)).compareTo(language.method_48307(this.languageKey((class_6880<class_7145>)b)))).forEach(preset -> {
                WorldPresetInfo info = WorldPresetInfoRegistry.getFor((class_6880)preset);
                class_2960 presetKey = ((class_5321)preset.method_40230().orElseThrow()).method_29177();
                Optional targetDimension = ((class_7145)preset.comp_349()).method_45546().method_45514(forDimension);
                if (targetDimension.isPresent()) {
                    class_2794 generator = ((class_5363)targetDimension.get()).comp_1013();
                    if (!generators.contains(generator)) {
                        DimensionValue dimensionValue = new DimensionValue((class_6880<class_7145>)preset, (class_5321<class_7145>)((class_5321)preset.method_40230().orElseThrow()), (class_5363)targetDimension.get());
                        generators.add(generator);
                        options.add((Object)dimensionValue, -1 * info.sortOrder());
                    } else {
                        LibWoverWorldGenerator.C.log.debug("Skipping duplicate generator for preset {}", new Object[]{presetKey});
                    }
                }
            });
            for (DimensionValue dimensionValue : options) {
                dimensions.addOption((class_2561)class_2561.method_43471((String)this.languageKey(dimensionValue.preset)), (Object)dimensionValue);
                if (finalConfiguredKey == null || !dimensionValue.key.method_29177().equals((Object)finalConfiguredKey.method_29177())) continue;
                selectedStem = dimensionValue;
            }
        }
        boolean didSelect = false;
        if (selectedStem != null) {
            didSelect = dimensions.select(selectedStem);
        }
        if (!didSelect) {
            dimensions.selectFirst();
        }
    }

    private LayoutComponent<?, ?> contentPage(class_6880<class_7145> configuredPreset, class_2561 title, DimensionContent contentData) {
        VerticalStack content = (VerticalStack)new VerticalStack(WorldSetupScreen.fill(), WorldSetupScreen.fit()).centerHorizontal();
        content.setDebugName("Stack " + String.valueOf(contentData.dimensionKey.method_29177()));
        content.addSpacer(16);
        content.addText(WorldSetupScreen.fit(), WorldSetupScreen.fit(), title).centerHorizontal();
        content.addHorizontalSeparator(8).alignTop();
        HorizontalStack generatorRow = content.addRow(Value.fill(), Value.fit());
        generatorRow.addText(Value.fit(), Value.fit(), (class_2561)class_2561.method_43471((String)"title.screen.wover.worldgen.generator_template"));
        generatorRow.addSpacer(8);
        DropDown generators = generatorRow.addDropDown(Value.fixed((int)200), Value.fit());
        generators.onChange((__unused, selected) -> this.generatorChanged(contentData, (DimensionValue)selected));
        contentData.stackIndex = content.size();
        contentData.generators = generators;
        contentData.stack = content;
        this.populateGenerators(configuredPreset, contentData.dimensionKey, (DropDown<DimensionValue>)generators);
        return content;
    }

    private void updateSettings() {
        this.dimensions.values().forEach(content -> {
            if (content.generators == null) {
                return;
            }
            DimensionValue value = (DimensionValue)content.generators.selectedOption();
            if (value == null) {
                return;
            }
            class_2794 generator = value.dimension.comp_1013();
            if (content.configPanel != null) {
                generator = content.configPanel.updateSettings(generator);
            }
            if (generator instanceof ConfiguredChunkGenerator) {
                ConfiguredChunkGenerator cfg = (ConfiguredChunkGenerator)generator;
                cfg.wover_setConfiguredWorldPreset(value.key);
            }
            this.updateConfiguration(content.dimensionKey, content.dimensionTypeKey, generator);
        });
        class_7723 dims = this.createWorldScreen.method_48657().method_48728().comp_1028();
        WorldSetupScreen.printDimensions(dims);
        class_8100 acc = this.createWorldScreen.method_48657();
        acc.method_48705(new class_8100.class_8101(class_6880.method_40223((Object)WorldPresetManager.withDimensions((class_7723)dims))));
    }

    @Override
    public void updateConfiguration(class_5321<class_5363> dimensionKey, class_5321<class_2874> dimensionTypeKey, class_2794 chunkGenerator) {
        this.createWorldScreen.method_48657().method_48700((registryAccess, worldDimensions) -> {
            Map map = worldDimensions.comp_1014();
            return new class_7723(WoverChunkGeneratorImpl.replaceGenerator(dimensionKey, dimensionTypeKey, (class_5455)registryAccess, map.entrySet(), chunkGenerator, key -> (class_5363)map.get(key), (registry, key, stem) -> registry.method_10272(key, (Object)stem, class_9248.field_49136)));
        });
    }

    protected LayoutComponent<?, ?> createScreen(LayoutComponent<?, ?> content) {
        VerticalStack rows = (VerticalStack)new VerticalStack(WorldSetupScreen.fill(), WorldSetupScreen.fill()).setDebugName("title stack");
        if (this.topPadding > 0) {
            rows.addSpacer(this.topPadding);
        }
        rows.add(content);
        if (this.bottomPadding > 0) {
            rows.addSpacer(this.bottomPadding);
        }
        if (this.sidePadding <= 0) {
            return rows;
        }
        HorizontalStack cols = (HorizontalStack)new HorizontalStack(WorldSetupScreen.fill(), WorldSetupScreen.fill()).setDebugName("padded side");
        cols.addSpacer(this.sidePadding);
        cols.add((LayoutComponent)rows);
        cols.addSpacer(this.sidePadding);
        return cols;
    }

    protected LayoutComponent<?, ?> initContent() {
        Tabs main;
        class_8100 acc = this.createWorldScreen.method_48657();
        class_6880 configuredPreset = acc.method_48730().comp_1238();
        if (configuredPreset != null) {
            this.dimensions.values().forEach(content -> {
                class_2794 patt0$temp;
                class_5363 stem = WorldPresetManager.getDimension((class_6880)configuredPreset, content.dimensionKey);
                if (stem != null && (patt0$temp = stem.comp_1013()) instanceof ConfiguredChunkGenerator) {
                    ConfiguredChunkGenerator cfg = (ConfiguredChunkGenerator)patt0$temp;
                    if (configuredPreset.method_40230().isPresent() && cfg.wover_getConfiguredWorldPreset() == null) {
                        cfg.wover_setConfiguredWorldPreset((class_5321<class_7145>)((class_5321)configuredPreset.method_40230().orElseThrow()));
                    }
                }
            });
        }
        this.mainTabs = main = new Tabs(WorldSetupScreen.fill(), WorldSetupScreen.fill()).setPadding(8, 0, 0, 0);
        this.sortedDimensions.stream().map(type -> this.dimensions.get(type)).filter(content -> content != null).forEach(content -> {
            LayoutComponent<?, ?> page = this.contentPage((class_6880<class_7145>)configuredPreset, (class_2561)class_2561.method_43471((String)("title.screen.wover.worldgen." + content.dimensionKey.method_29177().method_12832() + "_generator")), (DimensionContent)content);
            if (!main.isEmpty()) {
                main.addSpacer(8);
            }
            this.scroller = (VerticalScroll)VerticalScroll.create(page).setDebugName(content.dimensionKey.method_29177().method_12832() + " scroll");
            main.addPage((class_2561)class_2561.method_43471((String)("title.wover." + content.dimensionKey.method_29177().method_12832())), (LayoutComponent)this.scroller);
        });
        this.netherButton = main.getButton(this.sortedDimensions.indexOf(class_7134.field_37667));
        this.endButton = main.getButton(this.sortedDimensions.indexOf(class_7134.field_37668));
        this.title = (HorizontalStack)((HorizontalStack)new HorizontalStack(WorldSetupScreen.fit(), WorldSetupScreen.fit()).setDebugName("title bar")).alignBottom();
        this.title.addImage(WorldSetupScreen.fixed((int)38), WorldSetupScreen.fixed((int)38), WoverLayoutScreen.WOVER_LOGO_LOCATION, Size.of((int)256)).setDebugName("icon");
        this.title.addSpacer(4);
        VerticalStack logos = this.title.addColumn(WorldSetupScreen.fit(), WorldSetupScreen.fit());
        logos.addSpacer(8);
        logos.addImage(WorldSetupScreen.fixed((int)59), WorldSetupScreen.fixed((int)13), WelcomeScreen.BETTERX_LOCATION, Size.of((int)178, (int)40));
        logos.add(super.createTitle());
        logos.addSpacer(2);
        main.addFiller();
        main.addComponent((LayoutComponent)this.title);
        VerticalStack rows = new VerticalStack(WorldSetupScreen.fill(), WorldSetupScreen.fill());
        rows.add((LayoutComponent)main);
        rows.addSpacer(4);
        rows.addButton(WorldSetupScreen.fit(), WorldSetupScreen.fit(), class_5244.field_24334).onPress(bt -> {
            this.updateSettings();
            this.method_25419();
        }).alignRight();
        return rows;
    }

    private static void printDimensions(class_7723 dims) {
        if (!((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue()) {
            return;
        }
        ChunkGeneratorManagerImpl.printDimensionInfo("Configured Dimensions", dims);
    }

    public void renderBackgroundLayer(class_332 guiGraphics, int i, int j, float f) {
        guiGraphics.method_25294(0, 0, this.field_22789, this.field_22790, -1120652220);
    }

    public static class DimensionContent {
        public final class_5321<class_5363> dimensionKey;
        public final class_5321<class_2874> dimensionTypeKey;
        private BiomeSourceConfigPanel<?, ?> configPanel;
        private DropDown<DimensionValue> generators;
        private VerticalStack stack;
        private int stackIndex = -1;

        private DimensionContent(class_5321<class_5363> dimensionKey, class_5321<class_2874> dimensionTypeKey) {
            this.dimensionKey = dimensionKey;
            this.dimensionTypeKey = dimensionTypeKey;
        }
    }

    protected record DimensionValue(class_6880<class_7145> preset, class_5321<class_7145> key, class_5363 dimension) {
    }
}

