/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.client;

import de.ambertation.wunderlib.ui.layout.components.Checkbox;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.Range;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.minecraft.class_1966;
import net.minecraft.class_2561;
import net.minecraft.class_2794;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceConfig;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceWithConfig;
import org.betterx.wover.generator.api.biomesource.nether.WoverNetherConfig;
import org.betterx.wover.generator.api.client.biomesource.client.BiomeSourceConfigPanel;
import org.betterx.wover.generator.impl.biomesource.nether.WoverNetherBiomeSource;
import org.jetbrains.annotations.NotNull;

public class NetherConfigPage
implements BiomeSourceConfigPanel<WoverNetherBiomeSource, WoverNetherConfig> {
    private final Checkbox netherLegacy;
    private final Checkbox netherVertical;
    private final Range<Integer> netherBiomeSize;
    private final Range<Integer> netherVerticalBiomeSize;
    private final VerticalStack pageComponent;

    public NetherConfigPage(@NotNull WoverNetherConfig netherConfig) {
        VerticalStack content = (VerticalStack)new VerticalStack(Value.fill(), Value.fit()).centerHorizontal();
        content.addSpacer(8);
        this.netherLegacy = content.addCheckbox(Value.fit(), Value.fit(), (class_2561)class_2561.method_43471((String)"title.screen.wover.worldgen.legacy_square"), netherConfig.mapVersion == WoverNetherConfig.NetherBiomeMapType.SQUARE);
        this.netherVertical = content.addCheckbox(Value.fit(), Value.fit(), (class_2561)class_2561.method_43471((String)"title.screen.wover.worldgen.nether_vertical"), netherConfig.useVerticalBiomes);
        content.addSpacer(12);
        content.addText(Value.fit(), Value.fit(), (class_2561)class_2561.method_43471((String)"title.screen.wover.worldgen.avg_biome_size")).centerHorizontal();
        content.addHorizontalSeparator(8).alignTop();
        this.netherBiomeSize = content.addRange(Value.fixed((int)200), Value.fit(), (class_2561)class_2561.method_43471((String)"title.screen.wover.worldgen.nether_biome_size"), 1, 512, netherConfig.biomeSize / 16);
        this.netherVerticalBiomeSize = content.addRange(Value.fixed((int)200), Value.fit(), (class_2561)class_2561.method_43471((String)"title.screen.wover.worldgen.nether_vertical_biome_size"), 1, 32, netherConfig.biomeSizeVertical / 16);
        this.netherVertical.onChange((checkbox, selected) -> this.netherVerticalBiomeSize.setEnabled(selected));
        content.addSpacer(8);
        content.setDebugName("Nether page");
        this.pageComponent = content;
    }

    @Override
    public LayoutComponent<?, ?> getPanel() {
        return this.pageComponent;
    }

    @Override
    public class_2794 updateSettings(class_2794 netherGenerator) {
        BiomeSourceWithConfig bsc;
        class_1966 class_19662 = netherGenerator.method_12098();
        if (class_19662 instanceof BiomeSourceWithConfig && (bsc = (BiomeSourceWithConfig)class_19662).getBiomeSourceConfig() instanceof WoverNetherConfig) {
            BiomeSourceWithConfig biomeSource = bsc;
            WoverNetherConfig netherConfig = new WoverNetherConfig(this.netherLegacy.isChecked() ? WoverNetherConfig.NetherBiomeMapType.SQUARE : WoverNetherConfig.NetherBiomeMapType.HEX, (Integer)this.netherBiomeSize.getValue() * 16, (Integer)this.netherVerticalBiomeSize.getValue() * 16, this.netherVertical.isChecked());
            biomeSource.setBiomeSourceConfig((BiomeSourceConfig)netherConfig);
        }
        return netherGenerator;
    }
}

