/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.chunkgenerator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3754;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6725;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_6954;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.class_9248;
import org.betterx.wover.biome.impl.modification.ChunkGeneratorHelper;
import org.betterx.wover.biome.mixin.ChunkGeneratorAccessor;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceWithNoiseRelatedSettings;
import org.betterx.wover.common.generator.api.biomesource.MergeableBiomeSource;
import org.betterx.wover.common.generator.api.biomesource.NoiseGeneratorSettingsProvider;
import org.betterx.wover.common.generator.api.biomesource.ReloadableBiomeSource;
import org.betterx.wover.common.generator.api.chunkgenerator.EnforceableChunkGenerator;
import org.betterx.wover.common.generator.api.chunkgenerator.RebuildableFeaturesPerStep;
import org.betterx.wover.common.generator.api.chunkgenerator.RestorableBiomeSource;
import org.betterx.wover.common.surface.api.InjectableSurfaceRules;
import org.betterx.wover.core.api.IntegrationCore;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.impl.chunkgenerator.ChunkGeneratorManagerImpl;
import org.betterx.wover.generator.impl.chunkgenerator.WoverChunkGeneratorImpl;
import org.betterx.wover.surface.impl.SurfaceRuleUtil;
import org.jetbrains.annotations.NotNull;

public class WoverChunkGenerator
extends class_3754
implements RestorableBiomeSource<WoverChunkGenerator>,
InjectableSurfaceRules<WoverChunkGenerator>,
EnforceableChunkGenerator<WoverChunkGenerator>,
RebuildableFeaturesPerStep<WoverChunkGenerator> {
    public static final class_2960 ID = LibWoverWorldGenerator.C.id("betterx");
    protected static final class_5309 NETHER_NOISE_SETTINGS_AMPLIFIED = class_5309.method_32994((int)0, (int)256, (int)1, (int)4);
    public static final class_5321<class_5284> AMPLIFIED_NETHER = class_5321.method_29179((class_5321)class_7924.field_41243, (class_2960)LibWoverWorldGenerator.C.id("amplified_nether"));
    public static final MapCodec<WoverChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(builderInstance -> {
        RecordCodecBuilder biomeSourceCodec = class_1966.field_24713.fieldOf("biome_source").forGetter(generator -> generator.field_12761);
        RecordCodecBuilder settingsCodec = class_5284.field_24781.fieldOf("settings").forGetter(generator -> generator.method_41541());
        return builderInstance.group((App)biomeSourceCodec, (App)settingsCodec).apply((Applicative)builderInstance, builderInstance.stable(WoverChunkGenerator::new));
    });
    public final class_1966 initialBiomeSource;

    public WoverChunkGenerator(class_1966 biomeSource, class_6880<class_5284> holder) {
        super(biomeSource, holder);
        this.initialBiomeSource = biomeSource;
        if (biomeSource instanceof BiomeSourceWithNoiseRelatedSettings) {
            BiomeSourceWithNoiseRelatedSettings bcl = (BiomeSourceWithNoiseRelatedSettings)biomeSource;
            if (holder.method_40227()) {
                bcl.onLoadGeneratorSettings((class_5284)holder.comp_349());
            }
        }
        if (IntegrationCore.RUNS_TERRABLENDER) {
            LibWoverWorldGenerator.C.log.info("Make sure features are loaded from terrablender:" + biomeSource.getClass().getName());
            ChunkGeneratorHelper.rebuildFeaturesPerStep((class_2794)this, (class_1966)biomeSource);
        }
        LibWoverWorldGenerator.C.log.info("Created WoverChunkGenerator with " + biomeSource.getClass().getName());
    }

    @NotNull
    protected MapCodec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public void wover_rebuildFeaturesPerStep() {
        ChunkGeneratorHelper.rebuildFeaturesPerStep((class_2794)this, (class_1966)this.method_12098());
    }

    public void restoreInitialBiomeSource(class_5321<class_5363> dimensionKey) {
        WoverChunkGenerator woverChunkGenerator;
        if (this.initialBiomeSource != this.method_12098() && (woverChunkGenerator = this) instanceof ChunkGeneratorAccessor) {
            ChunkGeneratorAccessor acc = (ChunkGeneratorAccessor)woverChunkGenerator;
            class_1966 class_19662 = this.initialBiomeSource;
            if (class_19662 instanceof MergeableBiomeSource) {
                MergeableBiomeSource bs = (MergeableBiomeSource)class_19662;
                acc.wover_setBiomeSource(bs.mergeWithBiomeSource(this.method_12098()));
            } else {
                class_19662 = this.initialBiomeSource;
                if (class_19662 instanceof ReloadableBiomeSource) {
                    ReloadableBiomeSource bs = (ReloadableBiomeSource)class_19662;
                    bs.reloadBiomes();
                }
            }
            ChunkGeneratorHelper.rebuildFeaturesPerStep((class_2794)this, (class_1966)this.method_12098());
        }
    }

    public String toString() {
        return ChunkGeneratorManagerImpl.printGeneratorInfo("WoVer - Chunk Generator", (class_2794)this);
    }

    public void appendFeaturesPerStep() {
    }

    public class_2378<class_5363> enforceGeneratorInWorldGenSettings(class_5455 access, class_5321<class_5363> dimensionKey, class_5321<class_2874> dimensionTypeKey, class_2794 loadedChunkGenerator, class_2378<class_5363> dimensionRegistry) {
        LibWoverWorldGenerator.C.log.info("Enforcing Correct Generator for " + dimensionKey.method_29177().toString() + ".");
        WoverChunkGenerator referenceGenerator = this;
        if (loadedChunkGenerator instanceof ChunkGeneratorAccessor) {
            ChunkGeneratorAccessor generator = (ChunkGeneratorAccessor)loadedChunkGenerator;
            if (loadedChunkGenerator instanceof NoiseGeneratorSettingsProvider) {
                NoiseGeneratorSettingsProvider noiseProvider = (NoiseGeneratorSettingsProvider)loadedChunkGenerator;
                if (referenceGenerator instanceof NoiseGeneratorSettingsProvider) {
                    class_1966 bs;
                    NoiseGeneratorSettingsProvider referenceProvider = (NoiseGeneratorSettingsProvider)referenceGenerator;
                    class_1966 class_19662 = referenceGenerator.method_12098();
                    if (class_19662 instanceof MergeableBiomeSource) {
                        MergeableBiomeSource mbs = (MergeableBiomeSource)class_19662;
                        bs = mbs.mergeWithBiomeSource(loadedChunkGenerator.method_12098());
                    } else {
                        bs = referenceGenerator.method_12098();
                    }
                    referenceProvider.wover_getNoiseGeneratorSettingHolders();
                    referenceGenerator = new WoverChunkGenerator(bs, (class_6880<class_5284>)noiseProvider.wover_getNoiseGeneratorSettingHolders());
                }
            }
        }
        return WoverChunkGeneratorImpl.replaceGenerator(dimensionKey, dimensionTypeKey, access, dimensionRegistry.method_29722(), (class_2794)referenceGenerator, arg_0 -> dimensionRegistry.method_29107(arg_0), (registry, key, stem) -> registry.method_10272(key, (Object)stem, dimensionRegistry.method_57058(key).orElse(class_9248.field_49136)));
    }

    public static class_5284 amplifiedNether(class_7891<class_5284> bootstapContext) {
        class_7871 densityGetter = bootstapContext.method_46799(class_7924.field_41240);
        return new class_5284(NETHER_NOISE_SETTINGS_AMPLIFIED, class_2246.field_10515.method_9564(), class_2246.field_10164.method_9564(), class_6954.method_41211((class_7871)densityGetter, (class_7871)bootstapContext.method_46799(class_7924.field_41244), (class_6910)class_6954.method_42363((class_7871)densityGetter, (int)0, (int)256)), class_6725.method_39138(), List.of(), 32, false, false, false, true);
    }

    public void wover_injectSurfaceRules(class_2378<class_5363> dimensionRegistry, class_5321<class_5363> dimensionKey) {
        SurfaceRuleUtil.injectNoiseBasedSurfaceRules(dimensionKey, (class_6880)this.method_41541(), (class_1966)this.method_12098());
    }
}

