/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.chunkgenerator;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import de.ambertation.wunderlib.utils.Version;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2794;
import net.minecraft.class_32;
import net.minecraft.class_5218;
import net.minecraft.class_5317;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7145;
import net.minecraft.class_7225;
import net.minecraft.class_7723;
import org.betterx.wover.core.api.IntegrationCore;
import org.betterx.wover.core.api.Logger;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.entrypoint.LibWoverEvents;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.api.preset.WorldPresets;
import org.betterx.wover.generator.impl.chunkgenerator.ConfiguredChunkGenerator;
import org.betterx.wover.generator.impl.chunkgenerator.DimensionsWrapper;
import org.betterx.wover.generator.impl.preset.PresetRegistryImpl;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.preset.api.WorldPresetInfo;
import org.betterx.wover.preset.api.WorldPresetInfoRegistry;
import org.betterx.wover.preset.api.WorldPresetManager;
import org.betterx.wover.state.api.WorldConfig;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;

public class WorldGeneratorConfigImpl {
    public static final String TAG_PRESET = "preset";
    private static final String LEGACY_TAG_GENERATOR = "generator";
    public static final String TAG_DIMENSIONS = "dimensions";
    public static final String TAG_DIMENSION_PRESETS = "world_presets";
    private static final String LEGACY_TAG_VERSION = "version";
    private static final String LEGACY_TAG_BN_GEN_VERSION = "generator_version";
    private static DimensionsWrapper DEFAULT_DIMENSIONS_WRAPPER = null;

    @NotNull
    static class_2487 getPresetsNbt() {
        return WorldConfig.getCompoundTag((ModCore)LibWoverWorldGenerator.C, (String)TAG_PRESET);
    }

    @NotNull
    static class_2487 getPresetsNbtFromFolder(class_32.class_5143 levelStorageAccess) {
        File dataDir = levelStorageAccess.method_27010(class_5218.field_24188).resolve("data").toFile();
        File nbtFile = new File(dataDir, LibWoverWorldGenerator.C.modId + ".nbt");
        class_2487 root = null;
        if (nbtFile.exists()) {
            try {
                root = class_2507.method_30613((Path)nbtFile.toPath(), (class_2505)class_2505.method_53899((long)0x200000L));
            }
            catch (IOException e) {
                LibWoverEvents.C.log.error("NBT loading failed", (Exception)e);
            }
        }
        if (root != null && root.method_10545(TAG_PRESET)) {
            return root.method_10562(TAG_PRESET);
        }
        return new class_2487();
    }

    @NotNull
    private static class_2487 getLegacyPresetsNbt() {
        return WorldConfig.getCompoundTag((ModCore)LegacyHelper.WORLDS_TOGETHER_CORE, (String)TAG_PRESET);
    }

    private static class_2487 getLegacyGeneratorNbt() {
        class_2487 root = WorldConfig.getRootTag((ModCore)LegacyHelper.WORLDS_TOGETHER_CORE);
        if (root.method_10545(LEGACY_TAG_GENERATOR)) {
            return WorldConfig.getCompoundTag((ModCore)LegacyHelper.WORLDS_TOGETHER_CORE, (String)LEGACY_TAG_GENERATOR);
        }
        return null;
    }

    public static void writeWorldPresetSettingsDirect(Map<class_5321<class_5363>, class_2794> settings) {
        DimensionsWrapper wrapper = new DimensionsWrapper(settings);
        WorldGeneratorConfigImpl.writeWorldPresetSettings(wrapper);
    }

    private static void writeWorldPresetSettings(DimensionsWrapper wrapper) {
        class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)WorldState.allStageRegistryAccess());
        DataResult encodeResult = DimensionsWrapper.CODEC.encodeStart((DynamicOps)registryOps, (Object)wrapper);
        if (encodeResult.result().isPresent()) {
            class_2487 settingsNbt = WorldConfig.getRootTag((ModCore)LibWoverWorldGenerator.C);
            settingsNbt.method_10566(TAG_PRESET, (class_2520)encodeResult.result().get());
        } else {
            LibWoverWorldGenerator.C.log.error("Unable to encode world generator settings for level.dat.");
        }
        WorldConfig.saveFile((ModCore)LibWoverWorldGenerator.C);
    }

    public static void migrateGeneratorSettings() {
        class_2487 settingsNbt = WorldGeneratorConfigImpl.getPresetsNbt();
        if (settingsNbt.method_33133()) {
            class_7723 dimensions;
            boolean isPre18;
            class_2487 wtGen = WorldGeneratorConfigImpl.getLegacyPresetsNbt();
            if (wtGen != null && wtGen.method_10545(TAG_DIMENSIONS)) {
                LibWoverWorldGenerator.C.log.info("Found World with WorldsTogether Settings.");
                class_2487 newPresets = WorldGeneratorConfigImpl.getPresetsNbt();
                newPresets.method_10566(TAG_DIMENSIONS, wtGen.method_10580(TAG_DIMENSIONS));
                WorldConfig.saveFile((ModCore)LibWoverWorldGenerator.C);
                return;
            }
            class_2487 oldGen = WorldGeneratorConfigImpl.getLegacyGeneratorNbt();
            if (oldGen != null && oldGen.method_10545("type")) {
                LibWoverWorldGenerator.C.log.info("Found World with beta generator Settings.");
                if ("bclib:bcl_world_preset_settings".equals(oldGen.method_10558("type"))) {
                    int netherVersion = 18;
                    int endVersion = 18;
                    if (oldGen.method_10545("minecraft:the_nether")) {
                        netherVersion = oldGen.method_10550("minecraft:the_nether");
                    }
                    if (oldGen.method_10545("minecraft:the_end")) {
                        endVersion = oldGen.method_10550("minecraft:the_end");
                    }
                    netherVersion = netherVersion == 18 ? 0 : (netherVersion == 17 ? 1 : 2);
                    endVersion = endVersion == 18 ? 0 : (endVersion == 17 ? 1 : 2);
                    List<Map<class_5321<class_5363>, class_2794>> presets = List.of(DimensionsWrapper.getDimensionsMap(WorldPresets.WOVER_WORLD), DimensionsWrapper.getDimensionsMap(PresetRegistryImpl.BCL_WORLD_17), DimensionsWrapper.getDimensionsMap((class_5321<class_7145>)class_5317.field_25050));
                    HashMap<class_5321<class_5363>, class_2794> dimensions2 = new HashMap<class_5321<class_5363>, class_2794>();
                    dimensions2.put(class_5363.field_25412, presets.get(0).get(class_5363.field_25412));
                    dimensions2.put(class_5363.field_25413, presets.get(netherVersion).get(class_5363.field_25413));
                    dimensions2.put(class_5363.field_25414, presets.get(endVersion).get(class_5363.field_25414));
                    WorldGeneratorConfigImpl.writeWorldPresetSettingsDirect(dimensions2);
                }
                return;
            }
            LibWoverWorldGenerator.C.log.info("Found World without generator Settings. Setting up data...");
            class_5321<class_7145> biomeSourceVersion = WorldPresets.WOVER_WORLD;
            class_2487 bclRoot = WorldConfig.getRootTag((ModCore)LegacyHelper.BCLIB_CORE);
            Version bclVersion = new Version("0.0.0");
            if (bclRoot.method_10545(LEGACY_TAG_VERSION)) {
                bclVersion = new Version(bclRoot.method_10558(LEGACY_TAG_VERSION));
            }
            boolean bl = isPre18 = !bclVersion.isLargerOrEqualVersion("1.0.0");
            if (isPre18) {
                LibWoverWorldGenerator.C.log.info("World was create pre 1.18!");
                biomeSourceVersion = PresetRegistryImpl.BCL_WORLD_17;
            }
            if (WorldConfig.hasMod((ModCore)IntegrationCore.BETTER_NETHER)) {
                LibWoverWorldGenerator.C.log.info("Found Data from BetterNether, using for migration.");
                class_2487 bnRoot = WorldConfig.getRootTag((ModCore)IntegrationCore.BETTER_NETHER);
                class_5321<class_7145> class_53212 = biomeSourceVersion = "1.17".equals(bnRoot.method_10558(LEGACY_TAG_BN_GEN_VERSION)) ? PresetRegistryImpl.BCL_WORLD_17 : WorldPresets.WOVER_WORLD;
            }
            if ((dimensions = DimensionsWrapper.getDimensions(biomeSourceVersion)) != null) {
                LibWoverWorldGenerator.C.log.info("Set world to BiomeSource Version " + String.valueOf(biomeSourceVersion));
                WorldGeneratorConfigImpl.writeWorldPresetSettings(new DimensionsWrapper(dimensions));
            } else {
                LibWoverWorldGenerator.C.log.error("Failed to set world to BiomeSource Version " + String.valueOf(biomeSourceVersion));
            }
        }
    }

    public static void createWorldConfig(class_6880<class_7145> currentPreset, class_7723 dimensions) {
        if (currentPreset != null && currentPreset.method_40230().isPresent()) {
            WorldPresetInfo info = WorldPresetInfoRegistry.getFor(currentPreset);
            class_5321 presetKey = (class_5321)currentPreset.method_40230().orElseThrow();
            for (Map.Entry dimEntry : dimensions.comp_1014().entrySet()) {
                class_2794 class_27942 = ((class_5363)dimEntry.getValue()).comp_1013();
                if (!(class_27942 instanceof ConfiguredChunkGenerator)) continue;
                ConfiguredChunkGenerator cfg = (ConfiguredChunkGenerator)class_27942;
                class_5321 secondaryPreset = info.getPresetOverrideRecursive((class_5321)dimEntry.getKey());
                if (cfg.wover_getConfiguredWorldPreset() != null) continue;
                cfg.wover_setConfiguredWorldPreset((class_5321<class_7145>)(secondaryPreset != null ? secondaryPreset : presetKey));
            }
        }
        LibWoverWorldGenerator.C.log.verbose("Creating presets file for new world");
        WorldGeneratorConfigImpl.writeWorldPresetSettingsDirect(DimensionsWrapper.build(dimensions));
    }

    @NotNull
    public static Map<class_5321<class_5363>, class_2794> loadWorldDimensions(class_5455 registryAccess, class_2487 presetNBT) {
        try {
            class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryAccess);
            if (DEFAULT_DIMENSIONS_WRAPPER == null) {
                DEFAULT_DIMENSIONS_WRAPPER = new DimensionsWrapper(DimensionsWrapper.getDimensionsMap(registryAccess, (class_5321<class_7145>)WorldPresetManager.getDefault()));
            }
            if (presetNBT == null || !presetNBT.method_10545(TAG_DIMENSIONS)) {
                return WorldGeneratorConfigImpl.DEFAULT_DIMENSIONS_WRAPPER.dimensions;
            }
            Optional oLevelStem = DimensionsWrapper.CODEC.parse(new Dynamic((DynamicOps)registryOps, (Object)presetNBT)).resultOrPartial(arg_0 -> ((Logger)LibWoverWorldGenerator.C.log).error(arg_0));
            return oLevelStem.orElse(WorldGeneratorConfigImpl.DEFAULT_DIMENSIONS_WRAPPER).dimensions;
        }
        catch (Exception e) {
            LibWoverWorldGenerator.C.log.error("Failed to load Dimensions", e);
            return WorldGeneratorConfigImpl.DEFAULT_DIMENSIONS_WRAPPER.dimensions;
        }
    }
}

