/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.chunkgenerator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2794;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7145;
import net.minecraft.class_7723;
import net.minecraft.class_7924;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.impl.chunkgenerator.ConfiguredChunkGenerator;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DimensionsWrapper {
    public static final Codec<DimensionsWrapper> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_5321.method_39154((class_5321)class_7924.field_41224), (Codec)class_2794.field_24746).optionalFieldOf("dimensions", new HashMap()).forGetter(o -> o.dimensions), (App)Codec.unboundedMap((Codec)class_5321.method_39154((class_5321)class_7924.field_41224), (Codec)class_5321.method_39154((class_5321)class_7924.field_41250)).optionalFieldOf("world_presets", new HashMap()).forGetter(DimensionsWrapper::getDimensionPresets)).apply((Applicative)instance, DimensionsWrapper::fromCodec));
    final Map<class_5321<class_5363>, class_2794> dimensions;

    static Map<class_5321<class_5363>, class_2794> build(class_7723 dimensions) {
        HashMap<class_5321<class_5363>, class_2794> map = new HashMap<class_5321<class_5363>, class_2794>();
        for (Map.Entry entry : dimensions.comp_1014().entrySet()) {
            class_5321 key = (class_5321)entry.getKey();
            class_5363 stem = (class_5363)entry.getValue();
            map.put((class_5321<class_5363>)key, stem.comp_1013());
        }
        return map;
    }

    @Nullable
    public static class_7723 getDimensions(class_5321<class_7145> key) {
        class_5455 access = WorldState.allStageRegistryAccess();
        if (access == null) {
            LibWoverWorldGenerator.C.log.error("No valid registry found!");
            return null;
        }
        Optional preset = access.method_30530(class_7924.field_41250).method_40264(key);
        return preset.map(worldPresetReference -> ((class_7145)worldPresetReference.comp_349()).method_45546()).orElse(null);
    }

    @Nullable
    public static class_7723 getDimensions(class_5455 access, class_5321<class_7145> key) {
        if (access == null) {
            LibWoverWorldGenerator.C.log.error("No valid registry found!");
            return null;
        }
        Optional preset = access.method_30530(class_7924.field_41250).method_40264(key);
        if (preset.isEmpty()) {
            return null;
        }
        return ((class_7145)((class_6880.class_6883)preset.get()).comp_349()).method_45546();
    }

    @NotNull
    public static Map<class_5321<class_5363>, class_2794> getDimensionsMap(class_5455 access, class_5321<class_7145> key) {
        class_7723 reg = DimensionsWrapper.getDimensions(access, key);
        if (reg == null) {
            return new HashMap<class_5321<class_5363>, class_2794>();
        }
        return DimensionsWrapper.build(reg);
    }

    @NotNull
    public static Map<class_5321<class_5363>, class_2794> getDimensionsMap(class_5321<class_7145> key) {
        class_7723 reg = DimensionsWrapper.getDimensions(key);
        if (reg == null) {
            return new HashMap<class_5321<class_5363>, class_2794>();
        }
        return DimensionsWrapper.build(reg);
    }

    private static DimensionsWrapper fromCodec(Map<class_5321<class_5363>, class_2794> dimensions, Map<class_5321<class_5363>, class_5321<class_7145>> presets) {
        for (Map.Entry<class_5321<class_5363>, class_2794> dimEntry : dimensions.entrySet()) {
            class_2794 class_27942;
            class_5321<class_7145> preset = presets.get(dimEntry.getKey());
            if (preset == null || !((class_27942 = dimEntry.getValue()) instanceof ConfiguredChunkGenerator)) continue;
            ConfiguredChunkGenerator cfg = (ConfiguredChunkGenerator)class_27942;
            cfg.wover_setConfiguredWorldPreset(preset);
        }
        return new DimensionsWrapper(dimensions);
    }

    DimensionsWrapper(class_7723 dimensions) {
        this(DimensionsWrapper.build(dimensions));
    }

    DimensionsWrapper(Map<class_5321<class_5363>, class_2794> dimensions) {
        this.dimensions = dimensions;
    }

    public Map<class_5321<class_5363>, class_5321<class_7145>> getDimensionPresets() {
        HashMap<class_5321<class_5363>, class_5321<class_7145>> map = new HashMap<class_5321<class_5363>, class_5321<class_7145>>();
        for (Map.Entry<class_5321<class_5363>, class_2794> dimEntry : this.dimensions.entrySet()) {
            ConfiguredChunkGenerator cfg;
            class_2794 class_27942 = dimEntry.getValue();
            if (!(class_27942 instanceof ConfiguredChunkGenerator) || (cfg = (ConfiguredChunkGenerator)class_27942).wover_getConfiguredWorldPreset() == null) continue;
            map.put(dimEntry.getKey(), cfg.wover_getConfiguredWorldPreset());
        }
        return map;
    }
}

