/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.chunkgenerator;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_32;
import net.minecraft.class_3754;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_7145;
import net.minecraft.class_7193;
import net.minecraft.class_7510;
import net.minecraft.class_7723;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.betterx.wover.biome.mixin.ChunkGeneratorAccessor;
import org.betterx.wover.config.api.Configs;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.core.api.registry.BuiltInRegistryManager;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.events.api.Subscriber;
import org.betterx.wover.events.api.WorldLifecycle;
import org.betterx.wover.events.api.types.CreatedNewWorldFolder;
import org.betterx.wover.generator.impl.chunkgenerator.ConfiguredChunkGenerator;
import org.betterx.wover.generator.impl.chunkgenerator.WorldGeneratorConfigImpl;
import org.betterx.wover.generator.impl.chunkgenerator.WoverChunkGenerator;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.state.api.WorldConfig;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkGeneratorManagerImpl {
    private static final class_2960 LEGACY_ID = LegacyHelper.BCLIB_CORE.convertNamespace(WoverChunkGenerator.ID);
    private static final List<String> GENERATOR_IDS = new ArrayList<String>(1);

    @ApiStatus.Internal
    public static Map<String, Supplier<TypeTemplate>> addGeneratorDSL(Map<String, Supplier<TypeTemplate>> map) {
        if (map.containsKey("minecraft:flat") && !ModCore.isDatagen()) {
            HashMap<String, Supplier<TypeTemplate>> nMap = new HashMap<String, Supplier<TypeTemplate>>(map);
            GENERATOR_IDS.forEach(id -> nMap.put((String)id, DSL::remainder));
            return ImmutableMap.copyOf(nMap);
        }
        return map;
    }

    @ApiStatus.Internal
    public static void initialize() {
        ChunkGeneratorManagerImpl.register(WoverChunkGenerator.ID, WoverChunkGenerator.CODEC);
        if (LegacyHelper.isLegacyEnabled()) {
            ChunkGeneratorManagerImpl.register(LEGACY_ID, (MapCodec<? extends class_2794>)LegacyHelper.wrap(WoverChunkGenerator.CODEC));
        }
        WorldConfig.registerMod((ModCore)LibWoverWorldGenerator.C);
        WorldLifecycle.CREATED_NEW_WORLD_FOLDER.subscribe((Subscriber)((CreatedNewWorldFolder)ChunkGeneratorManagerImpl::onWorldCreation), 20000);
    }

    private static void onWorldCreation(class_32.class_5143 storage, class_5455 access, class_6880<class_7145> currentPreset, class_7723 dimensions, boolean recreated) {
        WorldGeneratorConfigImpl.createWorldConfig(currentPreset, dimensions);
    }

    public static void onWorldReCreate(class_32.class_5143 storage, class_7193 context) {
        class_2487 configuredPreset = WorldGeneratorConfigImpl.getPresetsNbtFromFolder(storage);
        Map<class_5321<class_5363>, class_2794> dimensions = WorldGeneratorConfigImpl.loadWorldDimensions(WorldState.allStageRegistryAccess(), configuredPreset);
        for (Map.Entry dimEntry : context.comp_1028().comp_1014().entrySet()) {
            ConfiguredChunkGenerator loadGen;
            class_2794 class_27942;
            ConfiguredChunkGenerator refGen;
            class_2794 refDim = dimensions.get(dimEntry.getKey());
            if (!(refDim instanceof ConfiguredChunkGenerator) || (refGen = (ConfiguredChunkGenerator)refDim).wover_getConfiguredWorldPreset() == null || !((class_27942 = ((class_5363)dimEntry.getValue()).comp_1013()) instanceof ConfiguredChunkGenerator) || (loadGen = (ConfiguredChunkGenerator)class_27942).wover_getConfiguredWorldPreset() != null) continue;
            loadGen.wover_setConfiguredWorldPreset(refGen.wover_getConfiguredWorldPreset());
        }
    }

    public static void register(class_2960 location, MapCodec<? extends class_2794> codec) {
        String idString = location.toString();
        if (GENERATOR_IDS.contains(idString)) {
            throw new IllegalStateException("Duplicate generator id: " + idString);
        }
        GENERATOR_IDS.add(idString);
        BuiltInRegistryManager.register((class_2378)class_7923.field_41157, (class_2960)location, codec);
    }

    public static String enumerateFeatureNamespaces(@NotNull class_2794 chunkGenerator) {
        ChunkGeneratorAccessor acc;
        Supplier supplier;
        if (chunkGenerator instanceof ChunkGeneratorAccessor && (supplier = (acc = (ChunkGeneratorAccessor)chunkGenerator).wover_getFeaturesPerStep()) != null) {
            HashMap<String, Integer> namespaces = new HashMap<String, Integer>();
            try {
                List list = (List)supplier.get();
                if (list != null) {
                    for (class_7510.class_6827 features : list) {
                        if (features == null) continue;
                        for (class_6796 feature : features.comp_303()) {
                            class_2960 location;
                            if (feature == null) continue;
                            String namespace = null;
                            if (WorldState.registryAccess() != null && (location = WorldState.registryAccess().method_30530(class_7924.field_41245).method_10221((Object)feature)) != null) {
                                namespace = location.method_12836();
                            }
                            if (namespace == null && feature.comp_334() != null && feature.comp_334().method_40230().isPresent()) {
                                namespace = ((class_5321)feature.comp_334().method_40230().get()).method_29177().method_12836();
                            }
                            if (namespace == null) {
                                namespace = "none";
                            }
                            namespaces.put(namespace, namespaces.getOrDefault(namespace, 0) + 1);
                        }
                    }
                }
            }
            catch (Throwable e) {
                LibWoverWorldGenerator.C.log.warn("Failed to enumerate feature namespaces", new Object[]{e});
            }
            return namespaces.entrySet().stream().map(entry -> (String)entry.getKey() + "(" + String.valueOf(entry.getValue()) + ")").reduce((a, b) -> a + ", " + b).orElse("none");
        }
        return "unknown";
    }

    public static String printGeneratorInfo(@Nullable String className, @NotNull class_2794 generator) {
        StringBuilder sb = new StringBuilder();
        sb.append(className == null ? generator.getClass().getSimpleName() : className).append(" (").append(Integer.toHexString(generator.hashCode())).append(")");
        if (generator instanceof ConfiguredChunkGenerator) {
            ConfiguredChunkGenerator cfg = (ConfiguredChunkGenerator)generator;
            class_5321<class_7145> preset = cfg.wover_getConfiguredWorldPreset();
            sb.append("\n    preset     = ").append((Object)(preset == null ? "none" : preset.method_29177()));
        }
        if (generator instanceof class_3754) {
            class_3754 noise = (class_3754)generator;
            Optional key = noise.method_41541().method_40230();
            sb.append("\n    noise      = ").append((Object)(key.isEmpty() ? "custom" : ((class_5321)key.get()).method_29177()));
        }
        if (generator instanceof ChunkGeneratorAccessor) {
            sb.append("\n    features   = ").append(ChunkGeneratorManagerImpl.enumerateFeatureNamespaces(generator));
        }
        return sb.toString();
    }

    public static void printDimensionInfo(class_7723 dimensionRegistry) {
        if (!((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue()) {
            return;
        }
        ChunkGeneratorManagerImpl.printDimensionInfo("World Dimensions", dimensionRegistry.comp_1014().entrySet());
    }

    public static void printDimensionInfo(class_2378<class_5363> dimensionRegistry) {
        if (!((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue()) {
            return;
        }
        ChunkGeneratorManagerImpl.printDimensionInfo("World Dimensions", dimensionRegistry.method_29722());
    }

    public static void printDimensionInfo(String title, class_7723 dimensionRegistry) {
        ChunkGeneratorManagerImpl.printDimensionInfo(title, dimensionRegistry.comp_1014().entrySet());
    }

    public static void printDimensionInfo(String title, Set<Map.Entry<class_5321<class_5363>, class_5363>> levels) {
        StringBuilder output = new StringBuilder(title + ": ");
        for (Map.Entry<class_5321<class_5363>, class_5363> entry : levels) {
            output.append("\n - ").append(entry.getKey().method_29177()).append(": ").append("\n     ").append(entry.getValue().comp_1013().toString().replace("\n", "\n     ")).append("\n     ").append(entry.getValue().comp_1013().method_12098().toString().replace("\n", "\n     "));
        }
        LibWoverWorldGenerator.C.log.info(output.toString());
    }
}

