/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.chunkgenerator;

import com.google.common.base.Stopwatch;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.biome.v1.NetherBiomes;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_5317;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7145;
import net.minecraft.class_7924;
import org.betterx.wover.biome.impl.modification.BiomeTagModificationWorker;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceWithConfig;
import org.betterx.wover.common.generator.api.biomesource.ReloadableBiomeSource;
import org.betterx.wover.common.generator.api.chunkgenerator.EnforceableChunkGenerator;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.impl.biomesource.end.TheEndBiomesHelper;
import org.betterx.wover.generator.impl.chunkgenerator.ConfiguredChunkGenerator;
import org.betterx.wover.generator.impl.chunkgenerator.DimensionsWrapper;
import org.betterx.wover.generator.impl.chunkgenerator.WorldGeneratorConfigImpl;
import org.betterx.wover.tag.api.predefined.CommonBiomeTags;

class BiomeRepairHelper {
    private Map<class_5321<class_5363>, class_2794> vanillaDimensions = null;

    BiomeRepairHelper() {
    }

    public static class_6862<class_1959> getBiomeTagForDimension(class_5321<class_5363> key) {
        if (key.equals((Object)class_5363.field_25414)) {
            return CommonBiomeTags.IS_END_HIGHLAND;
        }
        if (key.equals((Object)class_5363.field_25413)) {
            return class_6908.field_36518;
        }
        if (key.equals((Object)class_5363.field_25412)) {
            return class_6908.field_37393;
        }
        return null;
    }

    public class_2378<class_5363> repairBiomeSourceInAllDimensions(class_5455 registryAccess, class_2378<class_5363> dimensionRegistry) {
        Map<class_5321<class_5363>, class_2794> configuredDimensions = WorldGeneratorConfigImpl.loadWorldDimensions(registryAccess, WorldGeneratorConfigImpl.getPresetsNbt());
        class_2378 biomes = registryAccess.method_30530(class_7924.field_41236);
        this.registerAllBiomesFromFabric((class_2378<class_1959>)biomes);
        Set originalSet = dimensionRegistry.method_29722();
        for (Map.Entry entry : originalSet) {
            class_1966 class_19662;
            boolean didRepair = false;
            class_5321 key = (class_5321)entry.getKey();
            class_5363 loadedStem = (class_5363)entry.getValue();
            class_2794 referenceGenerator = configuredDimensions.get(key);
            if (referenceGenerator instanceof EnforceableChunkGenerator) {
                EnforceableChunkGenerator enforcer = (EnforceableChunkGenerator)referenceGenerator;
                class_2794 loadedChunkGenerator = loadedStem.comp_1013();
                this.registerAllBiomesFromVanillaDimension(registryAccess, (class_2378<class_1959>)biomes, (class_5321<class_5363>)key);
                if (enforcer.togetherShouldRepair(loadedChunkGenerator)) {
                    dimensionRegistry = enforcer.enforceGeneratorInWorldGenSettings(registryAccess, key, (class_5321)loadedStem.comp_1012().method_40230().orElseThrow(), loadedChunkGenerator, dimensionRegistry);
                    didRepair = true;
                } else {
                    class_1966 class_19663 = loadedChunkGenerator.method_12098();
                    if (class_19663 instanceof BiomeSourceWithConfig) {
                        BiomeSourceWithConfig refSource;
                        BiomeSourceWithConfig lodedSource = (BiomeSourceWithConfig)class_19663;
                        class_1966 class_19664 = referenceGenerator.method_12098();
                        if (class_19664 instanceof BiomeSourceWithConfig && !(refSource = (BiomeSourceWithConfig)class_19664).getBiomeSourceConfig().sameConfig(lodedSource.getBiomeSourceConfig())) {
                            lodedSource.setBiomeSourceConfig(refSource.getBiomeSourceConfig());
                        }
                    }
                }
            }
            if (didRepair || !((class_19662 = loadedStem.comp_1013().method_12098()) instanceof ReloadableBiomeSource)) continue;
            ReloadableBiomeSource reload = (ReloadableBiomeSource)class_19662;
            reload.reloadBiomes();
        }
        BiomeRepairHelper.copyWorldPresetReference(dimensionRegistry, configuredDimensions);
        return dimensionRegistry;
    }

    private static void copyWorldPresetReference(class_2378<class_5363> dimensionRegistry, Map<class_5321<class_5363>, class_2794> configuredDimensions) {
        for (Map.Entry loadedDimension : dimensionRegistry.method_29722()) {
            ConfiguredChunkGenerator loadedCfg;
            class_2794 referenceGenerator = configuredDimensions.get(loadedDimension.getKey());
            if (!(referenceGenerator instanceof ConfiguredChunkGenerator)) continue;
            ConfiguredChunkGenerator refCfg = (ConfiguredChunkGenerator)referenceGenerator;
            class_2794 class_27942 = ((class_5363)loadedDimension.getValue()).comp_1013();
            if (!(class_27942 instanceof ConfiguredChunkGenerator) || (loadedCfg = (ConfiguredChunkGenerator)class_27942).wover_getConfiguredWorldPreset() != null) continue;
            loadedCfg.wover_setConfiguredWorldPreset(refCfg.wover_getConfiguredWorldPreset());
        }
    }

    private void registerAllBiomesFromFabric(class_2378<class_1959> biomes) {
        Stopwatch sw = Stopwatch.createStarted();
        int biomesAdded = 0;
        BiomeTagModificationWorker biomeTagWorker = new BiomeTagModificationWorker();
        for (Map.Entry e : biomes.method_29722()) {
            class_6880.class_6883 holder;
            class_6862 tag = null;
            if (NetherBiomes.canGenerateInNether((class_5321)((class_5321)e.getKey()))) {
                tag = class_6908.field_36518;
            } else if (TheEndBiomesHelper.canGenerateAsMainIslandBiome((class_5321<class_1959>)((class_5321)e.getKey()))) {
                tag = CommonBiomeTags.IS_END_CENTER;
            } else if (TheEndBiomesHelper.canGenerateAsHighlandsBiome((class_5321<class_1959>)((class_5321)e.getKey()))) {
                tag = CommonBiomeTags.IS_END_HIGHLAND;
            } else if (TheEndBiomesHelper.canGenerateAsEndBarrens((class_5321<class_1959>)((class_5321)e.getKey()))) {
                tag = CommonBiomeTags.IS_END_BARRENS;
            } else if (TheEndBiomesHelper.canGenerateAsSmallIslandsBiome((class_5321<class_1959>)((class_5321)e.getKey()))) {
                tag = CommonBiomeTags.IS_SMALL_END_ISLAND;
            } else if (TheEndBiomesHelper.canGenerateAsEndMidlands((class_5321<class_1959>)((class_5321)e.getKey()))) {
                tag = CommonBiomeTags.IS_END_MIDLAND;
            }
            if (tag == null || (holder = biomes.method_40290((class_5321)e.getKey())).method_40220(tag)) continue;
            biomeTagWorker.addBiomeToTag(tag, biomes, (class_5321)e.getKey(), (class_6880)holder);
            ++biomesAdded;
        }
        biomeTagWorker.finished();
        if (biomesAdded > 0) {
            LibWoverWorldGenerator.C.log.info("Added Tags for {} fabric biomes in {}", new Object[]{biomesAdded, sw});
        }
    }

    private void registerAllBiomesFromVanillaDimension(class_5455 access, class_2378<class_1959> biomes, class_5321<class_5363> key) {
        Stopwatch sw = Stopwatch.createStarted();
        int biomesAdded = 0;
        BiomeTagModificationWorker biomeTagWorker = new BiomeTagModificationWorker();
        class_6862<class_1959> tag = BiomeRepairHelper.getBiomeTagForDimension(key);
        if (tag != null) {
            class_2794 vanillaDim;
            if (this.vanillaDimensions == null) {
                this.vanillaDimensions = DimensionsWrapper.getDimensionsMap(access, (class_5321<class_7145>)class_5317.field_25050);
            }
            if ((vanillaDim = (class_2794)this.vanillaDimensions.getOrDefault(key, null)) != null && vanillaDim.method_12098() != null) {
                for (class_6880 biomeHolder : vanillaDim.method_12098().method_28443()) {
                    if (!biomeHolder.method_40230().isPresent() || biomeHolder.method_40220(tag)) continue;
                    biomeTagWorker.addBiomeToTag(tag, biomes, (class_5321)biomeHolder.method_40230().orElseThrow(), biomeHolder);
                    ++biomesAdded;
                }
            }
            biomeTagWorker.finished();
            if (biomesAdded > 0) {
                LibWoverWorldGenerator.C.log.info("Added {} biomes to {} in {}", new Object[]{biomesAdded, tag.comp_327(), sw});
            }
        }
    }
}

