/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.biomesource.nether;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceWithConfig;
import org.betterx.wover.generator.api.biomesource.WoverBiomePicker;
import org.betterx.wover.generator.api.biomesource.WoverBiomeSource;
import org.betterx.wover.generator.api.biomesource.nether.WoverNetherConfig;
import org.betterx.wover.generator.api.client.biomesource.client.BiomeSourceConfigPanel;
import org.betterx.wover.generator.api.client.biomesource.client.BiomeSourceWithConfigScreen;
import org.betterx.wover.generator.api.map.BiomeMap;
import org.betterx.wover.generator.api.map.MapBuilderFunction;
import org.betterx.wover.generator.impl.client.NetherConfigPage;
import org.betterx.wover.generator.impl.map.MapStack;
import org.jetbrains.annotations.NotNull;

public class WoverNetherBiomeSource
extends WoverBiomeSource
implements BiomeSourceWithConfig<WoverNetherBiomeSource, WoverNetherConfig>,
BiomeSourceWithConfigScreen<WoverNetherBiomeSource, WoverNetherConfig> {
    public static final MapCodec<WoverNetherBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(source -> source.currentSeed), (App)WoverNetherConfig.CODEC.fieldOf("config").orElse((Object)WoverNetherConfig.DEFAULT).forGetter(o -> o.config)).apply((Applicative)instance, instance.stable(WoverNetherBiomeSource::new)));
    public static final List<class_6862<class_1959>> TAGS = List.of(class_6908.field_36518);
    private BiomeMap biomeMap;
    private WoverBiomePicker biomePicker;
    private WoverNetherConfig config;

    public WoverNetherBiomeSource(WoverNetherConfig config) {
        this(0L, config, false);
    }

    private WoverNetherBiomeSource(long seed, WoverNetherConfig config) {
        this(seed, config, true);
    }

    private WoverNetherBiomeSource(long seed, WoverNetherConfig config, boolean initMaps) {
        super(seed);
        this.config = config;
        this.rebuildBiomes(false);
        if (initMaps) {
            this.initMap(seed);
        }
    }

    @Override
    protected List<WoverBiomeSource.TagToPicker> createFreshPickerMap() {
        this.biomePicker = new WoverBiomePicker(this.fallbackBiome());
        return List.of(new WoverBiomeSource.TagToPicker((class_6862<class_1959>)class_6908.field_36518, this.biomePicker));
    }

    @Override
    protected class_6862<class_1959> defaultBiomeTag() {
        return class_6908.field_36518;
    }

    @Override
    protected List<class_6862<class_1959>> acceptedTags() {
        return TAGS;
    }

    @Override
    protected class_6862<class_1959> tagForUnknownBiome(class_6880<class_1959> biomeHolder, class_5321<class_1959> biomeKey) {
        return this.defaultBiomeTag();
    }

    @Override
    protected class_5321<class_1959> fallbackBiome() {
        return class_1972.field_9461;
    }

    @Override
    public String toShortString() {
        return "WoVer - Nether BiomeSource (" + Integer.toHexString(this.hashCode()) + ")";
    }

    public String toString() {
        return this.toShortString() + "\n    biomes     = " + this.method_28443().size() + "\n    namespaces = " + this.getNamespaces() + "\n    seed       = " + this.currentSeed + "\n    height     = " + this.maxHeight + "\n    config     = " + String.valueOf(this.config);
    }

    @Override
    protected void onInitMap(long newSeed) {
        MapBuilderFunction mapConstructor = this.config.mapVersion.mapBuilder;
        this.biomeMap = (double)this.maxHeight > (double)this.config.biomeSizeVertical * 1.5 && this.config.useVerticalBiomes ? new MapStack(newSeed, this.config.biomeSize, this.biomePicker, this.config.biomeSizeVertical, this.maxHeight, mapConstructor) : mapConstructor.create(newSeed, this.config.biomeSize, this.biomePicker);
    }

    @Override
    protected void onHeightChange(int newHeight) {
        this.initMap(this.currentSeed);
    }

    @NotNull
    protected MapCodec<? extends class_1966> method_28442() {
        return CODEC;
    }

    @NotNull
    public class_6880<class_1959> method_38109(int biomeX, int biomeY, int biomeZ, class_6544.class_6552 var4) {
        if (!this.wasBound()) {
            this.reloadBiomes(false);
        }
        if (this.biomeMap == null) {
            return (class_6880)this.method_28443().stream().findFirst().get();
        }
        if ((biomeX & 0x3F) == 0 && (biomeZ & 0x3F) == 0) {
            this.biomeMap.clearCache();
        }
        WoverBiomePicker.PickableBiome bb = this.biomeMap.getBiome(biomeX << 2, biomeY << 2, biomeZ << 2);
        return bb.biome;
    }

    public WoverNetherConfig getBiomeSourceConfig() {
        return this.config;
    }

    public void setBiomeSourceConfig(WoverNetherConfig newConfig) {
        this.config = newConfig;
        this.initMap(this.currentSeed);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BiomeSourceConfigPanel<WoverNetherBiomeSource, WoverNetherConfig> biomeSourceConfigPanel(@NotNull class_437 parent) {
        return new NetherConfigPage(this.config);
    }
}

