/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.biomesource.end;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.betterx.wover.tag.api.predefined.CommonBiomeTags;
import org.jetbrains.annotations.ApiStatus;

public class TheEndBiomesHelper {
    @ApiStatus.Internal
    private static Map<class_6862, Set<class_5321<class_1959>>> END_BIOMES = new HashMap<class_6862, Set<class_5321<class_1959>>>();

    @ApiStatus.Internal
    public static void add(class_6862<class_1959> type, class_5321<class_1959> biome) {
        if (biome == null) {
            return;
        }
        END_BIOMES.computeIfAbsent(type, t -> new HashSet()).add(biome);
    }

    private static boolean has(class_6862<class_1959> type, class_5321<class_1959> biome) {
        if (biome == null) {
            return false;
        }
        Set<class_5321<class_1959>> set = END_BIOMES.get(type);
        if (set == null) {
            return false;
        }
        return set.contains(biome);
    }

    public static boolean canGenerateAsMainIslandBiome(class_5321<class_1959> biome) {
        return TheEndBiomesHelper.has((class_6862<class_1959>)CommonBiomeTags.IS_END_CENTER, biome);
    }

    public static boolean canGenerateAsSmallIslandsBiome(class_5321<class_1959> biome) {
        return TheEndBiomesHelper.has((class_6862<class_1959>)CommonBiomeTags.IS_SMALL_END_ISLAND, biome);
    }

    public static boolean canGenerateAsHighlandsBiome(class_5321<class_1959> biome) {
        return TheEndBiomesHelper.has((class_6862<class_1959>)CommonBiomeTags.IS_END_HIGHLAND, biome);
    }

    public static boolean canGenerateAsEndMidlands(class_5321<class_1959> biome) {
        return TheEndBiomesHelper.has((class_6862<class_1959>)CommonBiomeTags.IS_END_MIDLAND, biome);
    }

    public static boolean canGenerateAsEndBarrens(class_5321<class_1959> biome) {
        return TheEndBiomesHelper.has((class_6862<class_1959>)CommonBiomeTags.IS_END_BARRENS, biome);
    }

    public static boolean canGenerateInEnd(class_5321<class_1959> biome) {
        return TheEndBiomesHelper.canGenerateAsHighlandsBiome(biome) || TheEndBiomesHelper.canGenerateAsEndBarrens(biome) || TheEndBiomesHelper.canGenerateAsEndMidlands(biome) || TheEndBiomesHelper.canGenerateAsSmallIslandsBiome(biome) || TheEndBiomesHelper.canGenerateAsMainIslandBiome(biome);
    }
}

