/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.biomesource;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeDataRegistry;
import org.betterx.wover.biome.impl.data.BiomeDataRegistryImpl;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.api.biomesource.WoverBiomeSource;
import org.betterx.wover.generator.impl.biomesource.BiomeSourceManagerImpl;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.util.Pair;
import org.jetbrains.annotations.Nullable;

public class WoverBiomeSourceImpl {
    public static String getNamespaces(Collection<class_6880<class_1959>> biomes) {
        List<String> namespaces = biomes.stream().filter(h -> h.method_40230().isPresent()).map(h -> ((class_5321)h.method_40230().get()).method_29177().method_12836()).toList();
        return namespaces.stream().distinct().map(n -> n + "(" + namespaces.stream().filter(n::equals).count() + ")").collect(Collectors.joining(", "));
    }

    @Nullable
    public static Set<class_6880<class_1959>> populateBiomePickers(List<WoverBiomeSource.TagToPicker> pickers, WoverBiomeSource.PickerAdder pickerAdder) {
        class_5455 access = WorldState.registryAccess();
        if (access == null) {
            access = WorldState.allStageRegistryAccess();
            if (access != null) {
                LibWoverWorldGenerator.C.log.verbose("Registries were not finalized before populating BiomePickers!");
            } else {
                if (!ModCore.isDatagen()) {
                    LibWoverWorldGenerator.C.log.verbose("Unable to build Biome List yet");
                }
                return null;
            }
        }
        HashSet<class_6880<class_1959>> allBiomes = new HashSet<class_6880<class_1959>>();
        HashSet addedBiomes = new HashSet();
        class_2378 biomes = access.method_30530(class_7924.field_41236);
        class_2378 biomeData = access.method_30530(BiomeDataRegistry.BIOME_DATA_REGISTRY);
        for (WoverBiomeSource.TagToPicker mapper : pickers) {
            Optional optionalTag = biomes.method_40266(mapper.tag());
            if (!optionalTag.isPresent()) continue;
            class_6885.class_6888 tag = (class_6885.class_6888)optionalTag.get();
            Set<class_2960> excluded = BiomeSourceManagerImpl.getExcludedBiomes((class_6862<class_1959>)tag.method_40251());
            tag.method_40239().filter(holder -> holder.method_40230().isPresent()).map(holder -> new Pair(holder, (Object)((class_5321)holder.method_40230().get()))).filter(pair -> !addedBiomes.contains(pair.second)).filter(pair -> !excluded.contains(((class_5321)pair.second).method_29177())).sorted(Comparator.comparing(pair -> ((class_5321)pair.second).method_29177().toString())).forEach(pair -> {
                BiomeData data = BiomeDataRegistryImpl.getFromRegistryOrTemp((class_2378)biomeData, (class_5321)((class_5321)pair.second));
                boolean isPossible = data != null && data.isPickable() ? pickerAdder.add(data, mapper.tag(), mapper.picker()) : true;
                if (isPossible) {
                    addedBiomes.add((class_5321)pair.second);
                    allBiomes.add((class_6880)pair.first);
                }
            });
        }
        return allBiomes;
    }

    public record PopulateResult(Set<class_6880<class_1959>> possibleBiomes, List<WoverBiomeSource.TagToPicker> pickers) {
    }
}

