/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.biomesource;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.biome.v1.NetherBiomes;
import net.fabricmc.fabric.api.biome.v1.TheEndBiomes;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6544;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeDataRegistry;
import org.betterx.wover.common.generator.api.biomesource.ReloadableBiomeSource;
import org.betterx.wover.config.api.DatapackConfigs;
import org.betterx.wover.core.api.IntegrationCore;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.core.api.registry.BuiltInRegistryManager;
import org.betterx.wover.core.api.registry.DatapackRegistryBuilder;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.events.api.Subscriber;
import org.betterx.wover.events.api.WorldLifecycle;
import org.betterx.wover.events.api.types.OnResourceLoad;
import org.betterx.wover.generator.api.biomesource.WoverBiomeData;
import org.betterx.wover.generator.impl.biomesource.WoverBiomeSourceImpl;
import org.betterx.wover.generator.impl.biomesource.end.TheEndBiomesHelper;
import org.betterx.wover.generator.impl.biomesource.end.WoverEndBiomeSource;
import org.betterx.wover.generator.impl.biomesource.nether.WoverNetherBiomeSource;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.tag.api.predefined.CommonBiomeTags;
import org.betterx.wover.util.ResourceLocationSet;
import org.jetbrains.annotations.ApiStatus;

public class BiomeSourceManagerImpl {
    public static final class_2960 BIOME_CONFIG_FILE = LibWoverWorldGenerator.C.id("biome_config.json");
    public static final class_2960 MINECRAFT_WILDCARD = ResourceLocationSet.WildcardResourceLocation.forAllFrom((ModCore)IntegrationCore.MINECRAFT);
    public static final String BIOME_EXCLUSION_TAG = "exclude";
    public static final String NO_FABRIC_REGISTER_TAG = "no_fabric_register";
    public static final String END_CATCH_ALL = "*:is_end";
    public static final String NETHER_CATCH_ALL = "*:is_nether";
    private static final Map<class_6862<class_1959>, Set<class_2960>> EXCLUSIONS = new HashMap<class_6862<class_1959>, Set<class_2960>>();
    private static final Set<class_2960> FABRIC_EXCLUDES = new ResourceLocationSet();

    public static void register(class_2960 location, MapCodec<? extends class_1966> codec) {
        BuiltInRegistryManager.register((class_2378)class_7923.field_41156, (class_2960)location, codec);
    }

    @ApiStatus.Internal
    public static void initialize() {
        BiomeSourceManagerImpl.register(LibWoverWorldGenerator.C.id("nether_biome_source"), WoverNetherBiomeSource.CODEC);
        BiomeSourceManagerImpl.register(LibWoverWorldGenerator.C.id("end_biome_source"), WoverEndBiomeSource.CODEC);
        if (LegacyHelper.isLegacyEnabled()) {
            BiomeSourceManagerImpl.register(LegacyHelper.BCLIB_CORE.id("nether_biome_source"), (MapCodec<? extends class_1966>)LegacyHelper.wrap(WoverNetherBiomeSource.CODEC));
            BiomeSourceManagerImpl.register(LegacyHelper.BCLIB_CORE.id("end_biome_source"), (MapCodec<? extends class_1966>)LegacyHelper.wrap(WoverEndBiomeSource.CODEC));
        }
        WorldLifecycle.RESOURCES_LOADED.subscribe((Subscriber)((OnResourceLoad)BiomeSourceManagerImpl::onResourcesLoaded));
        DatapackRegistryBuilder.onElementLoad((class_5321)BiomeDataRegistry.BIOME_DATA_REGISTRY, BiomeSourceManagerImpl::didLoadBiomeData);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void didLoadBiomeData(class_5321<BiomeData> biomeDataKey, BiomeData biomeData) {
        if (biomeDataKey.method_29177().method_12836().equals("minecraft")) {
            return;
        }
        class_5321 biomeKey = BiomeDataRegistry.createBiomeKey(biomeDataKey);
        if (FABRIC_EXCLUDES.contains(biomeKey.method_29177())) return;
        if (biomeData.isIntendedFor(class_6908.field_36518)) {
            Iterator iterator = biomeData.generationData.parameterPoints().iterator();
            while (iterator.hasNext()) {
                class_6544.class_4762 param = (class_6544.class_4762)iterator.next();
                if (NetherBiomes.canGenerateInNether((class_5321)biomeKey)) continue;
                LibWoverWorldGenerator.C.log.verbose("Adding Nether Biome to Fabric: " + String.valueOf(biomeKey.method_29177()) + " (" + String.valueOf(param) + ")");
                NetherBiomes.addNetherBiome((class_5321)biomeKey, (class_6544.class_4762)param);
            }
            return;
        }
        if (TheEndBiomesHelper.canGenerateInEnd((class_5321<class_1959>)biomeKey)) return;
        if (biomeData.isIntendedFor(CommonBiomeTags.IS_END_LAND) || biomeData.isIntendedFor(class_6908.field_37394)) {
            if (!TheEndBiomesHelper.canGenerateAsHighlandsBiome((class_5321<class_1959>)biomeKey)) {
                LibWoverWorldGenerator.C.log.verbose("Adding End Highland Biome to Fabric: " + String.valueOf(biomeKey.method_29177()));
                TheEndBiomes.addHighlandsBiome((class_5321)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 1.0f));
            }
            if (TheEndBiomesHelper.canGenerateAsEndMidlands((class_5321<class_1959>)biomeKey)) return;
            LibWoverWorldGenerator.C.log.verbose("Adding End Highland Biome to Fabric: " + String.valueOf(biomeKey.method_29177()));
            TheEndBiomes.addMidlandsBiome((class_5321)biomeKey, (class_5321)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 0.5f));
            return;
        }
        if (biomeData.isIntendedFor(CommonBiomeTags.IS_END_HIGHLAND)) {
            if (TheEndBiomesHelper.canGenerateAsHighlandsBiome((class_5321<class_1959>)biomeKey)) return;
            LibWoverWorldGenerator.C.log.verbose("Adding End Highland Biome to Fabric: " + String.valueOf(biomeKey.method_29177()));
            TheEndBiomes.addHighlandsBiome((class_5321)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 1.0f));
            return;
        }
        if (biomeData.isIntendedFor(CommonBiomeTags.IS_END_CENTER)) {
            if (TheEndBiomesHelper.canGenerateAsMainIslandBiome((class_5321<class_1959>)biomeKey)) return;
            LibWoverWorldGenerator.C.log.verbose("Adding End Center Biome to Fabric: " + String.valueOf(biomeKey.method_29177()));
            TheEndBiomes.addMainIslandBiome((class_5321)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 1.0f));
            return;
        }
        if (biomeData.isIntendedFor(CommonBiomeTags.IS_SMALL_END_ISLAND)) {
            if (TheEndBiomesHelper.canGenerateAsSmallIslandsBiome((class_5321<class_1959>)biomeKey)) return;
            LibWoverWorldGenerator.C.log.verbose("Adding Small End Island Biome to Fabric: " + String.valueOf(biomeKey.method_29177()));
            TheEndBiomes.addSmallIslandsBiome((class_5321)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 1.0f));
            return;
        }
        if (biomeData.isIntendedFor(CommonBiomeTags.IS_END_MIDLAND)) {
            if (TheEndBiomesHelper.canGenerateAsEndMidlands((class_5321<class_1959>)biomeKey)) return;
            if (biomeData instanceof WoverBiomeData) {
                WoverBiomeData woverData = (WoverBiomeData)biomeData;
                if (woverData.parent != null) {
                    LibWoverWorldGenerator.C.log.verbose("Adding End Midland Biome to Fabric: " + String.valueOf(biomeKey.method_29177()));
                    TheEndBiomes.addMidlandsBiome(woverData.parent, (class_5321)biomeKey, (double)woverData.genChance);
                    return;
                }
            }
            if (TheEndBiomesHelper.canGenerateAsHighlandsBiome((class_5321<class_1959>)biomeKey)) return;
            LibWoverWorldGenerator.C.log.verbose("Adding End Highland Biome to Fabric: " + String.valueOf(biomeKey.method_29177()));
            TheEndBiomes.addHighlandsBiome((class_5321)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 0.5f));
            return;
        }
        if (!biomeData.isIntendedFor(CommonBiomeTags.IS_END_BARRENS)) {
            if (!biomeData.isIntendedFor(class_6908.field_37394)) return;
            if (TheEndBiomesHelper.canGenerateAsHighlandsBiome((class_5321<class_1959>)biomeKey)) return;
            LibWoverWorldGenerator.C.log.verbose("Adding End Highland Biome to Fabric: " + String.valueOf(biomeKey.method_29177()));
            TheEndBiomes.addHighlandsBiome((class_5321)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 1.0f));
            return;
        }
        if (TheEndBiomesHelper.canGenerateAsEndBarrens((class_5321<class_1959>)biomeKey)) return;
        if (biomeData instanceof WoverBiomeData) {
            WoverBiomeData woverData = (WoverBiomeData)biomeData;
            if (woverData.parent != null) {
                LibWoverWorldGenerator.C.log.verbose("Adding End Barrens Biome to Fabric: " + String.valueOf(biomeKey.method_29177()));
                TheEndBiomes.addBarrensBiome(woverData.parent, (class_5321)biomeKey, (double)woverData.genChance);
                return;
            }
        }
        if (TheEndBiomesHelper.canGenerateAsHighlandsBiome((class_5321<class_1959>)biomeKey)) return;
        LibWoverWorldGenerator.C.log.verbose("Adding End Highland Biome to Fabric: " + String.valueOf(biomeKey.method_29177()));
        TheEndBiomes.addHighlandsBiome((class_5321)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 0.33f));
    }

    private static float genChance(BiomeData data, float defaultChance) {
        float f;
        if (data instanceof WoverBiomeData) {
            WoverBiomeData woverData = (WoverBiomeData)data;
            f = woverData.genChance;
        } else {
            f = defaultChance;
        }
        return f;
    }

    public static void onResourcesLoaded(class_3300 resourceManager) {
        EXCLUSIONS.clear();
        FABRIC_EXCLUDES.clear();
        FABRIC_EXCLUDES.add(MINECRAFT_WILDCARD);
        DatapackConfigs.instance().runForResource(resourceManager, BIOME_CONFIG_FILE, BiomeSourceManagerImpl::processBiomeConfigs);
        if (WorldState.registryAccess() != null && !EXCLUSIONS.isEmpty()) {
            WorldState.registryAccess().method_33310(class_7924.field_41224).ifPresent(levelStems -> levelStems.method_40270().forEach(holder -> {
                class_1966 patt0$temp;
                if (holder.method_40227() && (patt0$temp = ((class_5363)holder.comp_349()).comp_1013().method_12098()) instanceof ReloadableBiomeSource) {
                    ReloadableBiomeSource bs = (ReloadableBiomeSource)patt0$temp;
                    bs.reloadBiomes();
                }
            }));
        }
    }

    public static Set<class_2960> getExcludedBiomes(class_6862<class_1959> tag) {
        return EXCLUSIONS.getOrDefault(tag, Set.of());
    }

    private static void addAllExclusions(List<class_6862<class_1959>> tags, class_2960 biome) {
        tags.forEach(tag -> EXCLUSIONS.computeIfAbsent((class_6862<class_1959>)tag, k -> new ResourceLocationSet()).add(biome));
    }

    private static void addBiomesToExclusion(JsonElement value, Consumer<class_2960> adder) {
        if (value.isJsonPrimitive()) {
            adder.accept(ResourceLocationSet.WildcardResourceLocation.parse((String)value.getAsString()));
        } else if (value.isJsonArray()) {
            value.getAsJsonArray().forEach(v -> adder.accept(ResourceLocationSet.WildcardResourceLocation.parse((String)v.getAsString())));
        }
    }

    private static void processBiomeConfigs(class_2960 location, JsonObject root) {
        JsonObject excludes;
        if (root.has(BIOME_EXCLUSION_TAG)) {
            excludes = root.getAsJsonObject(BIOME_EXCLUSION_TAG);
            excludes.asMap().forEach((key, value) -> {
                if (key.equals(END_CATCH_ALL)) {
                    List<class_6862<class_1959>> endTags = WoverEndBiomeSource.TAGS;
                    BiomeSourceManagerImpl.addBiomesToExclusion(value, id -> BiomeSourceManagerImpl.addAllExclusions(endTags, id));
                } else if (key.equals(NETHER_CATCH_ALL)) {
                    List<class_6862<class_1959>> netherTags = WoverNetherBiomeSource.TAGS;
                    BiomeSourceManagerImpl.addBiomesToExclusion(value, id -> BiomeSourceManagerImpl.addAllExclusions(netherTags, id));
                } else {
                    class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60654((String)key));
                    Set elements = EXCLUSIONS.computeIfAbsent((class_6862<class_1959>)tag, k -> new ResourceLocationSet());
                    BiomeSourceManagerImpl.addBiomesToExclusion(value, elements::add);
                }
            });
        }
        if (root.has(NO_FABRIC_REGISTER_TAG)) {
            excludes = root.getAsJsonArray(NO_FABRIC_REGISTER_TAG);
            excludes.forEach(v -> FABRIC_EXCLUDES.add(ResourceLocationSet.WildcardResourceLocation.parse((String)v.getAsString())));
        }
    }

    public static String printBiomeSourceInfo(class_1966 biomeSource) {
        Set biomes = Set.of();
        try {
            biomes = biomeSource.method_28443();
        }
        catch (Throwable e) {
            LibWoverWorldGenerator.C.log.warn("Error getting possible biomes from BiomeSource", new Object[]{e});
        }
        return biomeSource.getClass().getSimpleName() + " (" + Integer.toHexString(biomeSource.hashCode()) + ")\n    biomes     = " + biomes.size() + "\n    namespaces = " + WoverBiomeSourceImpl.getNamespaces(biomes);
    }
}

