/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.datagen;

import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6880;
import net.minecraft.class_7145;
import net.minecraft.class_7871;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.provider.WoverWorldPresetProvider;
import org.betterx.wover.generator.api.biomesource.end.WoverEndConfig;
import org.betterx.wover.generator.api.biomesource.nether.WoverNetherConfig;
import org.betterx.wover.generator.api.preset.WorldPresets;
import org.betterx.wover.generator.impl.chunkgenerator.WoverChunkGenerator;
import org.betterx.wover.generator.impl.preset.PresetRegistryImpl;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.preset.api.WorldPresetManager;
import org.betterx.wover.preset.api.WorldPresetTags;
import org.betterx.wover.preset.api.context.WorldPresetBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public class WorldPresetProvider
extends WoverWorldPresetProvider {
    public WorldPresetProvider(ModCore modCore) {
        super(modCore, "Wover Presets");
    }

    protected void bootstrap(WorldPresetBootstrapContext ctx) {
        ctx.method_46838(WorldPresets.WOVER_WORLD, (Object)WorldPresetProvider.createNormal(ctx));
        ctx.method_46838(WorldPresets.WOVER_WORLD_LARGE, (Object)WorldPresetProvider.createLarge(ctx));
        ctx.method_46838(WorldPresets.WOVER_WORLD_AMPLIFIED, (Object)WorldPresetProvider.createAmplified(ctx));
        if (LegacyHelper.isLegacyEnabled()) {
            class_5321 BCL_WORLD = WorldPresetManager.createKey((class_2960)LegacyHelper.BCLIB_CORE.convertNamespace(WorldPresets.WOVER_WORLD));
            class_5321 BCL_WORLD_LARGE = WorldPresetManager.createKey((class_2960)LegacyHelper.BCLIB_CORE.convertNamespace(WorldPresets.WOVER_WORLD_LARGE));
            class_5321 BCL_WORLD_AMPLIFIED = WorldPresetManager.createKey((class_2960)LegacyHelper.BCLIB_CORE.convertNamespace(WorldPresets.WOVER_WORLD_AMPLIFIED));
            ctx.method_46838(PresetRegistryImpl.BCL_WORLD_17, (Object)WorldPresetProvider.createLegacy(ctx));
            ctx.method_46838(BCL_WORLD, (Object)WorldPresetProvider.createNormal(ctx));
            ctx.method_46838(BCL_WORLD_LARGE, (Object)WorldPresetProvider.createLarge(ctx));
            ctx.method_46838(BCL_WORLD_AMPLIFIED, (Object)WorldPresetProvider.createAmplified(ctx));
        }
    }

    protected void prepareTags(TagBootstrapContext<class_7145> provider) {
        provider.add(WorldPresetTags.NORMAL, new class_5321[]{WorldPresets.WOVER_WORLD, WorldPresets.WOVER_WORLD_AMPLIFIED, WorldPresets.WOVER_WORLD_LARGE});
    }

    private static class_7145 createLegacy(WorldPresetBootstrapContext ctx) {
        return WorldPresetProvider.buildPreset(ctx.overworldStem, ctx.netherContext, WoverNetherConfig.MINECRAFT_17, ctx.endContext, WoverEndConfig.MINECRAFT_17);
    }

    private static class_7145 createAmplified(WorldPresetBootstrapContext ctx) {
        class_6880.class_6883 amplifiedBiomeGenerator = ctx.noiseSettings.method_46747(class_5284.field_26356);
        WorldPresetBootstrapContext.StemContext amplifiedNetherContext = WorldPresetBootstrapContext.StemContext.of((class_6880)ctx.netherContext.dimension, (class_7871)ctx.netherContext.structureSets, (class_6880)ctx.noiseSettings.method_46747(WoverChunkGenerator.AMPLIFIED_NETHER));
        return WorldPresetProvider.buildPreset(ctx.makeNoiseBasedOverworld(ctx.overworldStem.comp_1013().method_12098(), (class_6880)amplifiedBiomeGenerator), amplifiedNetherContext, WoverNetherConfig.MINECRAFT_18_AMPLIFIED, ctx.endContext, WoverEndConfig.MINECRAFT_20_AMPLIFIED);
    }

    private static class_7145 createLarge(WorldPresetBootstrapContext ctx) {
        class_6880.class_6883 largeBiomeGenerator = ctx.noiseSettings.method_46747(class_5284.field_35051);
        return WorldPresetProvider.buildPreset(ctx.makeNoiseBasedOverworld(ctx.overworldStem.comp_1013().method_12098(), (class_6880)largeBiomeGenerator), ctx.netherContext, WoverNetherConfig.MINECRAFT_18_LARGE, ctx.endContext, WoverEndConfig.MINECRAFT_20_LARGE);
    }

    private static class_7145 createNormal(WorldPresetBootstrapContext ctx) {
        return WorldPresetProvider.buildPreset(ctx.overworldStem, ctx.netherContext, WoverNetherConfig.DEFAULT, ctx.endContext, WoverEndConfig.DEFAULT);
    }

    private static class_7145 buildPreset(class_5363 overworldStem, WorldPresetBootstrapContext.StemContext netherContext, WoverNetherConfig netherConfig, WorldPresetBootstrapContext.StemContext endContext, WoverEndConfig endConfig) {
        return WorldPresetManager.of(WorldPresetProvider.buildDimensionMap(overworldStem, netherContext, netherConfig, endContext, endConfig));
    }

    public static Map<class_5321<class_5363>, class_5363> buildDimensionMap(class_5363 overworldStem, WorldPresetBootstrapContext.StemContext netherContext, WoverNetherConfig netherConfig, WorldPresetBootstrapContext.StemContext endContext, WoverEndConfig endConfig) {
        return Map.of(class_5363.field_25412, overworldStem, class_5363.field_25413, WorldPresets.makeWoverNetherStem(netherContext, netherConfig), class_5363.field_25414, WorldPresets.makeWoverEndStem(endContext, endConfig));
    }
}

