/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.api.biomesource.nether;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceConfig;
import org.betterx.wover.generator.api.map.MapBuilderFunction;
import org.betterx.wover.generator.impl.biomesource.nether.WoverNetherBiomeSource;
import org.betterx.wover.generator.impl.map.hex.HexBiomeMap;
import org.betterx.wover.generator.impl.map.square.SquareBiomeMap;
import org.jetbrains.annotations.NotNull;

public class WoverNetherConfig
implements BiomeSourceConfig<WoverNetherBiomeSource> {
    public static final WoverNetherConfig VANILLA = new WoverNetherConfig(NetherBiomeMapType.VANILLA, 256, 86, false);
    public static final WoverNetherConfig MINECRAFT_17 = new WoverNetherConfig(NetherBiomeMapType.SQUARE, 256, 86, true);
    public static final WoverNetherConfig MINECRAFT_18 = new WoverNetherConfig(NetherBiomeMapType.HEX, WoverNetherConfig.MINECRAFT_17.biomeSize, WoverNetherConfig.MINECRAFT_17.biomeSizeVertical, WoverNetherConfig.MINECRAFT_17.useVerticalBiomes);
    public static final WoverNetherConfig MINECRAFT_18_LARGE = new WoverNetherConfig(NetherBiomeMapType.HEX, WoverNetherConfig.MINECRAFT_18.biomeSize * 4, WoverNetherConfig.MINECRAFT_18.biomeSizeVertical * 2, WoverNetherConfig.MINECRAFT_18.useVerticalBiomes);
    public static final WoverNetherConfig MINECRAFT_18_AMPLIFIED = new WoverNetherConfig(NetherBiomeMapType.HEX, WoverNetherConfig.MINECRAFT_18.biomeSize, 128, true);
    public static final WoverNetherConfig DEFAULT = MINECRAFT_18;
    public static final Codec<WoverNetherConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NetherBiomeMapType.CODEC.fieldOf("map_type").orElse((Object)WoverNetherConfig.DEFAULT.mapVersion).forGetter(o -> o.mapVersion), (App)Codec.INT.fieldOf("biome_size").orElse((Object)WoverNetherConfig.DEFAULT.biomeSize).forGetter(o -> o.biomeSize), (App)Codec.INT.fieldOf("biome_size_vertical").orElse((Object)WoverNetherConfig.DEFAULT.biomeSizeVertical).forGetter(o -> o.biomeSizeVertical), (App)Codec.BOOL.fieldOf("use_vertical_biomes").orElse((Object)WoverNetherConfig.DEFAULT.useVerticalBiomes).forGetter(o -> o.useVerticalBiomes)).apply((Applicative)instance, WoverNetherConfig::new));
    @NotNull
    public final NetherBiomeMapType mapVersion;
    public final int biomeSize;
    public final int biomeSizeVertical;
    public final boolean useVerticalBiomes;

    public WoverNetherConfig(@NotNull NetherBiomeMapType mapVersion, int biomeSize, int biomeSizeVertical, boolean useVerticalBiomes) {
        this.mapVersion = mapVersion;
        this.biomeSize = class_3532.method_15340((int)biomeSize, (int)1, (int)8192);
        this.biomeSizeVertical = class_3532.method_15340((int)biomeSizeVertical, (int)1, (int)8192);
        this.useVerticalBiomes = useVerticalBiomes;
    }

    public String toString() {
        return "NetherConfig{mapVersion=" + String.valueOf((Object)this.mapVersion) + ", useVerticalBiomes=" + this.useVerticalBiomes + ", biomeSize=" + this.biomeSize / 16 + ", biomeSizeVertical=" + this.biomeSizeVertical / 16 + "}";
    }

    public boolean couldSetWithoutRepair(BiomeSourceConfig<?> input) {
        if (input instanceof WoverNetherConfig) {
            WoverNetherConfig cfg = (WoverNetherConfig)input;
            return this.mapVersion == cfg.mapVersion;
        }
        return false;
    }

    public boolean sameConfig(BiomeSourceConfig<?> input) {
        return this.equals(input);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WoverNetherConfig)) {
            return false;
        }
        WoverNetherConfig that = (WoverNetherConfig)o;
        return this.mapVersion == that.mapVersion;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mapVersion});
    }

    public static enum NetherBiomeMapType implements class_3542
    {
        VANILLA("vanilla", (seed, biomeSize, picker) -> new HexBiomeMap(seed, biomeSize, picker)),
        SQUARE("square", (seed, biomeSize, picker) -> new SquareBiomeMap(seed, biomeSize, picker)),
        HEX("hex", (seed, biomeSize, picker) -> new HexBiomeMap(seed, biomeSize, picker));

        public static final Codec<NetherBiomeMapType> CODEC;
        public final String name;
        public final MapBuilderFunction mapBuilder;

        private NetherBiomeMapType(String name, MapBuilderFunction mapBuilder) {
            this.name = name;
            this.mapBuilder = mapBuilder;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(NetherBiomeMapType::values);
        }
    }
}

