/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.api.biomesource.end;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceConfig;
import org.betterx.wover.core.api.IntegrationCore;
import org.betterx.wover.generator.api.map.MapBuilderFunction;
import org.betterx.wover.generator.impl.biomesource.end.WoverEndBiomeSource;
import org.betterx.wover.generator.impl.map.hex.HexBiomeMap;
import org.betterx.wover.generator.impl.map.square.SquareBiomeMap;
import org.jetbrains.annotations.NotNull;

public class WoverEndConfig
implements BiomeSourceConfig<WoverEndBiomeSource> {
    public static final WoverEndConfig VANILLA = new WoverEndConfig(EndBiomeMapType.VANILLA, EndBiomeGeneratorType.VANILLA, true, 4096, 128, 128, 128, 128);
    public static final WoverEndConfig MINECRAFT_17 = new WoverEndConfig(EndBiomeMapType.SQUARE, EndBiomeGeneratorType.PAULEVS, true, WoverEndConfig.VANILLA.innerVoidRadiusSquared * 16 * 16, 256, 256, 256, 256);
    public static final WoverEndConfig MINECRAFT_18 = new WoverEndConfig(EndBiomeMapType.HEX, IntegrationCore.RUNS_NULLSCAPE ? EndBiomeGeneratorType.VANILLA : EndBiomeGeneratorType.PAULEVS, !IntegrationCore.RUNS_NULLSCAPE, WoverEndConfig.MINECRAFT_17.innerVoidRadiusSquared, WoverEndConfig.MINECRAFT_17.centerBiomesSize, WoverEndConfig.MINECRAFT_17.voidBiomesSize, WoverEndConfig.MINECRAFT_17.landBiomesSize, WoverEndConfig.MINECRAFT_17.barrensBiomesSize);
    public static final WoverEndConfig MINECRAFT_18_LARGE = new WoverEndConfig(EndBiomeMapType.HEX, IntegrationCore.RUNS_NULLSCAPE ? EndBiomeGeneratorType.VANILLA : EndBiomeGeneratorType.PAULEVS, !IntegrationCore.RUNS_NULLSCAPE, WoverEndConfig.MINECRAFT_18.innerVoidRadiusSquared, WoverEndConfig.MINECRAFT_18.centerBiomesSize, WoverEndConfig.MINECRAFT_18.voidBiomesSize * 2, WoverEndConfig.MINECRAFT_18.landBiomesSize * 4, WoverEndConfig.MINECRAFT_18.barrensBiomesSize * 2);
    public static final WoverEndConfig MINECRAFT_18_AMPLIFIED = new WoverEndConfig(EndBiomeMapType.HEX, EndBiomeGeneratorType.PAULEVS, true, WoverEndConfig.MINECRAFT_18.innerVoidRadiusSquared, WoverEndConfig.MINECRAFT_18.centerBiomesSize, WoverEndConfig.MINECRAFT_18.voidBiomesSize, WoverEndConfig.MINECRAFT_18.landBiomesSize, WoverEndConfig.MINECRAFT_18.barrensBiomesSize);
    public static final WoverEndConfig MINECRAFT_20 = new WoverEndConfig(EndBiomeMapType.HEX, EndBiomeGeneratorType.VANILLA, !IntegrationCore.RUNS_NULLSCAPE, WoverEndConfig.MINECRAFT_17.innerVoidRadiusSquared, WoverEndConfig.MINECRAFT_17.centerBiomesSize, WoverEndConfig.MINECRAFT_17.voidBiomesSize, WoverEndConfig.MINECRAFT_17.landBiomesSize, WoverEndConfig.MINECRAFT_17.barrensBiomesSize);
    public static final WoverEndConfig MINECRAFT_20_LARGE = new WoverEndConfig(EndBiomeMapType.HEX, EndBiomeGeneratorType.VANILLA, !IntegrationCore.RUNS_NULLSCAPE, WoverEndConfig.MINECRAFT_18.innerVoidRadiusSquared, WoverEndConfig.MINECRAFT_18.centerBiomesSize, WoverEndConfig.MINECRAFT_18.voidBiomesSize * 2, WoverEndConfig.MINECRAFT_18.landBiomesSize * 4, WoverEndConfig.MINECRAFT_18.barrensBiomesSize * 2);
    public static final WoverEndConfig MINECRAFT_20_AMPLIFIED = new WoverEndConfig(EndBiomeMapType.HEX, EndBiomeGeneratorType.VANILLA, true, WoverEndConfig.MINECRAFT_18.innerVoidRadiusSquared, WoverEndConfig.MINECRAFT_18.centerBiomesSize, WoverEndConfig.MINECRAFT_18.voidBiomesSize, WoverEndConfig.MINECRAFT_18.landBiomesSize, WoverEndConfig.MINECRAFT_18.barrensBiomesSize);
    public static final WoverEndConfig DEFAULT = MINECRAFT_20;
    public static final Codec<WoverEndConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EndBiomeMapType.CODEC.fieldOf("map_type").orElse((Object)WoverEndConfig.DEFAULT.mapVersion).forGetter(o -> o.mapVersion), (App)EndBiomeGeneratorType.CODEC.fieldOf("generator_version").orElse((Object)WoverEndConfig.DEFAULT.generatorVersion).forGetter(o -> o.generatorVersion), (App)Codec.BOOL.fieldOf("with_void_biomes").orElse((Object)WoverEndConfig.DEFAULT.withVoidBiomes).forGetter(o -> o.withVoidBiomes), (App)Codec.INT.fieldOf("inner_void_radius_squared").orElse((Object)WoverEndConfig.DEFAULT.innerVoidRadiusSquared).forGetter(o -> o.innerVoidRadiusSquared), (App)Codec.INT.fieldOf("center_biomes_size").orElse((Object)WoverEndConfig.DEFAULT.centerBiomesSize).forGetter(o -> o.centerBiomesSize), (App)Codec.INT.fieldOf("void_biomes_size").orElse((Object)WoverEndConfig.DEFAULT.voidBiomesSize).forGetter(o -> o.voidBiomesSize), (App)Codec.INT.fieldOf("land_biomes_size").orElse((Object)WoverEndConfig.DEFAULT.landBiomesSize).forGetter(o -> o.landBiomesSize), (App)Codec.INT.fieldOf("barrens_biomes_size").orElse((Object)WoverEndConfig.DEFAULT.barrensBiomesSize).forGetter(o -> o.barrensBiomesSize)).apply((Applicative)instance, WoverEndConfig::new));
    @NotNull
    public final EndBiomeMapType mapVersion;
    @NotNull
    public final EndBiomeGeneratorType generatorVersion;
    public final boolean withVoidBiomes;
    public final int innerVoidRadiusSquared;
    public final int voidBiomesSize;
    public final int centerBiomesSize;
    public final int landBiomesSize;
    public final int barrensBiomesSize;

    public WoverEndConfig(@NotNull EndBiomeMapType mapVersion, @NotNull EndBiomeGeneratorType generatorVersion, boolean withVoidBiomes, int innerVoidRadiusSquared, int centerBiomesSize, int voidBiomesSize, int landBiomesSize, int barrensBiomesSize) {
        this.mapVersion = mapVersion;
        this.generatorVersion = generatorVersion;
        this.withVoidBiomes = withVoidBiomes;
        this.innerVoidRadiusSquared = innerVoidRadiusSquared;
        this.barrensBiomesSize = class_3532.method_15340((int)barrensBiomesSize, (int)1, (int)8192);
        this.voidBiomesSize = class_3532.method_15340((int)voidBiomesSize, (int)1, (int)8192);
        this.centerBiomesSize = class_3532.method_15340((int)centerBiomesSize, (int)1, (int)8192);
        this.landBiomesSize = class_3532.method_15340((int)landBiomesSize, (int)1, (int)8192);
    }

    public String toString() {
        return "EndConfig{mapVersion=" + String.valueOf((Object)this.mapVersion) + ", generatorVersion=" + String.valueOf((Object)this.generatorVersion) + ", withVoidBiomes=" + this.withVoidBiomes + ", innerVoidRadius=" + (int)Math.sqrt(this.innerVoidRadiusSquared) + ", voidBiomesSize=" + this.voidBiomesSize / 16 + ", centerBiomesSize=" + this.centerBiomesSize / 16 + ", landBiomesSize=" + this.landBiomesSize / 16 + ", barrensBiomesSize=" + this.barrensBiomesSize / 16 + "}";
    }

    public boolean couldSetWithoutRepair(BiomeSourceConfig<?> input) {
        if (input instanceof WoverEndConfig) {
            WoverEndConfig cfg = (WoverEndConfig)input;
            return this.withVoidBiomes == cfg.withVoidBiomes && this.mapVersion == cfg.mapVersion && this.generatorVersion == cfg.generatorVersion;
        }
        return false;
    }

    public boolean sameConfig(BiomeSourceConfig<?> input) {
        return this.equals(input);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WoverEndConfig that = (WoverEndConfig)o;
        return this.withVoidBiomes == that.withVoidBiomes && this.innerVoidRadiusSquared == that.innerVoidRadiusSquared && this.voidBiomesSize == that.voidBiomesSize && this.centerBiomesSize == that.centerBiomesSize && this.landBiomesSize == that.landBiomesSize && this.barrensBiomesSize == that.barrensBiomesSize && this.mapVersion == that.mapVersion && this.generatorVersion == that.generatorVersion;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mapVersion, this.generatorVersion, this.withVoidBiomes, this.innerVoidRadiusSquared, this.voidBiomesSize, this.centerBiomesSize, this.landBiomesSize, this.barrensBiomesSize});
    }

    public static enum EndBiomeMapType implements class_3542
    {
        VANILLA("vanilla", (seed, biomeSize, picker) -> new HexBiomeMap(seed, biomeSize, picker)),
        SQUARE("square", (seed, biomeSize, picker) -> new SquareBiomeMap(seed, biomeSize, picker)),
        HEX("hex", (seed, biomeSize, picker) -> new HexBiomeMap(seed, biomeSize, picker));

        public static final Codec<EndBiomeMapType> CODEC;
        public final String name;
        @NotNull
        public final MapBuilderFunction mapBuilder;

        private EndBiomeMapType(String name, MapBuilderFunction mapBuilder) {
            this.name = name;
            this.mapBuilder = mapBuilder;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(EndBiomeMapType::values);
        }
    }

    public static enum EndBiomeGeneratorType implements class_3542
    {
        VANILLA("vanilla"),
        PAULEVS("paulevs");

        public static final Codec<EndBiomeGeneratorType> CODEC;
        public final String name;

        private EndBiomeGeneratorType(String name) {
            this.name = name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(EndBiomeGeneratorType::values);
        }
    }
}

