/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.api.biomesource.end;

import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7871;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.generator.api.biomesource.WoverBiomePicker;
import org.betterx.wover.generator.api.biomesource.WoverBiomeSource;
import org.betterx.wover.generator.api.map.BiomeMap;
import org.betterx.wover.generator.impl.biomesource.end.BiomeDeciderImpl;

public abstract class BiomeDecider {
    protected WoverBiomePicker picker;
    protected BiomeMap map;
    private final BiomePredicate predicate;

    public static void registerHighPriorityDecider(class_2960 location, BiomeDecider decider) {
        BiomeDeciderImpl.registerHighPriorityDecider(location, decider);
    }

    public static void registerDecider(class_2960 location, BiomeDecider decider) {
        BiomeDeciderImpl.registerDecider(location, decider);
    }

    protected BiomeDecider(BiomePredicate predicate) {
        this(null, null, predicate);
    }

    protected BiomeDecider(class_7871<class_1959> biomeRegistry, class_5321<class_1959> fallbackBiome, BiomePredicate predicate) {
        this.predicate = predicate;
        this.map = null;
        this.picker = biomeRegistry == null ? null : new WoverBiomePicker(biomeRegistry, fallbackBiome);
    }

    public abstract boolean canProvideFor(class_1966 var1);

    public abstract BiomeDecider createInstance(WoverBiomeSource var1);

    public void createMap(BiomeMapBuilderFunction mapBuilder) {
        this.map = mapBuilder.create(this.picker, -1);
    }

    public void clearMapCache() {
        this.map.clearCache();
    }

    public boolean addToPicker(BiomeData biome) {
        if (this.predicate.test(biome)) {
            this.picker.addBiome(biome);
            return true;
        }
        return false;
    }

    public void rebuild() {
        if (this.picker != null) {
            this.picker.rebuild();
        }
    }

    public class_6862<class_1959> suggestType(class_6862<class_1959> originalType, class_6862<class_1959> suggestedType, int maxHeight, int blockX, int blockY, int blockZ, int quarterX, int quarterY, int quarterZ) {
        return this.suggestType(originalType, suggestedType, 0.0, maxHeight, blockX, blockY, blockZ, quarterX, quarterY, quarterZ);
    }

    public abstract class_6862<class_1959> suggestType(class_6862<class_1959> var1, class_6862<class_1959> var2, double var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public abstract boolean canProvideBiome(class_6862<class_1959> var1);

    public WoverBiomePicker.PickableBiome provideBiome(class_6862<class_1959> suggestedType, int posX, int posY, int posZ) {
        return this.map.getBiome(posX, posY, posZ);
    }

    @FunctionalInterface
    public static interface BiomePredicate {
        public boolean test(BiomeData var1);
    }

    @FunctionalInterface
    public static interface BiomeMapBuilderFunction {
        public BiomeMap create(WoverBiomePicker var1, int var2);
    }
}

