/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.api.biomesource;

import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.impl.modification.BiomeTagModificationWorker;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceWithNoiseRelatedSettings;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceWithSeed;
import org.betterx.wover.common.generator.api.biomesource.MergeableBiomeSource;
import org.betterx.wover.common.generator.api.biomesource.ReloadableBiomeSource;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.api.biomesource.WoverBiomePicker;
import org.betterx.wover.generator.impl.biomesource.WoverBiomeSourceImpl;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;

public abstract class WoverBiomeSource
extends class_1966
implements ReloadableBiomeSource,
BiomeSourceWithNoiseRelatedSettings,
BiomeSourceWithSeed,
MergeableBiomeSource<WoverBiomeSource> {
    private boolean didCreatePickers = false;
    Set<class_6880<class_1959>> dynamicPossibleBiomes = Set.of();
    protected long currentSeed;
    protected int maxHeight;

    public WoverBiomeSource(long seed) {
        this.currentSeed = seed;
    }

    @NotNull
    protected Stream<class_6880<class_1959>> method_49494() {
        this.reloadBiomes();
        return this.dynamicPossibleBiomes.stream();
    }

    public final void setSeed(long seed) {
        if (seed != this.currentSeed) {
            LibWoverWorldGenerator.C.log.debug(this.toShortString() + "\n    --> new seed = " + seed);
            this.currentSeed = seed;
            this.initMap(seed);
        }
    }

    public final void setMaxHeight(int maxHeight) {
        if (this.maxHeight != maxHeight) {
            LibWoverWorldGenerator.C.log.debug(this.toShortString() + "\n    --> new height = " + maxHeight);
            this.maxHeight = maxHeight;
            this.onHeightChange(maxHeight);
        }
    }

    protected boolean wasBound() {
        return this.didCreatePickers;
    }

    protected abstract List<class_6862<class_1959>> acceptedTags();

    protected abstract class_5321<class_1959> fallbackBiome();

    public abstract String toShortString();

    protected abstract void onInitMap(long var1);

    protected abstract void onHeightChange(int var1);

    protected class_6862<class_1959> defaultBiomeTag() {
        return this.acceptedTags().get(0);
    }

    protected List<TagToPicker> createFreshPickerMap() {
        return this.acceptedTags().stream().map(tag -> new TagToPicker((class_6862<class_1959>)tag, new WoverBiomePicker(this.fallbackBiome()))).toList();
    }

    public void onLoadGeneratorSettings(class_5284 generator) {
        this.setMaxHeight(generator.comp_474().comp_174());
    }

    protected void onFinishBiomeRebuild(List<TagToPicker> pickerMap) {
        for (TagToPicker tagToPicker : pickerMap) {
            tagToPicker.picker.rebuild();
        }
    }

    @NotNull
    protected String getNamespaces() {
        return WoverBiomeSourceImpl.getNamespaces(this.method_28443());
    }

    protected class_6862<class_1959> tagForUnknownBiome(class_6880<class_1959> biomeHolder, class_5321<class_1959> biomeKey) {
        for (class_6862<class_1959> type : this.acceptedTags()) {
            if (!biomeHolder.method_40220(type)) continue;
            return type;
        }
        return this.defaultBiomeTag();
    }

    protected boolean addToPicker(BiomeData biomeData, class_6862<class_1959> type, WoverBiomePicker picker) {
        picker.addBiome(biomeData);
        return true;
    }

    protected final void rebuildBiomes(boolean force) {
        if (!force && this.didCreatePickers) {
            return;
        }
        LibWoverWorldGenerator.C.log.verbose("Updating Pickers for " + this.toShortString());
        List<TagToPicker> pickers = this.createFreshPickerMap();
        this.dynamicPossibleBiomes = WoverBiomeSourceImpl.populateBiomePickers(pickers, this::addToPicker);
        if (this.dynamicPossibleBiomes == null) {
            this.dynamicPossibleBiomes = Set.of();
        }
        this.didCreatePickers = true;
        this.onFinishBiomeRebuild(pickers);
    }

    protected void reloadBiomes(boolean force) {
        this.rebuildBiomes(force);
        this.initMap(this.currentSeed);
    }

    public void reloadBiomes() {
        this.reloadBiomes(true);
    }

    protected final void initMap(long seed) {
        LibWoverWorldGenerator.C.log.debug(this.toShortString() + "\n    --> Map Update");
        this.onInitMap(seed);
    }

    public WoverBiomeSource mergeWithBiomeSource(class_1966 inputBiomeSource) {
        Stopwatch sw = Stopwatch.createStarted();
        class_5455 access = WorldState.registryAccess();
        if (access == null) {
            access = WorldState.allStageRegistryAccess();
            if (access != null) {
                LibWoverWorldGenerator.C.log.verbose("Registries were not finalized before merging biome sources!");
            } else {
                LibWoverWorldGenerator.C.log.error("Unable to merge Biome Sources");
                return this;
            }
        }
        class_2378 biomes = access.method_30530(class_7924.field_41236);
        BiomeTagModificationWorker biomeTagWorker = new BiomeTagModificationWorker();
        int biomesAdded = 0;
        try {
            for (class_6880 biomeHolder : inputBiomeSource.method_28443()) {
                class_5321 key;
                class_6862<class_1959> tag;
                if (!biomeHolder.method_40230().isPresent() || (tag = this.tagForUnknownBiome((class_6880<class_1959>)biomeHolder, (class_5321<class_1959>)(key = (class_5321)biomeHolder.method_40230().orElseThrow()))) == null || biomeHolder.method_40220(tag)) continue;
                biomeTagWorker.addBiomeToTag(tag, biomes, key, biomeHolder);
                ++biomesAdded;
            }
            biomeTagWorker.finished();
        }
        catch (RuntimeException e) {
            LibWoverWorldGenerator.C.log.error("Error while rebuilding BiomeSources!", (Exception)e);
        }
        catch (Exception e) {
            LibWoverWorldGenerator.C.log.error("Error while rebuilding BiomeSources!", e);
        }
        this.reloadBiomes();
        if (biomesAdded > 0) {
            LibWoverWorldGenerator.C.log.info("Merged {} biomes to {} in {}", new Object[]{biomesAdded, this.toShortString(), sw});
        }
        return this;
    }

    public record TagToPicker(class_6862<class_1959> tag, WoverBiomePicker picker) {
    }

    @FunctionalInterface
    public static interface PickerAdder {
        public boolean add(BiomeData var1, class_6862<class_1959> var2, WoverBiomePicker var3);
    }

    @FunctionalInterface
    public static interface PickerMapFactory {
        public List<TagToPicker> create(class_2378<BiomeData> var1);
    }
}

