/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.api.biomesource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2919;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.api.biomesource.WoverBiomeData;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.util.RandomizedWeightedList;
import org.jetbrains.annotations.Nullable;

public class WoverBiomePicker {
    private final Map<BiomeData, PickableBiome> registeredBiomes = new HashMap<BiomeData, PickableBiome>();
    public final class_7871<class_1959> biomeRegistry;
    private final Set<PickableBiome> biomes = new HashSet<PickableBiome>();
    public final PickableBiome fallbackBiome;
    private RandomizedWeightedList.SearchTree tree;

    public WoverBiomePicker(class_5321<class_1959> fallbackBiome) {
        this(WorldState.allStageRegistryAccess() == null ? null : (class_2378)WorldState.allStageRegistryAccess().method_33310(class_7924.field_41236).orElse(null), fallbackBiome);
    }

    public WoverBiomePicker(class_2378<class_1959> biomeRegistry, class_5321<class_1959> fallbackBiome) {
        this((class_7871<class_1959>)(biomeRegistry != null ? biomeRegistry.method_46771() : null), fallbackBiome);
    }

    public WoverBiomePicker(class_7871<class_1959> biomeRegistry, class_5321<class_1959> fallbackBiome) {
        this.biomeRegistry = biomeRegistry;
        this.fallbackBiome = this.create(BiomeData.tempOf(fallbackBiome));
    }

    public static void consumeSubBiomesForSource(BiomeData sourceBiome, BiConsumer<BiomeData, Float> consumeChild) {
        class_2378<BiomeData> reg = WoverBiomeData.getDataRegistry("biome alternatives", (class_5321<class_1959>)sourceBiome.biomeKey);
        for (Map.Entry entry : reg.method_29722()) {
            Object v = entry.getValue();
            if (!(v instanceof WoverBiomeData)) continue;
            WoverBiomeData b = (WoverBiomeData)((Object)v);
            if (!sourceBiome.isSame(b.parent)) continue;
            consumeChild.accept(b, Float.valueOf(b.genChance));
        }
    }

    private boolean isAllowed(BiomeData biomeData) {
        return biomeData != null;
    }

    private BiomeData nullIfNotAllowed(BiomeData biomeData) {
        return this.isAllowed(biomeData) ? biomeData : null;
    }

    private PickableBiome create(BiomeData biomeData) {
        if (biomeData == null) {
            return null;
        }
        PickableBiome e = this.registeredBiomes.get(biomeData);
        if (e != null && e.biomeData.isTemp() && !biomeData.isTemp()) {
            this.registeredBiomes.remove(e);
            e = null;
        }
        if (e != null) {
            return e;
        }
        return new PickableBiome(this, biomeData);
    }

    public void addBiome(BiomeData biome) {
        if (this.isAllowed(biome)) {
            this.biomes.add(this.create(biome));
        }
    }

    public PickableBiome getBiome(class_2919 random) {
        return (PickableBiome)this.tree.getRandomValue((class_5819)random);
    }

    public boolean isEmpty() {
        return this.biomes.isEmpty();
    }

    public void rebuild() {
        RandomizedWeightedList list = new RandomizedWeightedList();
        this.biomes.forEach(biome -> {
            if (biome.isValid) {
                list.add(biome, (double)biome.biomeData.genChance());
            }
        });
        if (list.isEmpty()) {
            list.add((Object)this.fallbackBiome, 1.0);
        }
        if (WorldState.allStageRegistryAccess() != null) {
            int beforeSize = this.registeredBiomes.size();
            ArrayList<PickableBiome> beforeList = new ArrayList<PickableBiome>(this.registeredBiomes.values());
            for (PickableBiome builtBiome : beforeList) {
                WoverBiomePicker.consumeSubBiomesForSource(builtBiome.biomeData, (biomeData, weight) -> builtBiome.subbiomes.add((Object)this.create((BiomeData)biomeData), (double)weight.floatValue()));
            }
            if (this.registeredBiomes.size() != beforeSize) {
                LibWoverWorldGenerator.C.log.verbose("Added " + (this.registeredBiomes.size() - beforeSize) + " Biomes");
                for (PickableBiome builtBiome : new ArrayList<PickableBiome>(this.registeredBiomes.values())) {
                    if (beforeList.contains(builtBiome)) continue;
                    LibWoverWorldGenerator.C.log.verbose(" - " + String.valueOf(builtBiome.biomeData.biomeKey.method_29177()) + ", subbiomes=" + builtBiome.subbiomes.size());
                }
            }
        }
        this.tree = list.buildSearchTree();
    }

    public String toString() {
        return "BiomePicker{biomes=" + this.biomes.size() + " (" + this.registeredBiomes.size() + "), biomeRegistry=" + String.valueOf(this.biomeRegistry) + ", type=" + super.toString() + "}";
    }

    @Nullable
    public static class_6880<class_1959> getBiomeAt(class_5281 world, class_2338 testPos) {
        class_1923 chunkPos = new class_1923(testPos);
        class_2791 chunk = world.method_8398().method_12121(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12794, false);
        if (chunk != null) {
            return chunk.getBiomeFabric(testPos);
        }
        return null;
    }

    public class PickableBiome {
        public final BiomeData biomeData;
        public final class_6880<class_1959> biome;
        private final RandomizedWeightedList<PickableBiome> subbiomes;
        public final PickableBiome edge;
        public final PickableBiome parent;
        public final boolean isValid;
        public final int edgeSize;
        public final boolean isVertical;

        private PickableBiome(WoverBiomePicker this$0, BiomeData biomeData) {
            this$0.registeredBiomes.put(biomeData, this);
            this.biomeData = biomeData;
            this.biome = this$0.biomeRegistry != null ? this$0.biomeRegistry.method_46747(biomeData.biomeKey) : null;
            this.isValid = this.biome != null && this.biome.method_40227();
            this.subbiomes = new RandomizedWeightedList();
            if (biomeData instanceof WoverBiomeData) {
                WoverBiomeData wData = (WoverBiomeData)biomeData;
                this.subbiomes.add((Object)this, (double)wData.genChance);
                this.edge = this$0.create(this$0.nullIfNotAllowed(wData.getEdgeData()));
                this.parent = this$0.create(wData.getParentData());
                this.edgeSize = wData.edgeSize;
                this.isVertical = wData.vertical;
            } else {
                this.subbiomes.add((Object)this, 1.0);
                this.edge = null;
                this.parent = null;
                this.edgeSize = 0;
                this.isVertical = false;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PickableBiome entry = (PickableBiome)o;
            return this.biomeData.equals((Object)entry.biomeData);
        }

        public int hashCode() {
            return Objects.hash(this.biomeData);
        }

        public PickableBiome getSubBiome(class_2919 random) {
            return (PickableBiome)this.subbiomes.getRandomValue((class_5819)random);
        }

        public PickableBiome getEdge() {
            return this.edge;
        }

        public PickableBiome getParentBiome() {
            return this.parent;
        }

        public boolean isSame(PickableBiome e) {
            return this.biomeData.isSame(e.biomeData);
        }

        public String toString() {
            return "PickableBiome{key=" + String.valueOf(this.biomeData.biomeKey.method_29177()) + ", alternatives=" + this.subbiomes.size() + ", edge=" + String.valueOf(this.edge != null ? this.edge.biomeData.biomeKey.method_29177() : "null") + ", parent=" + String.valueOf(this.parent != null ? this.parent.biomeData.biomeKey.method_29177() : "null") + ", isValid=" + this.isValid + "}";
        }
    }
}

