/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.api.biomesource;

import com.mojang.datafixers.util.Function10;
import com.mojang.datafixers.util.Function11;
import com.mojang.datafixers.util.Function12;
import com.mojang.datafixers.util.Function13;
import com.mojang.datafixers.util.Function14;
import com.mojang.datafixers.util.Function15;
import com.mojang.datafixers.util.Function16;
import com.mojang.datafixers.util.Function9;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7243;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeDataRegistry;
import org.betterx.wover.biome.api.data.BiomeGenerationDataContainer;
import org.betterx.wover.entrypoint.LibWoverBiome;
import org.betterx.wover.generator.impl.biomesource.WoverBiomeDataImpl;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoverBiomeData
extends BiomeData {
    public static final MapCodec<WoverBiomeData> CODEC = WoverBiomeData.codec(WoverBiomeData::new);
    public static final class_7243<WoverBiomeData> KEY_CODEC = class_7243.method_42116(CODEC);
    public final float terrainHeight;
    public final float genChance;
    public final int edgeSize;
    public final boolean vertical;
    @Nullable
    public final class_5321<class_1959> edge;
    @Nullable
    public final class_5321<BiomeData> edgeData;
    @Nullable
    public final class_5321<class_1959> parent;
    @Nullable
    public final class_5321<BiomeData> parentData;
    @Nullable
    private Optional<WoverBiomeData> edgeParent = null;

    public WoverBiomeData(float fogDensity, @NotNull class_5321<class_1959> biome, @NotNull BiomeGenerationDataContainer generationData, float terrainHeight, float genChance, int edgeSize, boolean vertical, @Nullable class_5321<class_1959> edge, @Nullable class_5321<class_1959> parent) {
        super(fogDensity, biome, generationData);
        this.terrainHeight = terrainHeight;
        this.genChance = genChance;
        this.edgeSize = edgeSize;
        this.vertical = vertical;
        this.edge = edge;
        this.parent = parent;
        this.edgeData = edge == null ? null : BiomeDataRegistry.createKey((class_2960)edge.method_29177());
        this.parentData = parent == null ? null : BiomeDataRegistry.createKey((class_2960)parent.method_29177());
    }

    public static WoverBiomeData of(class_5321<class_1959> biome) {
        return new WoverBiomeData(1.0f, biome, BiomeGenerationDataContainer.EMPTY, 0.1f, 1.0f, 0, false, null, null);
    }

    public static WoverBiomeData withEdge(class_5321<class_1959> biome, class_5321<class_1959> edge) {
        return new WoverBiomeData(1.0f, biome, BiomeGenerationDataContainer.EMPTY, 0.1f, 1.0f, 4, false, edge, null);
    }

    public static WoverBiomeData tempWithEdge(class_5321<class_1959> biome, class_5321<class_1959> edge) {
        return new InMemoryWoverBiomeData(1.0f, biome, BiomeGenerationDataContainer.EMPTY, 0.1f, 1.0f, 4, false, edge, null);
    }

    public static <T extends WoverBiomeData> MapCodec<T> codec(Function9<Float, class_5321<class_1959>, BiomeGenerationDataContainer, Float, Float, Integer, Boolean, class_5321<class_1959>, class_5321<class_1959>, T> factory) {
        WoverBiomeDataImpl.CodecAttributes a = new WoverBiomeDataImpl.CodecAttributes();
        return WoverBiomeData.codec(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, (w0, w1, w2, w3, w4, w5, w6, w7, w8) -> (WoverBiomeData)((Object)((Object)factory.apply(w0, w1, w2, w3, w4, w5, w6, (Object)w7.orElse(null), (Object)w8.orElse(null)))));
    }

    public static <T extends WoverBiomeData, P10> MapCodec<T> codec(RecordCodecBuilder<T, P10> p10, Function10<Float, class_5321<class_1959>, BiomeGenerationDataContainer, Float, Float, Integer, Boolean, class_5321<class_1959>, class_5321<class_1959>, P10, T> factory) {
        WoverBiomeDataImpl.CodecAttributes a = new WoverBiomeDataImpl.CodecAttributes();
        return WoverBiomeData.codec(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, p10, (w0, w1, w2, w3, w4, w5, w6, w7, w8, w9) -> (WoverBiomeData)((Object)((Object)factory.apply(w0, w1, w2, w3, w4, w5, w6, (Object)w7.orElse(null), (Object)w8.orElse(null), w9))));
    }

    public static <T extends WoverBiomeData, P10, P11> MapCodec<T> codec(RecordCodecBuilder<T, P10> p10, RecordCodecBuilder<T, P11> p11, Function11<Float, class_5321<class_1959>, BiomeGenerationDataContainer, Float, Float, Integer, Boolean, class_5321<class_1959>, class_5321<class_1959>, P10, P11, T> factory) {
        WoverBiomeDataImpl.CodecAttributes a = new WoverBiomeDataImpl.CodecAttributes();
        return WoverBiomeData.codec(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, p10, p11, (w0, w1, w2, w3, w4, w5, w6, w7, w8, w9, w10) -> (WoverBiomeData)((Object)((Object)factory.apply(w0, w1, w2, w3, w4, w5, w6, (Object)w7.orElse(null), (Object)w8.orElse(null), w9, w10))));
    }

    public static <T extends WoverBiomeData, P10, P11, P12> MapCodec<T> codec(RecordCodecBuilder<T, P10> p10, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12, Function12<Float, class_5321<class_1959>, BiomeGenerationDataContainer, Float, Float, Integer, Boolean, class_5321<class_1959>, class_5321<class_1959>, P10, P11, P12, T> factory) {
        WoverBiomeDataImpl.CodecAttributes a = new WoverBiomeDataImpl.CodecAttributes();
        return WoverBiomeData.codec(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, p10, p11, p12, (w0, w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w11) -> (WoverBiomeData)((Object)((Object)factory.apply(w0, w1, w2, w3, w4, w5, w6, (Object)w7.orElse(null), (Object)w8.orElse(null), w9, w10, w11))));
    }

    public static <T extends WoverBiomeData, P10, P11, P12, P13> MapCodec<T> codec(RecordCodecBuilder<T, P10> p10, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13, Function13<Float, class_5321<class_1959>, BiomeGenerationDataContainer, Float, Float, Integer, Boolean, class_5321<class_1959>, class_5321<class_1959>, P10, P11, P12, P13, T> factory) {
        WoverBiomeDataImpl.CodecAttributes a = new WoverBiomeDataImpl.CodecAttributes();
        return WoverBiomeData.codec(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, p10, p11, p12, p13, (w0, w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w11, w12) -> (WoverBiomeData)((Object)((Object)factory.apply(w0, w1, w2, w3, w4, w5, w6, (Object)w7.orElse(null), (Object)w8.orElse(null), w9, w10, w11, w12))));
    }

    public static <T extends WoverBiomeData, P10, P11, P12, P13, P14> MapCodec<T> codec(RecordCodecBuilder<T, P10> p10, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13, RecordCodecBuilder<T, P14> p14, Function14<Float, class_5321<class_1959>, BiomeGenerationDataContainer, Float, Float, Integer, Boolean, class_5321<class_1959>, class_5321<class_1959>, P10, P11, P12, P13, P14, T> factory) {
        WoverBiomeDataImpl.CodecAttributes a = new WoverBiomeDataImpl.CodecAttributes();
        return WoverBiomeData.codec(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, p10, p11, p12, p13, p14, (w0, w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w11, w12, w13) -> (WoverBiomeData)((Object)((Object)factory.apply(w0, w1, w2, w3, w4, w5, w6, (Object)w7.orElse(null), (Object)w8.orElse(null), w9, w10, w11, w12, w13))));
    }

    public static <T extends WoverBiomeData, P10, P11, P12, P13, P14, P15> MapCodec<T> codec(RecordCodecBuilder<T, P10> p10, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13, RecordCodecBuilder<T, P14> p14, RecordCodecBuilder<T, P15> p15, Function15<Float, class_5321<class_1959>, BiomeGenerationDataContainer, Float, Float, Integer, Boolean, class_5321<class_1959>, class_5321<class_1959>, P10, P11, P12, P13, P14, P15, T> factory) {
        WoverBiomeDataImpl.CodecAttributes a = new WoverBiomeDataImpl.CodecAttributes();
        return WoverBiomeData.codec(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, p10, p11, p12, p13, p14, p15, (w0, w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w11, w12, w13, w14) -> (WoverBiomeData)((Object)((Object)factory.apply(w0, w1, w2, w3, w4, w5, w6, (Object)w7.orElse(null), (Object)w8.orElse(null), w9, w10, w11, w12, w13, w14))));
    }

    public static <T extends WoverBiomeData, P10, P11, P12, P13, P14, P15, P16> MapCodec<T> codec(RecordCodecBuilder<T, P10> p10, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13, RecordCodecBuilder<T, P14> p14, RecordCodecBuilder<T, P15> p15, RecordCodecBuilder<T, P16> p16, Function16<Float, class_5321<class_1959>, BiomeGenerationDataContainer, Float, Float, Integer, Boolean, class_5321<class_1959>, class_5321<class_1959>, P10, P11, P12, P13, P14, P15, P16, T> factory) {
        WoverBiomeDataImpl.CodecAttributes a = new WoverBiomeDataImpl.CodecAttributes();
        return WoverBiomeData.codec(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, p10, p11, p12, p13, p14, p15, p16, (w0, w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w11, w12, w13, w14, w15) -> (WoverBiomeData)((Object)((Object)factory.apply(w0, w1, w2, w3, w4, w5, w6, (Object)w7.orElse(null), (Object)w8.orElse(null), w9, w10, w11, w12, w13, w14, w15))));
    }

    @NotNull
    public static class_2378<BiomeData> getDataRegistry(String forWhat, class_5321<class_1959> ofBiome) throws IllegalStateException {
        class_2378 reg;
        class_5455 acc = WorldState.registryAccess();
        if (acc == null) {
            if (WorldState.allStageRegistryAccess() == null) {
                throw new IllegalStateException("Accessing " + forWhat + " of " + String.valueOf(ofBiome) + " before any registry is ready!");
            }
            if (preFinalAccessWarning++ < 5) {
                LibWoverBiome.C.log.verboseWarning("Accessing " + forWhat + " of " + String.valueOf(ofBiome) + " before registry is ready!");
            }
            acc = WorldState.allStageRegistryAccess();
        }
        class_2378 class_23782 = reg = acc != null ? (class_2378)acc.method_33310(BiomeDataRegistry.BIOME_DATA_REGISTRY).orElse(null) : null;
        if (reg == null) {
            throw new IllegalStateException("Accessing " + forWhat + " of " + String.valueOf(ofBiome) + " before biome data registry is ready!");
        }
        return reg;
    }

    public WoverBiomeData findEdgeParent() {
        if (this.edgeParent != null) {
            return this.edgeParent.orElse(null);
        }
        class_2378<BiomeData> reg = WoverBiomeData.getDataRegistry("edge parent", (class_5321<class_1959>)this.biomeKey);
        for (Map.Entry entry : reg.method_29722()) {
            Object v = entry.getValue();
            if (!(v instanceof WoverBiomeData)) continue;
            WoverBiomeData b = (WoverBiomeData)((Object)v);
            if (!this.isSame(b.edge)) continue;
            this.edgeParent = Optional.of(b);
            return b;
        }
        this.edgeParent = Optional.empty();
        return null;
    }

    public boolean isPickable() {
        return this.parent == null && this.findEdgeParent() == null;
    }

    public BiomeData getEdgeData() {
        if (this.edgeData == null) {
            return null;
        }
        class_2378<BiomeData> reg = WoverBiomeData.getDataRegistry("edge biome", (class_5321<class_1959>)this.biomeKey);
        return (BiomeData)reg.method_29107(this.edgeData);
    }

    public BiomeData getParentData() {
        if (this.edgeData == null) {
            return null;
        }
        class_2378<BiomeData> reg = WoverBiomeData.getDataRegistry("parent biome", (class_5321<class_1959>)this.biomeKey);
        return (BiomeData)reg.method_29107(this.parentData);
    }

    public class_7243<? extends WoverBiomeData> codec() {
        return KEY_CODEC;
    }

    public static class InMemoryWoverBiomeData
    extends WoverBiomeData {
        private InMemoryWoverBiomeData(float fogDensity, @NotNull class_5321<class_1959> biome, @NotNull BiomeGenerationDataContainer generationData, float terrainHeight, float genChance, int edgeSize, boolean vertical, @Nullable class_5321<class_1959> edge, @Nullable class_5321<class_1959> parent) {
            super(fogDensity, biome, generationData, terrainHeight, genChance, edgeSize, vertical, edge, parent);
        }

        public boolean isTemp() {
            return true;
        }
    }
}

