/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.impl.pools;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3499;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5188;
import net.minecraft.class_5321;
import net.minecraft.class_5468;
import net.minecraft.class_5469;
import net.minecraft.class_5497;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.class_9822;
import org.betterx.wover.structure.api.pools.StructurePoolBuilder;
import org.betterx.wover.structure.api.pools.StructurePoolKey;
import org.betterx.wover.structure.api.processors.StructureProcessorKey;
import org.betterx.wover.structure.impl.pools.SingleEndPoolElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructurePoolBuilderImpl
implements StructurePoolBuilder {
    @NotNull
    private final class_5321<class_3785> key;
    @NotNull
    private final class_7891<class_3785> context;
    @Nullable
    private class_6880<class_3785> terminator;
    @NotNull
    private class_3785.class_3786 projection;
    private List<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>> elements = new LinkedList<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>>();

    public StructurePoolBuilderImpl(@NotNull class_5321<class_3785> key, @NotNull class_7891<class_3785> context) {
        this.key = key;
        this.context = context;
        this.projection = class_3785.class_3786.field_16687;
    }

    @Override
    @NotNull
    public class_6880<class_3785> register() {
        return this.context.method_46838(this.key, (Object)this.build());
    }

    @Override
    @NotNull
    public class_6880<class_3785> directHolder() {
        return class_6880.method_40223((Object)this.build());
    }

    @Override
    @NotNull
    public StructurePoolBuilder projection(@NotNull class_3785.class_3786 projection) {
        this.projection = projection;
        return this;
    }

    @Override
    @NotNull
    public StructurePoolBuilder.ElementBuilder startSingle(@NotNull class_2960 nbtLocation) {
        return new SinglePoolElementImpl(nbtLocation);
    }

    @Override
    @NotNull
    public StructurePoolBuilder.ElementBuilder startSingleEnd(@NotNull class_2960 nbtLocation) {
        return new SingleEndPoolElementImpl(this, nbtLocation);
    }

    @Override
    @NotNull
    public StructurePoolBuilder.ElementBuilder startLegacySingle(@NotNull class_2960 nbtLocation) {
        return new LegacyPoolElementImpl(this, nbtLocation);
    }

    @Override
    @NotNull
    public StructurePoolBuilder addEmptyElement(int weight) {
        return this.add(class_3784.method_30438(), weight);
    }

    @Override
    @NotNull
    public StructurePoolBuilder add(@NotNull Function<class_3785.class_3786, ? extends class_3784> element, int weight) {
        return this.add((Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>)Pair.of(element, (Object)weight));
    }

    @Override
    @NotNull
    public StructurePoolBuilder addFeature(@NotNull class_5321<class_6796> feature, int weight) {
        return this.add((Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>)Pair.of((Object)class_3784.method_30421((class_6880)((class_6880)this.context.method_46799(class_7924.field_41245).method_46746(feature).orElseThrow())), (Object)weight));
    }

    @Override
    @NotNull
    public StructurePoolBuilder addFeature(@NotNull class_6880<class_6796> feature, int weight) {
        return this.add((Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>)Pair.of((Object)class_3784.method_30421(feature), (Object)weight));
    }

    @NotNull
    private StructurePoolBuilder add(@NotNull Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer> element) {
        this.elements.add(element);
        return this;
    }

    @Override
    @NotNull
    public StructurePoolBuilder terminator(@NotNull class_6880<class_3785> terminator) {
        this.terminator = terminator;
        return this;
    }

    @Override
    @NotNull
    public StructurePoolBuilder terminator(@NotNull class_5321<class_3785> terminator) {
        this.terminator = this.context.method_46799(class_7924.field_41249).method_46747(terminator);
        return this;
    }

    @Override
    @NotNull
    public StructurePoolBuilder terminator(@NotNull StructurePoolKey terminator) {
        return this.terminator(terminator.key);
    }

    @Override
    @NotNull
    public StructurePoolBuilder emptyTerminator() {
        return this.terminator((class_5321<class_3785>)class_5468.field_26254);
    }

    private class_3785 build() {
        if (this.terminator == null) {
            this.emptyTerminator();
        }
        return new class_3785(this.terminator, (List)ImmutableList.copyOf(this.elements), this.projection);
    }

    public class SinglePoolElementImpl
    implements StructurePoolBuilder.ElementBuilder {
        protected final class_2960 nbtLocation;
        protected class_6880<class_5497> processor;
        private int weight;
        protected class_9822 liquidSettings;

        SinglePoolElementImpl(class_2960 nbtLocation) {
            this.nbtLocation = nbtLocation;
            this.weight = 1;
            this.liquidSettings = null;
        }

        @Override
        @NotNull
        public StructurePoolBuilder.ElementBuilder processor(@NotNull class_6880<class_5497> processor) {
            this.processor = processor;
            return this;
        }

        @Override
        @NotNull
        public StructurePoolBuilder.ElementBuilder processor(@NotNull class_5321<class_5497> processor) {
            this.processor = StructurePoolBuilderImpl.this.context.method_46799(class_7924.field_41247).method_46747(processor);
            return this;
        }

        @Override
        @NotNull
        public StructurePoolBuilder.ElementBuilder processor(@NotNull StructureProcessorKey processor) {
            return this.processor(processor.key);
        }

        @Override
        @NotNull
        public StructurePoolBuilder.ElementBuilder emptyProcessor() {
            return this.processor((class_5321<class_5497>)class_5469.field_26688);
        }

        @Override
        @NotNull
        public StructurePoolBuilder.ElementBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }

        @Override
        @NotNull
        public StructurePoolBuilder.ElementBuilder liquidSettingsOverride(class_9822 value) {
            this.liquidSettings = value;
            return this;
        }

        @Override
        @NotNull
        public StructurePoolBuilder endElement() {
            if (this.nbtLocation == null) {
                throw new IllegalStateException("Location for a pool entry must be set before pushing it to the pool.");
            }
            if (this.processor == null) {
                this.emptyProcessor();
            }
            return StructurePoolBuilderImpl.this.add((Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>)Pair.of(this.create(), (Object)this.weight));
        }

        protected Function<class_3785.class_3786, ? extends class_3784> create() {
            return projection -> new class_3781(Either.left((Object)this.nbtLocation), this.processor, projection, this.liquidSettings == null ? Optional.empty() : Optional.of(this.liquidSettings));
        }
    }

    public class SingleEndPoolElementImpl
    extends SinglePoolElementImpl {
        SingleEndPoolElementImpl(StructurePoolBuilderImpl this$0, class_2960 nbtLocation) {
            super(nbtLocation);
        }

        @Override
        protected Function<class_3785.class_3786, ? extends class_3784> create() {
            return projection -> new SingleEndPoolElement((Either<class_2960, class_3499>)Either.left((Object)this.nbtLocation), (class_6880<class_5497>)this.processor, (class_3785.class_3786)projection);
        }
    }

    public class LegacyPoolElementImpl
    extends SinglePoolElementImpl {
        LegacyPoolElementImpl(StructurePoolBuilderImpl this$0, class_2960 nbtLocation) {
            super(nbtLocation);
        }

        @Override
        protected Function<class_3785.class_3786, ? extends class_3784> create() {
            return projection -> new class_5188(Either.left((Object)this.nbtLocation), this.processor, projection, this.liquidSettings == null ? Optional.empty() : Optional.of(this.liquidSettings));
        }
    }
}

