/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.api.structures.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_3499;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_7151;
import org.apache.commons.lang3.time.StopWatch;
import org.betterx.wover.entrypoint.LibWoverStructure;
import org.betterx.wover.structure.api.StructureNBT;
import org.betterx.wover.structure.api.structures.StructurePlacement;
import org.betterx.wover.structure.api.structures.nbt.RandomNbtStructureElement;
import org.betterx.wover.structure.api.structures.nbt.RandomNbtStructurePiece;
import org.betterx.wover.structure.impl.StructureManagerImpl;
import org.betterx.wover.util.RandomizedWeightedList;
import org.jetbrains.annotations.NotNull;

public class RandomNbtStructure
extends class_3195 {
    @NotNull
    private final RandomizedWeightedList<RandomNbtStructureElement> elements;
    private final StructurePlacement placement;
    private final boolean keepAir;

    public static <T extends RandomNbtStructure> MapCodec<T> simpleRandomCodec(Function4<class_3195.class_7302, StructurePlacement, Boolean, RandomizedWeightedList<RandomNbtStructureElement>, T> instancer) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_3195.method_42697((RecordCodecBuilder.Instance)instance), (App)StructurePlacement.CODEC.fieldOf("placement").forGetter(RandomNbtStructure::placement), (App)Codec.BOOL.optionalFieldOf("keep_air", (Object)false).forGetter(RandomNbtStructure::keepAir), (App)RandomizedWeightedList.buildCodec(RandomNbtStructureElement.CODEC).fieldOf("configs").forGetter(RandomNbtStructure::elements)).apply((Applicative)instance, instancer));
    }

    public RandomNbtStructure(class_3195.class_7302 structureSettings, StructurePlacement placement, boolean keepAir, @NotNull RandomizedWeightedList<RandomNbtStructureElement> elements) {
        super(structureSettings);
        this.elements = elements;
        this.keepAir = keepAir;
        this.placement = placement;
    }

    public RandomizedWeightedList<RandomNbtStructureElement> elements() {
        return this.elements;
    }

    public StructurePlacement placement() {
        return this.placement;
    }

    public boolean keepAir() {
        return this.keepAir;
    }

    @NotNull
    protected Optional<class_3195.class_7150> method_38676(class_3195.class_7149 ctx) {
        RandomNbtStructureElement element;
        class_2415 mirror;
        StopWatch sw = StopWatch.createStarted();
        class_2470 rotation = StructureNBT.getRandomRotation((class_5819)ctx.comp_566());
        Optional<class_3195.class_7150> result = this.placement.placementFunction.find(ctx, rotation, mirror = StructureNBT.getRandomMirror((class_5819)ctx.comp_566()), element = (RandomNbtStructureElement)this.elements.getRandomValue((class_5819)ctx.comp_566()), (pos, structurePiecesBuilder) -> {
            LibWoverStructure.C.log.debug("Generating RandomNbtStructure: " + String.valueOf(pos) + " (" + sw.getTime() + "ms)");
            this.generatePieces((class_6626)structurePiecesBuilder, ctx, (class_2338)pos, rotation, mirror, element);
        });
        if (result.isEmpty()) {
            LibWoverStructure.C.log.debug("Rejected RandomNbtStructure " + String.valueOf(element.nbtLocation()) + " in " + sw.getTime() + "ms");
        } else {
            LibWoverStructure.C.log.debug("Accepted RandomNbtStructure " + String.valueOf(element.nbtLocation()) + " in " + sw.getTime() + "ms");
        }
        return result;
    }

    private void generatePieces(class_6626 structurePiecesBuilder, class_3195.class_7149 ctx, class_2338 pos, class_2470 rotation, class_2415 mirror, RandomNbtStructureElement element) {
        class_3499 template = ctx.comp_565().method_15091(element.nbtLocation());
        class_2338 center = StructurePlacement.getCenter(mirror, template);
        structurePiecesBuilder.method_35462((class_3443)new RandomNbtStructurePiece(ctx.comp_565(), element.nbtLocation(), RandomNbtStructurePiece.settings(rotation, mirror, center, this.keepAir), pos.method_10086(element.yOffset()), this.keepAir));
    }

    @NotNull
    public class_7151<?> method_41618() {
        return StructureManagerImpl.RANDOM_NBT_STRUCTURE_TYPE;
    }
}

