/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.api.structures;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_4970;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import org.betterx.wover.structure.api.structures.NoiseColumnWithState;
import org.betterx.wover.structure.api.structures.nbt.RandomNbtStructureElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum StructurePlacement implements class_3542
{
    LAVA(StructurePlacement::findGenerationPointNetherLava),
    SURFACE(StructurePlacement::findGenerationPointSurface),
    LEGACY_FLOOR("floor", StructurePlacement::findGenerationPointNetherFloor),
    LEGACY_CEIL("ceil", StructurePlacement::findGenerationPointNetherFloor),
    NETHER_CEIL(StructurePlacement::findGenerationPointNetherCeil),
    NETHER_SURFACE(StructurePlacement::findGenerationPointNetherFloor),
    NETHER_SURFACE_FLAT_0((a, b, c, d, e) -> StructurePlacement.findGenerationPointNetherFloorFlat(a, b, c, d, e, 0)),
    NETHER_SURFACE_FLAT_2((a, b, c, d, e) -> StructurePlacement.findGenerationPointNetherFloorFlat(a, b, c, d, e, 2)),
    NETHER_SURFACE_FLAT_4((a, b, c, d, e) -> StructurePlacement.findGenerationPointNetherFloorFlat(a, b, c, d, e, 4));

    public static final Codec<StructurePlacement> CODEC;
    protected static final int FAIL_HEIGHT = Integer.MIN_VALUE;
    private final String name;
    public final PlacementFunction placementFunction;

    private StructurePlacement(String name, PlacementFunction placementFunction) {
        this.name = name;
        this.placementFunction = placementFunction;
    }

    private StructurePlacement(PlacementFunction placementFunction) {
        this(null, placementFunction);
    }

    @NotNull
    public String method_15434() {
        return this.name == null ? this.name().toLowerCase() : this.name.toLowerCase();
    }

    public static Optional<class_3195.class_7150> onNetherSurface(int x, int startY, int z, class_3195.class_7149 ctx, BiConsumer<class_2338, class_6626> consumer) {
        int y = StructurePlacement.findYDownward(startY, List.of(new class_2338(x, startY, z)), ctx, class_4970.class_4971::method_26215, state -> class_2902.class_2903.field_13194.method_16402().test(state) && !state.method_51176(), 1, 0);
        if (y == Integer.MIN_VALUE) {
            return Optional.empty();
        }
        class_2338 pos = new class_2338(x, y, z);
        return Optional.of(new class_3195.class_7150(pos, builder -> consumer.accept(pos, (class_6626)builder)));
    }

    public static Optional<class_3195.class_7150> onNetherCeiling(int x, int startY, int z, class_3195.class_7149 ctx, BiConsumer<class_2338, class_6626> consumer) {
        int y = StructurePlacement.findYDownward(startY, List.of(new class_2338(x, startY, z)), ctx, state -> class_2902.class_2903.field_13194.method_16402().test(state), class_4970.class_4971::method_26215, 1, 0);
        if (y == Integer.MIN_VALUE) {
            return Optional.empty();
        }
        class_2338 pos = new class_2338(x, y, z);
        return Optional.of(new class_3195.class_7150(pos, builder -> consumer.accept(pos, (class_6626)builder)));
    }

    public static Optional<class_3195.class_7150> onMinHeightNetherSurface(int x, int startY, int z, List<class_2338> positions, int maxDeltaY, int airAtOffset, class_3195.class_7149 ctx, BiConsumer<class_2338, class_6626> consumer) {
        int minFoundY = Integer.MAX_VALUE;
        int maxFoundY = Integer.MIN_VALUE;
        for (class_2338 testPos : positions) {
            int y = StructurePlacement.findYDownward(startY, List.of(testPos), ctx, class_4970.class_4971::method_26215, state -> class_2902.class_2903.field_13194.method_16402().test(state) && !state.method_51176(), 1, airAtOffset);
            if (y == Integer.MIN_VALUE) {
                return Optional.empty();
            }
            if (y < minFoundY) {
                minFoundY = y;
            }
            if (y <= maxFoundY) continue;
            maxFoundY = y;
        }
        if (maxFoundY - minFoundY > maxDeltaY) {
            return Optional.empty();
        }
        class_2338 pos = new class_2338(x, minFoundY, z);
        return Optional.of(new class_3195.class_7150(pos, builder -> consumer.accept(pos, (class_6626)builder)));
    }

    public static Optional<class_3195.class_7150> onChunkCenterWorldSurface(class_3195.class_7149 generationContext, class_2902.class_2903 types, BiConsumer<class_2338, class_6626> consumer) {
        class_1923 chunkPos = generationContext.comp_568();
        int x = chunkPos.method_33940();
        int z = chunkPos.method_33942();
        int y = generationContext.comp_562().method_18028(x, z, types, generationContext.comp_569(), generationContext.comp_564());
        class_2338 pos = new class_2338(x, y, z);
        return Optional.of(new class_3195.class_7150(pos, builder -> consumer.accept(pos, (class_6626)builder)));
    }

    @Nullable
    public static int findYDownward(int startY, List<class_2338> testColumns, class_3195.class_7149 ctx, Predicate<class_2680> testAir, Predicate<class_2680> testSurface, int minMatches, int airAtOffset) {
        return StructurePlacement.findYDownward(startY, ctx.comp_569().method_31607() + 4, testColumns, ctx, testAir, testSurface, minMatches, airAtOffset);
    }

    @Nullable
    public static int findYDownward(int startY, int stopY, List<class_2338> testColumns, class_3195.class_7149 ctx, Predicate<class_2680> testAir, Predicate<class_2680> testSurface, int minMatches, int airAtOffset) {
        List<NoiseColumnWithState> noiseColumns = testColumns.stream().map(p -> new NoiseColumnWithState(ctx.comp_562().method_26261(p.method_10263(), p.method_10260(), ctx.comp_569(), ctx.comp_564()), startY)).toList();
        int res = Integer.MIN_VALUE;
        block0: for (int y = startY - 1; y > stopY; --y) {
            int matchCount = 0;
            for (NoiseColumnWithState noiseColumn : noiseColumns) {
                class_2680 state = noiseColumn.getBlock(y);
                if (testAir.test(noiseColumn.lastState) && testSurface.test(state) && ++matchCount == minMatches) {
                    res = y;
                    break block0;
                }
                noiseColumn.lastState = state;
            }
        }
        if (airAtOffset != 0) {
            int matchCount = 0;
            for (NoiseColumnWithState noiseColumn : noiseColumns) {
                if (!testAir.test(noiseColumn.getBlock(res + airAtOffset)) || ++matchCount != minMatches) continue;
                return res;
            }
            return Integer.MIN_VALUE;
        }
        return res;
    }

    public static boolean hasValidBiomeAtRandomHeight(class_3195.class_7149 ctx, int x, int z) {
        int randomY = ctx.comp_566().method_39332(ctx.comp_569().method_31607(), ctx.comp_569().method_31600());
        return StructurePlacement.hasValidBiomeAt(ctx, x, randomY, z);
    }

    public static boolean hasValidBiomeAt(class_3195.class_7149 ctx, int x, int y, int z) {
        return ctx.comp_570().test(ctx.comp_562().method_12098().method_38109(class_5742.method_33100((int)x), class_5742.method_33100((int)y), class_5742.method_33100((int)z), ctx.comp_564().method_42371()));
    }

    @NotNull
    public static class_2338 getCenter(class_2415 mirror, class_3499 template) {
        int sx = mirror == class_2415.field_11301 ? -1 : 1;
        int sz = mirror == class_2415.field_11300 ? -1 : 1;
        return new class_2338(sx * template.method_15160().method_10263() / 2, 0, sz * template.method_15160().method_10260() / 2);
    }

    @NotNull
    private static Optional<class_3195.class_7150> findGenerationPointSurface(class_3195.class_7149 ctx, class_2470 rotation, class_2415 mirror, RandomNbtStructureElement element, BiConsumer<class_2338, class_6626> consumer) {
        return StructurePlacement.onChunkCenterWorldSurface(ctx, class_2902.class_2903.field_13194, consumer);
    }

    @NotNull
    private static Optional<class_3195.class_7150> findGenerationPointNetherCeil(class_3195.class_7149 ctx, class_2470 rotation, class_2415 mirror, RandomNbtStructureElement element, BiConsumer<class_2338, class_6626> consumer) {
        int z;
        class_1923 chunkPos = ctx.comp_568();
        int x = chunkPos.method_33940();
        if (!StructurePlacement.hasValidBiomeAtRandomHeight(ctx, x, z = chunkPos.method_33942())) {
            return Optional.empty();
        }
        class_2794 generator = ctx.comp_562();
        int maxHeight = generator.method_12104() - 20;
        int seaLevel = generator.method_16398();
        return StructurePlacement.onNetherCeiling(x, class_3532.method_32751((class_5819)ctx.comp_566(), (int)seaLevel, (int)maxHeight), z, ctx, consumer);
    }

    @NotNull
    private static Optional<class_3195.class_7150> findGenerationPointNetherFloor(class_3195.class_7149 ctx, class_2470 rotation, class_2415 mirror, RandomNbtStructureElement element, BiConsumer<class_2338, class_6626> consumer) {
        int z;
        class_1923 chunkPos = ctx.comp_568();
        int x = chunkPos.method_33940();
        if (!StructurePlacement.hasValidBiomeAtRandomHeight(ctx, x, z = chunkPos.method_33942())) {
            return Optional.empty();
        }
        class_2794 generator = ctx.comp_562();
        int maxHeight = generator.method_12104() - 20;
        int seaLevel = generator.method_16398();
        return StructurePlacement.onNetherSurface(x, class_3532.method_32751((class_5819)ctx.comp_566(), (int)seaLevel, (int)maxHeight), z, ctx, consumer);
    }

    @NotNull
    private static Optional<class_3195.class_7150> findGenerationPointNetherFloorFlat(class_3195.class_7149 ctx, class_2470 rotation, class_2415 mirror, RandomNbtStructureElement element, BiConsumer<class_2338, class_6626> consumer, int maxDeltaY) {
        int z;
        class_1923 chunkPos = ctx.comp_568();
        int x = chunkPos.method_33940();
        if (!StructurePlacement.hasValidBiomeAtRandomHeight(ctx, x, z = chunkPos.method_33942())) {
            return Optional.empty();
        }
        class_2794 generator = ctx.comp_562();
        int maxHeight = generator.method_12104() - 20;
        int seaLevel = generator.method_16398();
        class_2338 startPos = new class_2338(x, maxHeight, z);
        class_3499 template = ctx.comp_565().method_15091(element.nbtLocation());
        class_2338 center = StructurePlacement.getCenter(mirror, template);
        class_3341 boundingBox = template.method_27267(startPos, rotation, center, mirror);
        List<class_2338> list = List.of(new class_2338(boundingBox.method_35415(), 0, boundingBox.method_35417()), new class_2338(boundingBox.method_35418(), 0, boundingBox.method_35417()), new class_2338(boundingBox.method_35415(), 0, boundingBox.method_35420()), new class_2338(boundingBox.method_35418(), 0, boundingBox.method_35420()));
        return StructurePlacement.onMinHeightNetherSurface(x, class_3532.method_32751((class_5819)ctx.comp_566(), (int)seaLevel, (int)maxHeight), z, list, maxDeltaY, (int)((double)boundingBox.method_14660() * 0.8), ctx, consumer);
    }

    @NotNull
    private static Optional<class_3195.class_7150> findGenerationPointNetherLava(class_3195.class_7149 ctx, class_2470 rotation, class_2415 mirror, RandomNbtStructureElement element, BiConsumer<class_2338, class_6626> consumer) {
        class_2338 center;
        class_1923 chunkPos = ctx.comp_568();
        int x = chunkPos.method_33940();
        int z = chunkPos.method_33942();
        class_2794 generator = ctx.comp_562();
        int seaLevel = generator.method_16398();
        if (!StructurePlacement.hasValidBiomeAt(ctx, x, seaLevel, z)) {
            return Optional.empty();
        }
        class_2338 startPos = new class_2338(x, seaLevel, z);
        class_3499 template = ctx.comp_565().method_15091(element.nbtLocation());
        class_3341 boundingBox = template.method_27267(startPos, rotation, center = StructurePlacement.getCenter(mirror, template), mirror);
        List<class_2338> list = List.of(new class_2338(boundingBox.method_35415(), 0, boundingBox.method_35417()), new class_2338(boundingBox.method_35418(), 0, boundingBox.method_35417()), new class_2338(boundingBox.method_35415(), 0, boundingBox.method_35420()), new class_2338(boundingBox.method_35418(), 0, boundingBox.method_35420()));
        int y = StructurePlacement.findYDownward(seaLevel, seaLevel - 2, list, ctx, class_4970.class_4971::method_26215, state -> state.method_27852(class_2246.field_10164), list.size(), 0);
        if (y == Integer.MIN_VALUE) {
            return Optional.empty();
        }
        class_2338 pos = new class_2338(x, y, z);
        return Optional.of(new class_3195.class_7150(pos, builder -> consumer.accept(pos, (class_6626)builder)));
    }

    static {
        CODEC = class_3542.method_28140(StructurePlacement::values);
    }

    @FunctionalInterface
    public static interface PlacementFunction {
        public Optional<class_3195.class_7150> find(class_3195.class_7149 var1, class_2470 var2, class_2415 var3, RandomNbtStructureElement var4, BiConsumer<class_2338, class_6626> var5);
    }
}

