/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.api.sets;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2382;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6871;
import net.minecraft.class_6872;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6908;
import net.minecraft.class_7059;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import org.betterx.wover.structure.api.StructureKey;
import org.betterx.wover.structure.api.builders.BaseStructureBuilder;
import org.betterx.wover.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureSetBuilder {
    @NotNull
    private final class_5321<class_7059> key;
    @NotNull
    private final class_7891<class_7059> context;
    private final List<Pair<class_5321<class_3195>, Integer>> structures = new LinkedList<Pair<class_5321<class_3195>, Integer>>();
    private class_6874 placement;

    StructureSetBuilder(@NotNull class_5321<class_7059> key, @NotNull class_7891<class_7059> context) {
        this.key = key;
        this.context = context;
    }

    public StructureSetBuilder addStructure(class_5321<class_3195> structure, int weight) {
        this.structures.add((Pair<class_5321<class_3195>, Integer>)new Pair(structure, (Object)weight));
        return this;
    }

    public StructureSetBuilder addStructure(class_5321<class_3195> structure) {
        return this.addStructure((StructureKey)structure, 1);
    }

    public <S extends class_3195, T extends BaseStructureBuilder<S, T>, K extends StructureKey<S, T, K>> StructureSetBuilder addStructure(K structure, int weight) {
        return this.addStructure((K)structure.key(), weight);
    }

    public <S extends class_3195, T extends BaseStructureBuilder<S, T>, K extends StructureKey<S, T, K>> StructureSetBuilder addStructure(K structure) {
        return this.addStructure(structure, 1);
    }

    public StructureSetBuilder randomPlacement(int spacing, int seperation) {
        return this.randomPlacement().spacing(spacing).separation(seperation).finishPlacement();
    }

    public RandomSpreadStructurePlacementBuilder randomPlacement() {
        return new RandomSpreadStructurePlacementBuilder(this.key);
    }

    public ConcentricRingsStructurePlacementBuilder concentricPlacement() {
        return new ConcentricRingsStructurePlacementBuilder(this.context, this.key);
    }

    public StructureSetBuilder setPlacement(class_6874 p) {
        this.placement = p;
        return this;
    }

    public class_6880<class_7059> register() {
        return this.context.method_46838(this.key, (Object)this.build());
    }

    public class_6880<class_7059> directHolder() {
        return class_6880.method_40223((Object)this.build());
    }

    private class_7059 build() {
        if (this.structures.isEmpty()) {
            throw new IllegalStateException("StructureSet " + String.valueOf(this.key.method_29177()) + " must contain at least one structure");
        }
        if (this.placement == null) {
            throw new IllegalStateException("StructureSet " + String.valueOf(this.key.method_29177()) + " define a placement");
        }
        class_7871 structureRegistry = this.context.method_46799(class_7924.field_41246);
        if (this.structures.size() == 1) {
            class_6880.class_6883 holder = structureRegistry.method_46747((class_5321)this.structures.get((int)0).first);
            return new class_7059((class_6880)holder, this.placement);
        }
        return new class_7059(this.structures.stream().map(p -> class_7059.method_41146((class_6880)structureRegistry.method_46747((class_5321)p.first), (int)((Integer)p.second))).toList(), this.placement);
    }

    public class RandomSpreadStructurePlacementBuilder
    extends StructurePlacementBuilder<RandomSpreadStructurePlacementBuilder> {
        protected int spacing;
        protected int separation;
        protected class_6873 spreadType;

        RandomSpreadStructurePlacementBuilder(class_5321<class_7059> baseKey) {
            super(StructureSetBuilder.this, baseKey);
            this.spacing = 32;
            this.separation = 8;
            this.spreadType = class_6873.field_36421;
        }

        @NotNull
        public RandomSpreadStructurePlacementBuilder spacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        @NotNull
        public RandomSpreadStructurePlacementBuilder separation(int separation) {
            this.separation = separation;
            return this;
        }

        @NotNull
        public RandomSpreadStructurePlacementBuilder spreadType(@NotNull class_6873 spreadType) {
            this.spreadType = spreadType;
            return this;
        }

        @Override
        public StructureSetBuilder finishPlacement() {
            return StructureSetBuilder.this.setPlacement((class_6874)new class_6872(this.locateOffset, this.frequencyReductionMethod, this.frequency, this.salt, this.exclusionZone, this.spacing, this.separation, this.spreadType));
        }
    }

    public class ConcentricRingsStructurePlacementBuilder
    extends StructurePlacementBuilder<ConcentricRingsStructurePlacementBuilder> {
        protected int distance;
        protected int spread;
        protected int count;
        @NotNull
        protected class_6862<class_1959> preferredBiomes;
        @NotNull
        private final class_7891<class_7059> context;

        ConcentricRingsStructurePlacementBuilder(@NotNull class_7891<class_7059> context, class_5321<class_7059> baseKey) {
            super(StructureSetBuilder.this, baseKey);
            this.context = context;
            this.distance = 32;
            this.spread = 3;
            this.count = 128;
            this.preferredBiomes = class_6908.field_37395;
        }

        @NotNull
        public ConcentricRingsStructurePlacementBuilder distance(int distance) {
            this.distance = distance;
            return this;
        }

        @NotNull
        public ConcentricRingsStructurePlacementBuilder spread(int spread) {
            this.spread = spread;
            return this;
        }

        @NotNull
        public ConcentricRingsStructurePlacementBuilder count(int count) {
            this.count = count;
            return this;
        }

        @NotNull
        public ConcentricRingsStructurePlacementBuilder preferredBiomes(@NotNull class_6862<class_1959> preferredBiomes) {
            this.preferredBiomes = preferredBiomes;
            return this;
        }

        @Override
        public StructureSetBuilder finishPlacement() {
            return StructureSetBuilder.this.setPlacement((class_6874)new class_6871(this.locateOffset, this.frequencyReductionMethod, this.frequency, this.salt, this.exclusionZone, this.distance, this.spread, this.count, (class_6885)this.context.method_46799(class_7924.field_41236).method_46735(this.preferredBiomes)));
        }
    }

    public abstract class StructurePlacementBuilder<R extends StructurePlacementBuilder<R>> {
        protected class_2382 locateOffset = class_2382.field_11176;
        protected class_6874.class_7154 frequencyReductionMethod = class_6874.class_7154.field_37782;
        protected float frequency = 1.0f;
        protected int salt;
        protected Optional<class_6874.class_7152> exclusionZone = Optional.empty();

        public abstract StructureSetBuilder finishPlacement();

        @NotNull
        public R locateOffset(class_2382 offset) {
            this.locateOffset = offset;
            return (R)this;
        }

        @NotNull
        public R frequencyReductionMethod(@NotNull class_6874.class_7154 method) {
            this.frequencyReductionMethod = method;
            return (R)this;
        }

        @NotNull
        public R frequency(float frequency) {
            this.frequency = frequency;
            return (R)this;
        }

        @NotNull
        public R salt(int salt) {
            this.salt = salt;
            return (R)this;
        }

        @NotNull
        public R exclusionZone(@Nullable class_6874.class_7152 exclusionZone) {
            this.exclusionZone = exclusionZone == null ? Optional.empty() : Optional.of(exclusionZone);
            return (R)this;
        }

        protected StructurePlacementBuilder(@NotNull StructureSetBuilder this$0, class_5321<class_7059> baseKey) {
            this.salt = Math.abs(baseKey.method_29177().hashCode());
        }
    }
}

