/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.api;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.betterx.wover.entrypoint.LibWoverStructure;
import org.jetbrains.annotations.Nullable;

public class StructureNBT {
    public final class_2960 location;
    protected class_3499 structure;
    private static final Map<class_2960, StructureNBT> STRUCTURE_CACHE = Maps.newHashMap();
    private static final Map<class_2960, class_3499> READER_CACHE = Maps.newHashMap();

    protected StructureNBT(class_2960 location) {
        this.location = location;
        this.structure = StructureNBT.readStructureFromJar(location);
    }

    protected StructureNBT(class_2960 location, class_3499 structure) {
        this.location = location;
        this.structure = structure;
    }

    public static class_2470 getRandomRotation(class_5819 random) {
        return class_2470.method_16548((class_5819)random);
    }

    public static class_2415 getRandomMirror(class_5819 random) {
        return class_2415.values()[random.method_43048(3)];
    }

    public static StructureNBT create(class_2960 location) {
        return STRUCTURE_CACHE.computeIfAbsent(location, StructureNBT::new);
    }

    public boolean generateCentered(class_5425 world, class_2338 pos, class_2470 rotation, class_2415 mirror) {
        class_2338 newPos = this.getCenteredPos(pos, rotation, mirror);
        if (newPos == null) {
            return false;
        }
        class_3492 data = new class_3492().method_15123(rotation).method_15125(mirror);
        this.structure.method_15172(world, newPos, newPos, data, world.method_8409(), 18);
        return true;
    }

    public boolean generateAt(class_5425 world, class_2338 pos, class_2470 rotation, class_2415 mirror) {
        class_3492 data = new class_3492().method_15123(rotation).method_15125(mirror);
        this.structure.method_15172(world, pos, pos, data, world.method_8409(), 18);
        return true;
    }

    @Nullable
    private class_2338 getCenteredPos(class_2338 pos, class_2470 rotation, class_2415 mirror) {
        if (this.structure == null) {
            LibWoverStructure.C.log.error("No structure: " + this.location.toString());
            return null;
        }
        class_2338.class_2339 blockpos2 = new class_2338.class_2339().method_10101(this.structure.method_15160());
        if (mirror == class_2415.field_11301) {
            blockpos2.method_33097(-blockpos2.method_10263());
        }
        if (mirror == class_2415.field_11300) {
            blockpos2.method_33099(-blockpos2.method_10260());
        }
        blockpos2.method_10101((class_2382)blockpos2.method_10070(rotation));
        return pos.method_10069(-blockpos2.method_10263() >> 1, 0, -blockpos2.method_10260() >> 1);
    }

    private static class_3499 readStructureFromJar(class_2960 resource) {
        return READER_CACHE.computeIfAbsent(resource, r -> StructureNBT._readStructureFromJar(r));
    }

    private static String getStructurePath(class_2960 resource) {
        return "data/" + resource.method_12836() + "/structure/" + resource.method_12832();
    }

    private static class_3499 _readStructureFromJar(class_2960 resource) {
        try {
            InputStream inputstream = MinecraftServer.class.getResourceAsStream("/" + StructureNBT.getStructurePath(resource) + ".nbt");
            return StructureNBT.readStructureFromStream(inputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class_3499 readStructureFromStream(InputStream stream) throws IOException {
        class_2487 nbttagcompound = class_2507.method_10629((InputStream)stream, (class_2505)class_2505.method_53898());
        class_3499 template = new class_3499();
        template.method_15183((class_7871)class_7923.field_41175.method_46771(), nbttagcompound);
        return template;
    }

    public class_2338 getSize(class_2470 rotation) {
        if (rotation == class_2470.field_11467 || rotation == class_2470.field_11464) {
            return new class_2338(this.structure.method_15160());
        }
        class_2382 size = this.structure.method_15160();
        int x = size.method_10263();
        int z = size.method_10260();
        return new class_2338(z, size.method_10264(), x);
    }

    public String getName() {
        return this.location.method_12832();
    }

    public class_3341 getBoundingBox(class_2338 pos, class_2470 rotation, class_2415 mirror) {
        return this.structure.method_16187(new class_3492().method_15123(rotation).method_15125(mirror), pos);
    }

    public class_3341 getCenteredBoundingBox(class_2338 pos, class_2470 rotation, class_2415 mirror) {
        return this.structure.method_16187(new class_3492().method_15123(rotation).method_15125(mirror), this.getCenteredPos(pos, rotation, mirror));
    }

    public static List<StructureNBT> createResourcesFrom(class_2960 resource, int recursionDepth) {
        String ns = resource.method_12836();
        String nm = resource.method_12832();
        String resourceFolder = StructureNBT.getStructurePath(resource);
        URL url = MinecraftServer.class.getClassLoader().getResource(resourceFolder);
        if (url != null) {
            Path myPath;
            URI uri;
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                LibWoverStructure.C.log.error("Unable to load Resources: ", (Exception)e);
                return null;
            }
            if (uri.getScheme().equals("jar")) {
                FileSystem fileSystem = null;
                try {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException notLoaded) {
                    try {
                        fileSystem = FileSystems.newFileSystem(uri, new HashMap());
                    }
                    catch (IOException e) {
                        LibWoverStructure.C.log.error("Unable to load Filesystem: ", (Exception)e);
                        return null;
                    }
                }
                myPath = fileSystem.getPath(resourceFolder, new String[0]);
            } else {
                myPath = Paths.get(uri);
            }
            if (Files.isDirectory(myPath, new LinkOption[0])) {
                try {
                    return Files.walk(myPath, recursionDepth <= 0 ? Integer.MAX_VALUE : recursionDepth, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0])).map(p -> {
                        if (p.isAbsolute()) {
                            return Path.of(uri).relativize((Path)p).toString();
                        }
                        return p.toString().replace(resourceFolder, "").replaceAll("^/+", "");
                    }).filter(s -> s.endsWith(".nbt")).map(s -> class_2960.method_60655((String)ns, (String)((String)(nm.isEmpty() ? "" : nm + "/") + s.substring(0, s.length() - 4)))).sorted(Comparator.comparing(class_2960::toString)).map(r -> {
                        LibWoverStructure.C.log.info("Loading Structure: " + String.valueOf(r));
                        try {
                            return StructureNBT.create(r);
                        }
                        catch (Exception e) {
                            LibWoverStructure.C.log.error("Unable to load Structure " + String.valueOf(r), e);
                            return null;
                        }
                    }).toList();
                }
                catch (IOException e) {
                    LibWoverStructure.C.log.error("Unable to load Resources: ", (Exception)e);
                    return null;
                }
            }
        }
        return null;
    }
}

