/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.neo_language_reload.mixin;

import com.euphony.neo_language_reload.access.ILanguage;
import com.euphony.neo_language_reload.access.ITranslationStorage;
import com.euphony.neo_language_reload.config.Config;
import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.chat.contents.TranslatableFormatException;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={TranslatableContents.class})
abstract class TranslatableTextContentMixin
implements ComponentContents {
    @Shadow
    @Final
    private String key;

    TranslatableTextContentMixin() {
    }

    @WrapOperation(method={"visit(Lnet/minecraft/network/chat/FormattedText$ContentConsumer;)Ljava/util/Optional;"}, at={@At(value="FIELD", target="Lnet/minecraft/network/chat/contents/TranslatableContents;decomposedParts:Ljava/util/List;")})
    List<FormattedText> onVisit(TranslatableContents instance, Operation<List<FormattedText>> translationsGetter) {
        List<FormattedText> overriddenTranslations = this.getOverriddenTranslations();
        if (overriddenTranslations != null) {
            return overriddenTranslations;
        }
        return (List)translationsGetter.call(new Object[]{instance});
    }

    @WrapOperation(method={"visit(Lnet/minecraft/network/chat/FormattedText$StyledContentConsumer;Lnet/minecraft/network/chat/Style;)Ljava/util/Optional;"}, at={@At(value="FIELD", target="Lnet/minecraft/network/chat/contents/TranslatableContents;decomposedParts:Ljava/util/List;")})
    List<FormattedText> onVisitStyled(TranslatableContents instance, Operation<List<FormattedText>> translationsGetter) {
        List<FormattedText> overriddenTranslations = this.getOverriddenTranslations();
        if (overriddenTranslations != null) {
            return overriddenTranslations;
        }
        return (List)translationsGetter.call(new Object[]{instance});
    }

    @Unique
    List<FormattedText> getOverriddenTranslations() {
        if (!Config.getInstance().multilingualItemSearch) {
            return null;
        }
        Language language = Language.getInstance();
        if (language == null) {
            return null;
        }
        ClientLanguage translationStorage = ((ILanguage)language).languagereload_getTranslationStorage();
        if (translationStorage == null) {
            return null;
        }
        String targetLanguage = ((ITranslationStorage)translationStorage).languagereload_getTargetLanguage();
        if (targetLanguage == null) {
            return null;
        }
        String string = ((ITranslationStorage)translationStorage).languagereload_get(this.key);
        try {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            this.decomposeTemplate(string, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            return builder.build();
        }
        catch (TranslatableFormatException e) {
            return ImmutableList.of((Object)FormattedText.of((String)string));
        }
    }

    @Shadow
    protected abstract void decomposeTemplate(String var1, Consumer<FormattedText> var2);
}

