/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.neo_language_reload.mixin;

import com.euphony.neo_language_reload.NeoLanguageReload;
import com.euphony.neo_language_reload.config.Config;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.nbt.CompoundTag;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Options.class})
abstract class GameOptionsMixin {
    @Shadow
    @Final
    private File optionsFile;
    @Shadow
    public String languageCode;

    GameOptionsMixin() {
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    void onConstructed(Minecraft minecraft, File gameDirectory, CallbackInfo ci) {
        if (!NeoLanguageReload.shouldSetSystemLanguage) {
            GameOptionsMixin.checkConfigLanguage(this.languageCode);
        }
    }

    @Inject(method={"Lnet/minecraft/client/Options;load(Z)V"}, at={@At(value="HEAD")})
    void onLoad(CallbackInfo ci) {
        if (!this.optionsFile.exists()) {
            NeoLanguageReload.shouldSetSystemLanguage = true;
        }
    }

    @Inject(method={"dataFix"}, at={@At(value="RETURN")})
    void onUpdate(CompoundTag nbt, CallbackInfoReturnable<CompoundTag> cir) {
        String lang = ((CompoundTag)cir.getReturnValue()).getString("lang");
        if (lang.isEmpty()) {
            NeoLanguageReload.shouldSetSystemLanguage = true;
        } else {
            GameOptionsMixin.checkConfigLanguage(lang);
        }
    }

    @Unique
    private static void checkConfigLanguage(String language) {
        Config config = Config.getInstance();
        if (!config.language.equals(language)) {
            NeoLanguageReload.LOGGER.info("Game language ({}) and config language ({}) are different. Updating config", (Object)language, (Object)config.language);
            config.previousLanguage = config.language;
            config.previousFallbacks = config.fallbacks;
            config.language = language;
            config.fallbacks.clear();
            if (!language.equals("en_us")) {
                config.fallbacks.add("en_us");
            }
            Config.save();
        }
    }
}

