/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.neo_language_reload.gui;

import com.euphony.neo_language_reload.access.ILanguageOptionsScreen;
import com.euphony.neo_language_reload.config.Config;
import com.euphony.neo_language_reload.gui.LanguageListWidget;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector2i;

public class LanguageEntry
extends ObjectSelectionList.Entry<LanguageEntry> {
    private static final Component DEFAULT_LANGUAGE_TOOLTIP = Component.translatable((String)"language.default.tooltip");
    private static final WidgetSprites ADD_TEXTURES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"neo_language_reload", (String)"language_selection/add"), ResourceLocation.fromNamespaceAndPath((String)"neo_language_reload", (String)"language_selection/add_highlighted"));
    private static final WidgetSprites REMOVE_TEXTURES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"neo_language_reload", (String)"language_selection/remove"), ResourceLocation.fromNamespaceAndPath((String)"neo_language_reload", (String)"language_selection/remove_highlighted"));
    private static final WidgetSprites MOVE_UP_TEXTURES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"neo_language_reload", (String)"language_selection/move_up"), ResourceLocation.fromNamespaceAndPath((String)"neo_language_reload", (String)"language_selection/move_up_highlighted"));
    private static final WidgetSprites MOVE_DOWN_TEXTURES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"neo_language_reload", (String)"language_selection/move_down"), ResourceLocation.fromNamespaceAndPath((String)"neo_language_reload", (String)"language_selection/move_down_highlighted"));
    private final Minecraft client = Minecraft.getInstance();
    private final String code;
    private final LanguageInfo language;
    private final LinkedList<String> selectedLanguages;
    private final Runnable refreshListsAction;
    private final List<AbstractWidget> buttons = new ArrayList<AbstractWidget>();
    private final Button addButton = this.addButton(15, 24, ADD_TEXTURES, __ -> this.add());
    private final Button removeButton = this.addButton(15, 24, REMOVE_TEXTURES, __ -> this.remove());
    private final Button moveUpButton = this.addButton(11, 11, MOVE_UP_TEXTURES, __ -> this.moveUp());
    private final Button moveDownButton = this.addButton(11, 11, MOVE_DOWN_TEXTURES, __ -> this.moveDown());
    private LanguageListWidget parentList;

    public LanguageEntry(Runnable refreshListsAction, String code, LanguageInfo language, LinkedList<String> selectedLanguages) {
        this.code = code;
        this.language = language;
        this.selectedLanguages = selectedLanguages;
        this.refreshListsAction = refreshListsAction;
    }

    protected Button addButton(int width, int height, WidgetSprites textures, Button.OnPress action) {
        ImageButton button = new ImageButton(0, 0, width, height, textures, action);
        button.visible = false;
        this.buttons.add((AbstractWidget)button);
        return button;
    }

    private boolean isDefault() {
        return this.code.equals("en_us");
    }

    private boolean isSelected() {
        return this.selectedLanguages.contains(this.code);
    }

    private boolean isFirst() {
        return this.code.equals(this.selectedLanguages.peekFirst());
    }

    private boolean isLast() {
        return this.code.equals(this.selectedLanguages.peekLast());
    }

    private void add() {
        if (this.isFocused()) {
            this.parentList.setFocused(null);
        }
        this.selectedLanguages.addFirst(this.code);
        this.refreshListsAction.run();
    }

    private void remove() {
        if (this.isFocused()) {
            this.parentList.setFocused(null);
        }
        this.selectedLanguages.remove(this.code);
        this.refreshListsAction.run();
    }

    public void toggle() {
        if (!this.isSelected()) {
            this.add();
        } else {
            this.remove();
        }
    }

    public void moveUp() {
        if (!this.isSelected()) {
            return;
        }
        if (this.isFirst()) {
            return;
        }
        int index = this.selectedLanguages.indexOf(this.code);
        this.selectedLanguages.add(index - 1, this.selectedLanguages.remove(index));
        this.refreshListsAction.run();
    }

    public void moveDown() {
        if (!this.isSelected()) {
            return;
        }
        if (this.isLast()) {
            return;
        }
        int index = this.selectedLanguages.indexOf(this.code);
        this.selectedLanguages.add(index + 1, this.selectedLanguages.remove(index));
        this.refreshListsAction.run();
    }

    public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        x -= 2;
        y -= 2;
        if (hovered || this.isFocused() || ((Boolean)this.client.options.touchscreen().get()).booleanValue()) {
            context.fill(x + 1, y + 1, x + entryWidth - 1, y + entryHeight + 3, hovered || this.isFocused() ? -1601138544 : 0x50909090);
            this.buttons.forEach(button -> {
                button.visible = false;
            });
            this.renderButtons((button, buttonX, buttonY) -> {
                button.setX(buttonX);
                button.setY(buttonY);
                button.visible = true;
                button.render(context, mouseX, mouseY, tickDelta);
            }, x, y);
            if ((hovered || this.isFocused()) && this.isDefault()) {
                this.renderDefaultLanguageTooltip(x, y);
            }
        }
        context.drawString(this.client.font, this.language.name(), x + 29, y + 3, 0xFFFFFF);
        context.drawString(this.client.font, this.language.region(), x + 29, y + 14, 0x808080);
    }

    private void renderButtons(ButtonRenderer renderer, int x, int y) {
        if (this.isSelected()) {
            if (!this.isDefault() || Config.getInstance().removableDefaultLanguage) {
                renderer.render(this.removeButton, x, y);
            }
            if (!this.isFirst()) {
                renderer.render(this.moveUpButton, x + this.removeButton.getWidth() + 1, y);
            }
            if (!this.isLast()) {
                renderer.render(this.moveDownButton, x + this.removeButton.getWidth() + 1, y + this.moveUpButton.getHeight() + 2);
            }
        } else {
            renderer.render(this.addButton, x + 7, y);
        }
    }

    private void renderDefaultLanguageTooltip(int x, int y) {
        List tooltip = this.client.font.split((FormattedText)DEFAULT_LANGUAGE_TOOLTIP, this.parentList.getRowWidth() - 6);
        this.parentList.getScreen().setTooltipForNextRenderPass(tooltip, (screenWidth, screenHeight, mouseX, mouseY, width, height) -> {
            Vector2i pos = new Vector2i(x + 3 + (this.parentList.getRowWidth() - width - 6) / 2, y + this.parentList.getRowHeight() + 4);
            if (pos.y > this.parentList.getBottom() + 2 || pos.y + height + 5 > screenHeight) {
                pos.y = y - height - 6;
            }
            return pos;
        }, true);
    }

    public Component getNarration() {
        return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.language.toComponent()});
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (AbstractWidget widget : this.buttons) {
            if (!widget.mouseClicked(mouseX, mouseY, button)) continue;
            ((ILanguageOptionsScreen)this.parentList.getScreen()).languagereload_focusList(this.parentList);
            return true;
        }
        return false;
    }

    public void setParent(LanguageListWidget list) {
        this.parentList = list;
    }

    public LanguageListWidget getParent() {
        return this.parentList;
    }

    public String getCode() {
        return this.code;
    }

    public LanguageInfo getLanguage() {
        return this.language;
    }

    @FunctionalInterface
    private static interface ButtonRenderer {
        public void render(Button var1, int var2, int var3);
    }
}

