/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.neo_language_reload;

import com.euphony.neo_language_reload.access.IAdvancementsScreen;
import com.euphony.neo_language_reload.config.Config;
import com.euphony.neo_language_reload.config.ConfigScreen;
import com.euphony.neo_language_reload.mixin.BookScreenAccessor;
import com.euphony.neo_language_reload.mixin.ClientChunkManagerAccessor;
import com.euphony.neo_language_reload.mixin.ClientChunkMapAccessor;
import com.euphony.neo_language_reload.mixin.SignTextAccessor;
import com.euphony.neo_language_reload.mixin.TextDisplayEntityAccessor;
import com.mojang.logging.LogUtils;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.slf4j.Logger;

@Mod(value="neo_language_reload", dist={Dist.CLIENT})
public class NeoLanguageReload {
    public static final String MOD_ID = "neo_language_reload";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String NO_LANGUAGE = "*";
    public static boolean shouldSetSystemLanguage = false;

    public static void reloadLanguages() {
        Minecraft client = Minecraft.getInstance();
        client.getLanguageManager().onResourceManagerReload(client.getResourceManager());
        client.updateTitle();
        client.gui.getChat().rescaleChat();
        Screen screen = client.screen;
        if (screen instanceof BookViewScreen) {
            BookViewScreen bookScreen = (BookViewScreen)screen;
            ((BookScreenAccessor)bookScreen).languagereload_setCachedPageIndex(-1);
        } else {
            screen = client.screen;
            if (screen instanceof AdvancementsScreen) {
                AdvancementsScreen advancementsScreen = (AdvancementsScreen)screen;
                ((IAdvancementsScreen)advancementsScreen).languagereload_recreateWidgets();
            }
        }
        if (client.level != null) {
            ClientChunkManagerAccessor chunkManager = (ClientChunkManagerAccessor)client.level.getChunkSource();
            AtomicReferenceArray<LevelChunk> chunks = ((ClientChunkMapAccessor)chunkManager.languagereload_getChunks()).languagereload_getChunks();
            for (int i = 0; i < chunks.length(); ++i) {
                LevelChunk chunk = chunks.get(i);
                if (chunk == null) continue;
                for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
                    if (!(blockEntity instanceof SignBlockEntity)) continue;
                    SignBlockEntity sign = (SignBlockEntity)blockEntity;
                    ((SignTextAccessor)sign.getFrontText()).languagereload_setOrderedMessages(null);
                    ((SignTextAccessor)sign.getBackText()).languagereload_setOrderedMessages(null);
                }
            }
            for (Entity entity : client.level.entitiesForRendering()) {
                if (!(entity instanceof Display.TextDisplay)) continue;
                Display.TextDisplay textDisplay = (Display.TextDisplay)entity;
                ((TextDisplayEntityAccessor)textDisplay).languagereload_setTextLines(null);
            }
        }
    }

    public static void setLanguage(String language, LinkedList<String> fallbacks) {
        Minecraft client = Minecraft.getInstance();
        LanguageManager languageManager = client.getLanguageManager();
        Config config = Config.getInstance();
        boolean languageIsSame = languageManager.getSelected().equals(language);
        boolean fallbacksAreSame = config.fallbacks.equals(fallbacks);
        if (languageIsSame && fallbacksAreSame) {
            return;
        }
        config.previousLanguage = languageManager.getSelected();
        config.previousFallbacks = config.fallbacks;
        config.language = language;
        config.fallbacks = fallbacks;
        Config.save();
        languageManager.setSelected(language);
        client.options.languageCode = language;
        client.options.save();
        NeoLanguageReload.reloadLanguages();
    }

    public NeoLanguageReload(IEventBus modEventBus, ModContainer modContainer) {
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, screen) -> new ConfigScreen(screen));
    }
}

