/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.preset.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7145;
import net.minecraft.class_7924;
import org.betterx.wover.preset.api.WorldPresetInfo;
import org.betterx.wover.preset.api.WorldPresetInfoRegistry;
import org.betterx.wover.util.PriorityLinkedList;
import org.jetbrains.annotations.Nullable;

public class WorldPresetInfoImpl
implements WorldPresetInfo {
    public static final Codec<WorldPresetInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("sort_order", (Object)PriorityLinkedList.DEFAULT_PRIORITY).forGetter(o -> o.sortOrder()), (App)class_5321.method_39154((class_5321)class_7924.field_41250).optionalFieldOf("overworld_preset").forGetter(o -> Optional.ofNullable(o.overworldPreset())), (App)class_5321.method_39154((class_5321)class_7924.field_41250).optionalFieldOf("nether_preset").forGetter(o -> Optional.ofNullable(o.netherPreset())), (App)class_5321.method_39154((class_5321)class_7924.field_41250).optionalFieldOf("end_preset").forGetter(o -> Optional.ofNullable(o.endPreset()))).apply((Applicative)instance, WorldPresetInfoImpl::fromOptionals));
    public static final WorldPresetInfo DEFAULT = new WorldPresetInfoImpl(PriorityLinkedList.DEFAULT_PRIORITY, null, null, null);
    private final int sortOrder;
    @Nullable
    private final class_5321<class_7145> overworldLike;
    @Nullable
    private final class_5321<class_7145> netherLike;
    @Nullable
    private final class_5321<class_7145> endLike;

    private static WorldPresetInfo fromOptionals(Integer sort, Optional<class_5321<class_7145>> overworld, Optional<class_5321<class_7145>> nether, Optional<class_5321<class_7145>> end) {
        return new WorldPresetInfoImpl(sort, (class_5321<class_7145>)((class_5321)overworld.orElse(null)), (class_5321<class_7145>)((class_5321)nether.orElse(null)), (class_5321<class_7145>)((class_5321)end.orElse(null)));
    }

    public WorldPresetInfoImpl(int order) {
        this(order, null, null, null);
    }

    WorldPresetInfoImpl(int sortOrder, @Nullable class_5321<class_7145> overworldLike, @Nullable class_5321<class_7145> netherLike, @Nullable class_5321<class_7145> endLike) {
        this.sortOrder = sortOrder;
        this.overworldLike = overworldLike;
        this.netherLike = netherLike;
        this.endLike = endLike;
    }

    @Override
    public int sortOrder() {
        return this.sortOrder;
    }

    @Override
    @Nullable
    public class_5321<class_7145> overworldPreset() {
        return this.overworldLike;
    }

    @Override
    @Nullable
    public class_5321<class_7145> netherPreset() {
        return this.netherLike;
    }

    @Override
    @Nullable
    public class_5321<class_7145> endPreset() {
        return this.endLike;
    }

    @Override
    @Nullable
    public class_5321<class_7145> getPresetOverride(class_5321<class_5363> key) {
        if (key.method_29177().equals((Object)class_5363.field_25412.method_29177())) {
            return this.overworldPreset();
        }
        if (key.method_29177().equals((Object)class_5363.field_25413.method_29177())) {
            return this.netherPreset();
        }
        if (key.method_29177().equals((Object)class_5363.field_25414.method_29177())) {
            return this.endPreset();
        }
        return null;
    }

    @Override
    @Nullable
    public class_5321<class_7145> getPresetOverrideRecursive(class_5321<class_5363> forDimension, int count) {
        class_5321<class_7145> configuredKey = null;
        class_5321<class_7145> overrideKey = this.getPresetOverride(forDimension);
        while (overrideKey != null && count > 0) {
            configuredKey = overrideKey;
            overrideKey = WorldPresetInfoRegistry.getFor(configuredKey).getPresetOverride(forDimension);
            --count;
        }
        return configuredKey;
    }
}

