/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.world.inventory;

import com.mojang.datafixers.util.Pair;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.init.ModRegistry;
import fuzs.easymagic.mixin.accessor.EnchantmentMenuAccessor;
import fuzs.easymagic.mixin.accessor.PlayerAccessor;
import fuzs.easymagic.network.ClientboundEnchantingDataMessage;
import fuzs.easymagic.util.ChiseledBookshelfHelper;
import fuzs.easymagic.util.PlayerExperienceHelper;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.network.v3.ClientboundMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnchantingTableBlock;

public class ModEnchantmentMenu
extends EnchantmentMenu
implements ContainerListener {
    static final ResourceLocation EMPTY_SLOT_LAPIS_LAZULI = ResourceLocationHelper.withDefaultNamespace((String)"item/empty_slot_lapis_lazuli");
    public static final int REROLL_CATALYST_SLOT = 38;
    private final Container enchantSlots;
    private final ContainerLevelAccess access;
    private final Player player;
    private final RandomSource random;
    private final DataSlot enchantmentSeed;

    public ModEnchantmentMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 3 : 2), ContainerLevelAccess.NULL);
    }

    public ModEnchantmentMenu(int id, Inventory inventory, Container container, ContainerLevelAccess access) {
        super(id, inventory, access);
        this.enchantSlots = container;
        this.access = access;
        this.player = inventory.player;
        this.random = ((EnchantmentMenuAccessor)((Object)this)).getRandom();
        this.enchantmentSeed = ((EnchantmentMenuAccessor)((Object)this)).getEnchantmentSeed();
        ((EnchantmentMenuAccessor)((Object)this)).setEnchantSlots(container);
        boolean dedicatedRerollCatalyst = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst;
        if (dedicatedRerollCatalyst) {
            this.addSlot(new Slot(this, container, 2, 41, 47){

                public boolean mayPlace(ItemStack stack) {
                    return stack.is(ModRegistry.REROLL_CATALYSTS_ITEM_TAG);
                }
            });
        }
        this.setSlot(0, new Slot(this, container, 0, dedicatedRerollCatalyst ? 5 : 15, 47){

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.setSlot(1, new Slot(this, container, 1, dedicatedRerollCatalyst ? 23 : 35, 47){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ModRegistry.ENCHANTING_CATALYSTS_ITEM_TAG);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_SLOT_LAPIS_LAZULI);
            }
        });
        this.addSlotListener(this);
    }

    public Slot setSlot(int index, Slot slot) {
        slot.index = index;
        this.slots.set(index, (Object)slot);
        return slot;
    }

    public MenuType<?> getType() {
        return (MenuType)ModRegistry.ENCHANTMENT_MENU_TYPE.value();
    }

    public void slotsChanged(Container inventory) {
        if (inventory == this.enchantSlots) {
            ItemStack itemStack = inventory.getItem(0);
            if (!itemStack.isEmpty() && itemStack.isEnchantable()) {
                this.access.execute((level, pos) -> {
                    int power = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).maxEnchantingPower == 0 ? 15 : this.getEnchantingPower((Level)level, (BlockPos)pos) * 15 / ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).maxEnchantingPower;
                    this.random.setSeed((long)this.enchantmentSeed.get());
                    this.updateLevels(itemStack, (Level)level, (BlockPos)pos, power);
                    this.createClues(level.registryAccess(), itemStack);
                    this.broadcastChanges();
                    this.sendEnchantingData(level.registryAccess(), itemStack);
                });
            } else {
                this.resetLevelsAndClues();
            }
        }
    }

    public void slotChanged(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
        if (abstractContainerMenu == this) {
            this.access.execute((Level2, BlockPos2) -> {
                if (i >= 0 && i < 2) {
                    this.slotsChanged(this.enchantSlots);
                }
            });
        }
    }

    public void dataChanged(AbstractContainerMenu abstractContainerMenu, int i, int j) {
    }

    private void resetLevelsAndClues() {
        for (int i = 0; i < 3; ++i) {
            this.costs[i] = 0;
            this.enchantClue[i] = -1;
            this.levelClue[i] = -1;
        }
    }

    private void updateLevels(ItemStack itemstack, Level world, BlockPos pos, int power) {
        for (int i1 = 0; i1 < 3; ++i1) {
            this.costs[i1] = EnchantmentHelper.getEnchantmentCost((RandomSource)this.random, (int)i1, (int)power, (ItemStack)itemstack);
            if (this.costs[i1] >= i1 + 1) continue;
            this.costs[i1] = 0;
        }
    }

    private void createClues(RegistryAccess registryAccess, ItemStack itemstack) {
        IdMap idMap = registryAccess.registryOrThrow(Registries.ENCHANTMENT).asHolderIdMap();
        for (int i = 0; i < 3; ++i) {
            List<EnchantmentInstance> list;
            if (this.costs[i] <= 0 || (list = this.createEnchantmentInstance(registryAccess, itemstack, i)) == null || list.isEmpty()) continue;
            EnchantmentInstance enchantmentdata = list.get(this.random.nextInt(list.size()));
            this.enchantClue[i] = idMap.getId((Object)enchantmentdata.enchantment);
            this.levelClue[i] = enchantmentdata.level;
        }
    }

    private List<EnchantmentInstance> createEnchantmentInstance(RegistryAccess registryAccess, ItemStack itemStack, int enchantSlot) {
        return ((EnchantmentMenuAccessor)((Object)this)).callGetEnchantmentList(registryAccess, itemStack, enchantSlot, this.costs[enchantSlot]);
    }

    private List<EnchantmentInstance> getEnchantmentHint(RegistryAccess registryAccess, ItemStack itemStack, int enchantSlot, ServerConfig.EnchantmentHint enchantmentHint) {
        return switch (enchantmentHint) {
            default -> throw new MatchException(null, null);
            case ServerConfig.EnchantmentHint.NONE -> Collections.emptyList();
            case ServerConfig.EnchantmentHint.SINGLE -> {
                List<EnchantmentInstance> enchantmentData = this.createEnchantmentInstance(registryAccess, itemStack, enchantSlot);
                if (enchantmentData.isEmpty()) {
                    yield Collections.emptyList();
                }
                yield Collections.singletonList(enchantmentData.get(this.random.nextInt(enchantmentData.size())));
            }
            case ServerConfig.EnchantmentHint.ALL -> this.createEnchantmentInstance(registryAccess, itemStack, enchantSlot);
        };
    }

    private void sendEnchantingData(RegistryAccess registryAccess, ItemStack itemStack) {
        ServerConfig.EnchantmentHint enchantmentHint = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).enchantmentHint;
        ArrayList<List<EnchantmentInstance>> slotData = new ArrayList<List<EnchantmentInstance>>(3);
        for (int i = 0; i < 3; ++i) {
            slotData.add(i, this.getEnchantmentHint(registryAccess, itemStack, i, enchantmentHint));
        }
        EasyMagic.NETWORK.sendTo((ServerPlayer)this.player, (ClientboundMessage)new ClientboundEnchantingDataMessage(this.containerId, slotData));
    }

    private int getEnchantingPower(Level level, BlockPos pos) {
        float enchantingPower = 0.0f;
        int chiseledBookshelfBooks = 0;
        for (BlockPos offset : EnchantingTableBlock.BOOKSHELF_OFFSETS) {
            if (!EnchantingTableBlock.isValidBookShelf((Level)level, (BlockPos)pos, (BlockPos)offset)) continue;
            enchantingPower += CommonAbstractions.INSTANCE.getEnchantPowerBonus(level.getBlockState(pos.offset((Vec3i)offset)), level, pos.offset((Vec3i)offset));
            chiseledBookshelfBooks += ChiseledBookshelfHelper.findValidBooks(level, pos, offset);
        }
        return (int)enchantingPower + chiseledBookshelfBooks / 3;
    }

    public boolean clickMenuButton(Player player, int data) {
        if (data == 4) {
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments && this.canUseReroll()) {
                int catalystSlot = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 2 : 1;
                ItemStack itemstack = this.enchantSlots.getItem(catalystSlot);
                if (player.getAbilities().instabuild || itemstack.getCount() >= ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost) {
                    int totalExperience;
                    int n = totalExperience = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollingTakesEnchantmentLevels ? player.experienceLevel : PlayerExperienceHelper.getTotalExperience(player);
                    if (player.getAbilities().instabuild || totalExperience >= ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost) {
                        this.access.execute((level, pos) -> {
                            this.enchantmentSeed.set(this.player.getRandom().nextInt());
                            ((PlayerAccessor)this.player).setEnchantmentSeed(this.enchantmentSeed.get());
                            if (!player.getAbilities().instabuild) {
                                if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost > 0) {
                                    itemstack.shrink(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost);
                                    if (itemstack.isEmpty()) {
                                        this.enchantSlots.setItem(catalystSlot, ItemStack.EMPTY);
                                    }
                                }
                                if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost > 0) {
                                    if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollingTakesEnchantmentLevels) {
                                        player.giveExperienceLevels(-((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost);
                                    } else {
                                        player.giveExperiencePoints(-((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost);
                                    }
                                }
                            }
                            this.enchantSlots.setChanged();
                            this.slotsChanged(this.enchantSlots);
                        });
                        return true;
                    }
                }
            }
            return false;
        }
        return super.clickMenuButton(player, data);
    }

    public boolean canUseReroll() {
        ItemStack itemToEnchant = this.enchantSlots.getItem(0);
        if (!itemToEnchant.isEmpty() && itemToEnchant.isEnchantable()) {
            for (int cost : this.costs) {
                if (cost <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean stillValid(Player playerIn) {
        return this.enchantSlots.stillValid(playerIn);
    }

    public void removed(Player playerIn) {
        ItemStack itemstack;
        if (playerIn instanceof ServerPlayer && !(itemstack = this.getCarried()).isEmpty()) {
            if (playerIn.isAlive() && !((ServerPlayer)playerIn).hasDisconnected()) {
                playerIn.getInventory().placeItemBackInInventory(itemstack);
            } else {
                playerIn.drop(itemstack, false);
            }
            this.setCarried(ItemStack.EMPTY);
        }
    }

    public int getRerollCatalystCount() {
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst) {
            return this.enchantSlots.getItem(2).getCount();
        }
        return this.getGoldCount();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            boolean override = false;
            boolean dedicatedRerollCatalyst = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst;
            if (dedicatedRerollCatalyst && index == 38) {
                override = true;
                if (!this.moveItemStackTo(itemStack2, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (index != 0 && index != 1) {
                if (itemStack2.is(ModRegistry.ENCHANTING_CATALYSTS_ITEM_TAG)) {
                    override = true;
                    if (!this.moveItemStackTo(itemStack2, 1, 2, true)) {
                        return ItemStack.EMPTY;
                    }
                } else if (dedicatedRerollCatalyst && itemStack2.is(ModRegistry.REROLL_CATALYSTS_ITEM_TAG)) {
                    override = true;
                    if (!this.moveItemStackTo(itemStack2, 38, 39, true)) {
                        return ItemStack.EMPTY;
                    }
                }
            }
            if (!override) {
                return super.quickMoveStack(player, index);
            }
            if (itemStack2.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack2);
        }
        return itemStack;
    }
}

