/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.tag.impl;

import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7922;
import net.minecraft.class_7924;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.entrypoint.LibWoverTag;
import org.betterx.wover.events.api.Event;
import org.betterx.wover.events.impl.EventImpl;
import org.betterx.wover.tag.api.TagRegistry;
import org.betterx.wover.tag.api.event.OnBoostrapTags;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.jetbrains.annotations.Nullable;

public abstract class TagRegistryImpl<T, P extends TagBootstrapContext<T>>
implements TagRegistry<T, P> {
    private final class_5321<? extends class_2378<T>> registryKey;
    final ConcurrentLinkedQueue<class_6862<T>> tags = new ConcurrentLinkedQueue();
    @Nullable
    final TagRegistry.LocationProvider<T> locationProvider;
    public final String directory;
    private final EventImpl<OnBoostrapTags<T, P>> BOOTSTRAP_EVENT;

    protected TagRegistryImpl(class_5321<? extends class_2378<T>> registryKey, String directory, TagRegistry.LocationProvider<T> locationProvider) {
        this.registryKey = registryKey;
        this.directory = directory;
        this.locationProvider = locationProvider;
        this.BOOTSTRAP_EVENT = new EventImpl("TAG_BOOTSTRAP_EVENT (" + directory + ")");
    }

    @Override
    public class_6862<T> makeWorldWeaverTag(String name) {
        return this.makeTag(LibWoverTag.C.mk(name));
    }

    @Override
    public class_6862<T> makeCommonTag(String name) {
        return this.makeTag(class_2960.method_60655((String)"c", (String)name));
    }

    @Override
    public class_6862<T> makeFabricTag(String name) {
        return this.makeTag(class_2960.method_60655((String)"fabric", (String)name));
    }

    @Override
    public class_6862<T> makeTag(ModCore mod, String name) {
        return this.makeTag(mod.id(name));
    }

    @Override
    public class_6862<T> makeTag(class_2960 id) {
        class_6862 tag = class_6862.method_40092(this.registryKey, (class_2960)id);
        this.initializeTag(tag);
        return tag;
    }

    protected void initializeTag(class_6862<T> tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    @Override
    public abstract P createBootstrapContext(boolean var1);

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (class_6862<T> entry : this.tags) {
            b.append("  - ").append(entry).append(" \n");
        }
        return "TagRegistry{registryKey=" + String.valueOf(this.registryKey) + ", directory='" + this.directory + "', tagElements=\n" + b.toString() + "}";
    }

    @Override
    public class_5321<? extends class_2378<T>> registryKey() {
        return this.registryKey;
    }

    @Override
    public Event<OnBoostrapTags<T, P>> bootstrapEvent() {
        return this.BOOTSTRAP_EVENT;
    }

    P emitLoadEvent(boolean initAll) {
        Object ctx = this.createBootstrapContext(initAll);
        if (!ModCore.isDatagen()) {
            this.BOOTSTRAP_EVENT.emit(c -> c.bootstrap(ctx));
        }
        return ctx;
    }

    public static abstract class WithRegistry<T, P extends TagBootstrapContext<T>>
    extends TagRegistryImpl<T, P> {
        private final class_7922<T> registry;

        public WithRegistry(class_7922<T> registry) {
            super(registry.method_30517(), class_7924.method_60916((class_5321)registry.method_30517()), element -> {
                class_2960 id = registry.method_10221(element);
                if (id != registry.method_10137()) {
                    return id;
                }
                return null;
            });
            this.registry = registry;
        }

        @Override
        public class_6862<T> makeTag(class_2960 id) {
            class_6862 tag = this.registry.method_40273().filter(tagKey -> tagKey.comp_327().equals((Object)id)).findAny().orElse(class_6862.method_40092((class_5321)this.registry.method_30517(), (class_2960)id));
            this.initializeTag(tag);
            return tag;
        }
    }
}

