/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.tag.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3503;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.betterx.wover.entrypoint.LibWoverTag;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.tag.api.TagRegistry;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.impl.BiomeTagRegistryImpl;
import org.betterx.wover.tag.impl.ItemTagRegistryImpl;
import org.betterx.wover.tag.impl.TagBootstrapContextImpl;
import org.betterx.wover.tag.impl.TagRegistryImpl;
import org.betterx.wover.tag.impl.TagRegistrySimple;
import org.jetbrains.annotations.ApiStatus;

public class TagManagerImpl {
    private static final Map<String, TagRegistryImpl<?, ?>> TYPES = Maps.newHashMap();
    public static TagRegistryImpl<class_2248, TagBootstrapContext<class_2248>> BLOCKS = TagManagerImpl.registerType(class_7923.field_41175);
    public static TagRegistryImpl<class_1792, ItemTagBootstrapContext> ITEMS = TagManagerImpl.registerItem();
    public static TagRegistryImpl<class_1887, TagBootstrapContext<class_1887>> ENCHANTMENTS = TagManagerImpl.registerType(class_7924.field_41265);
    public static TagRegistryImpl<class_1299<?>, TagBootstrapContext<class_1299<?>>> ENTITY_TYPES = TagManagerImpl.registerType(class_7924.field_41266);
    public static BiomeTagRegistryImpl BIOMES = TagManagerImpl.registerBiome();
    private static final class_2960 NO_TAG = LibWoverTag.C.mk("no_tag");

    public static <T, P extends TagBootstrapContext<T>> TagRegistryImpl<T, P> registerType(class_7922<T> registry) {
        TagRegistrySimple type = new TagRegistrySimple(registry);
        return TYPES.computeIfAbsent(type.directory, dir -> type);
    }

    public static <T, P extends TagBootstrapContext<T>> TagRegistryImpl<T, P> registerType(class_2378<T> registry, String directory) {
        return TagManagerImpl.registerType(registry.method_30517(), directory, o -> registry.method_10221(o));
    }

    public static <T, P extends TagBootstrapContext<T>> TagRegistryImpl<T, P> registerType(class_5321<? extends class_2378<T>> registry, String directory, TagRegistry.LocationProvider<T> locationProvider) {
        return TYPES.computeIfAbsent(directory, dir -> new TagRegistryImpl<T, TagBootstrapContext<T>>(registry, (String)dir, locationProvider){

            @Override
            public TagBootstrapContext<T> createBootstrapContext(boolean initAll) {
                return TagBootstrapContextImpl.create(this, initAll);
            }
        });
    }

    public static <T, P extends TagBootstrapContext<T>> TagRegistryImpl<T, P> registerType(class_5321<? extends class_2378<T>> registryKey) {
        return TagManagerImpl.registerType(registryKey, class_7924.method_60916(registryKey), preset -> WorldState.registryAccess() != null ? WorldState.registryAccess().method_30530(registryKey).method_10221(preset) : null);
    }

    public static TagRegistryImpl<class_1792, ItemTagBootstrapContext> registerItem() {
        ItemTagRegistryImpl type = new ItemTagRegistryImpl();
        return TYPES.computeIfAbsent(type.directory, dir -> type);
    }

    static BiomeTagRegistryImpl registerBiome() {
        return (BiomeTagRegistryImpl)TYPES.computeIfAbsent("tags/worldgen/biome", dir -> new BiomeTagRegistryImpl((String)dir, b -> WorldState.getBiomeID((class_1959)b)));
    }

    @ApiStatus.Internal
    public static Map<class_2960, List<class_3503.class_5145>> didLoadTagMap(String directory, Map<class_2960, List<class_3503.class_5145>> tagsMap) {
        TagRegistryImpl<?, ?> type = TYPES.get(directory);
        if (type != null) {
            Object provider = type.emitLoadEvent(false);
            provider.forEach((tag, entries) -> {
                List builder = tagsMap.computeIfAbsent(tag.comp_327(), key -> Lists.newArrayList());
                entries.forEach(wrapper -> builder.add(new class_3503.class_5145(wrapper.createTagEntry(), LibWoverTag.C.namespace)));
            });
        }
        return tagsMap;
    }

    public static <T> class_9139<class_9129, class_6862<T>> streamCodec(final class_5321<class_2378<T>> registry) {
        return new class_9139<class_9129, class_6862<T>>(){

            public class_6862<T> decode(class_9129 registryFriendlyByteBuf) {
                class_2960 location = (class_2960)class_2960.field_48267.decode((Object)registryFriendlyByteBuf);
                return class_6862.method_40092((class_5321)registry, (class_2960)(location.equals((Object)NO_TAG) ? null : location));
            }

            public void encode(class_9129 registryFriendlyByteBuf, class_6862<T> tag) {
                class_2960.field_48267.encode((Object)registryFriendlyByteBuf, (Object)(tag == null ? NO_TAG : tag.comp_327()));
            }
        };
    }
}

