/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverDataProvider;
import org.betterx.wover.entrypoint.LibWoverTag;
import org.betterx.wover.tag.api.TagManager;
import org.betterx.wover.tag.api.TagRegistry;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagElementWrapper;
import org.betterx.wover.tag.impl.TagManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WoverTagProvider<T, P extends TagBootstrapContext<T>>
implements WoverDataProvider<FabricTagProvider<T>> {
    @Nullable
    protected List<String> modIDs;
    public final ModCore modCore;
    public final TagRegistry<T, P> tagRegistry;
    private Set<class_6862<T>> forceWrite;

    @NotNull
    private static List<String> defaultModIDList(ModCore modCore) {
        return List.of(modCore.namespace, modCore.modId);
    }

    public WoverTagProvider(ModCore modCore, TagRegistry<T, P> tagRegistry) {
        this(modCore, tagRegistry, WoverTagProvider.defaultModIDList(modCore), Set.of());
    }

    public WoverTagProvider(ModCore modCore, TagRegistry<T, P> tagRegistry, Set<class_6862<T>> forceWriteKeys) {
        this(modCore, tagRegistry, WoverTagProvider.defaultModIDList(modCore), forceWriteKeys);
    }

    public WoverTagProvider(ModCore modCore, TagRegistry<T, P> tagRegistry, @Nullable List<String> modIDs) {
        this(modCore, tagRegistry, modIDs, Set.of());
    }

    public WoverTagProvider(ModCore modCore, TagRegistry<T, P> tagRegistry, @Nullable List<String> modIDs, Set<class_6862<T>> forceWriteKeys) {
        this.modCore = modCore;
        this.tagRegistry = tagRegistry;
        this.modIDs = modIDs;
        this.forceWrite = forceWriteKeys;
    }

    public void mergeAllowedAndForced(@Nullable WoverTagProvider<T, ?> provider) {
        if (provider != null) {
            HashSet<class_6862<T>> c = new HashSet<class_6862<T>>(this.forceWrite);
            c.addAll(provider.forceWrite);
            this.forceWrite = Collections.unmodifiableSet(c);
            if (provider.modIDs != null) {
                if (this.modIDs == null) {
                    this.modIDs = Collections.unmodifiableList(new LinkedList<String>(provider.modIDs));
                } else {
                    LinkedList<String> l = new LinkedList<String>(provider.modIDs);
                    l.addAll(this.modIDs);
                    this.modIDs = Collections.unmodifiableList(l);
                }
            }
        }
    }

    protected boolean shouldAdd(class_2960 loc) {
        return this.modIDs == null || this.modIDs.contains(loc.method_12836());
    }

    public abstract void prepareTags(P var1);

    protected boolean initAll() {
        return false;
    }

    protected String getTitle() {
        return this.modCore.namespace + "/" + this.getClass().getSimpleName();
    }

    protected boolean replaceOriginalTags() {
        return false;
    }

    public FabricTagProvider<T> getProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        return new FabricTagProvider<T>(output, this.tagRegistry.registryKey(), registriesFuture){

            public String method_10321() {
                return WoverTagProvider.this.getTitle() + " (" + super.method_10321() + ")";
            }

            protected final void method_10514(class_7225.class_7874 arg) {
                Object provider = WoverTagProvider.this.tagRegistry.createBootstrapContext(WoverTagProvider.this.initAll());
                WoverTagProvider.this.forceWrite.forEach(arg_0 -> provider.asPlaceholder(arg_0));
                WoverTagProvider.this.prepareTags(provider);
                LibWoverTag.C.LOG.debug("    ****> Writing tags for {}", new Object[]{WoverTagProvider.this.modIDs});
                provider.forEach((tag, allElements) -> {
                    List<TagElementWrapper> elements;
                    boolean force = WoverTagProvider.this.forceWrite.contains(tag);
                    List<TagElementWrapper> list = elements = WoverTagProvider.this.shouldAdd(tag.comp_327()) ? allElements : allElements.stream().filter(element -> WoverTagProvider.this.shouldAdd(element.id())).toList();
                    if (!force && elements.isEmpty()) {
                        return;
                    }
                    FabricTagProvider.FabricTagBuilder builder = this.getOrCreateTagBuilder((class_6862)tag).setReplace(WoverTagProvider.this.replaceOriginalTags());
                    for (TagElementWrapper element2 : elements) {
                        if (element2.tag()) {
                            if (element2.required()) {
                                builder.forceAddTag(class_6862.method_40092((class_5321)this.field_40957, (class_2960)element2.id()));
                                continue;
                            }
                            builder.addOptionalTag(element2.id());
                            continue;
                        }
                        if (element2.required()) {
                            builder.add(element2.id());
                            continue;
                        }
                        builder.addOptional(element2.id());
                    }
                });
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + String.valueOf(this.modCore) + " (" + String.valueOf(this.modIDs) + ")";
    }

    public static abstract class ForEntityTypes
    extends WoverTagProvider<class_1299<?>, TagBootstrapContext<class_1299<?>>> {
        public ForEntityTypes(ModCore modCore) {
            super(modCore, TagManager.ENTITY_TYPES);
        }

        public ForEntityTypes(ModCore modCore, @Nullable List<String> modIDs) {
            super(modCore, TagManager.ENTITY_TYPES, modIDs);
        }

        public ForEntityTypes(ModCore modCore, Set<class_6862<class_1299<?>>> forceWriteKeys) {
            super(modCore, TagManager.ENTITY_TYPES, forceWriteKeys);
        }

        public ForEntityTypes(ModCore modCore, @Nullable List<String> modIDs, Set<class_6862<class_1299<?>>> forceWriteKeys) {
            super(modCore, TagManager.ENTITY_TYPES, modIDs, forceWriteKeys);
        }
    }

    public static abstract class ForEnchantments
    extends WoverTagProvider<class_1887, TagBootstrapContext<class_1887>> {
        public ForEnchantments(ModCore modCore) {
            super(modCore, TagManager.ENCHANTMENTS);
        }

        public ForEnchantments(ModCore modCore, @Nullable List<String> modIDs) {
            super(modCore, TagManager.ENCHANTMENTS, modIDs);
        }

        public ForEnchantments(ModCore modCore, Set<class_6862<class_1887>> forceWriteKeys) {
            super(modCore, TagManager.ENCHANTMENTS, forceWriteKeys);
        }

        public ForEnchantments(ModCore modCore, @Nullable List<String> modIDs, Set<class_6862<class_1887>> forceWriteKeys) {
            super(modCore, TagManager.ENCHANTMENTS, modIDs, forceWriteKeys);
        }
    }

    public static abstract class ForBiomes
    extends WoverTagProvider<class_1959, TagBootstrapContext<class_1959>> {
        public ForBiomes(ModCore modCore) {
            super(modCore, TagManagerImpl.BIOMES);
        }

        public ForBiomes(ModCore modCore, @Nullable List<String> modIDs) {
            super(modCore, TagManagerImpl.BIOMES, modIDs);
        }

        public ForBiomes(ModCore modCore, Set<class_6862<class_1959>> forceWriteKeys) {
            super(modCore, TagManagerImpl.BIOMES, forceWriteKeys);
        }

        public ForBiomes(ModCore modCore, @Nullable List<String> modIDs, Set<class_6862<class_1959>> forceWriteKeys) {
            super(modCore, TagManagerImpl.BIOMES, modIDs, forceWriteKeys);
        }
    }

    public static abstract class ForItems
    extends WoverTagProvider<class_1792, ItemTagBootstrapContext> {
        public ForItems(ModCore modCore) {
            super(modCore, TagManagerImpl.ITEMS);
        }

        public ForItems(ModCore modCore, @Nullable List<String> modIDs) {
            super(modCore, TagManagerImpl.ITEMS, modIDs);
        }

        public ForItems(ModCore modCore, Set<class_6862<class_1792>> forceWriteKeys) {
            super(modCore, TagManagerImpl.ITEMS, forceWriteKeys);
        }

        public ForItems(ModCore modCore, @Nullable List<String> modIDs, Set<class_6862<class_1792>> forceWriteKeys) {
            super(modCore, TagManagerImpl.ITEMS, modIDs, forceWriteKeys);
        }
    }

    public static abstract class ForBlocks
    extends WoverTagProvider<class_2248, TagBootstrapContext<class_2248>> {
        public ForBlocks(ModCore modCore) {
            super(modCore, TagManagerImpl.BLOCKS);
        }

        public ForBlocks(ModCore modCore, @Nullable List<String> modIDs) {
            super(modCore, TagManagerImpl.BLOCKS, modIDs);
        }

        public ForBlocks(ModCore modCore, Set<class_6862<class_2248>> forceWriteKeys) {
            super(modCore, TagManagerImpl.BLOCKS, forceWriteKeys);
        }

        public ForBlocks(ModCore modCore, @Nullable List<String> modIDs, Set<class_6862<class_2248>> forceWriteKeys) {
            super(modCore, TagManagerImpl.BLOCKS, modIDs, forceWriteKeys);
        }
    }
}

