/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4d;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.TextureUtil;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ModConfig;
import pigcart.particlerain.particle.WeatherParticle;

public class StreakParticle
extends WeatherParticle {
    Direction direction;

    private StreakParticle(ClientLevel level, double x, double y, double z, int direction2D, SpriteSet provider) {
        super(level, x, y, z, level.random.nextFloat() / 10.0f, ModConfig.CONFIG.streak.opacity, ModConfig.CONFIG.streak.size, 0.0f, 0.0f);
        if (ModConfig.CONFIG.compat.waterTint) {
            TextureUtil.applyWaterTint(this, level, (BlockPos)this.pos);
        } else {
            this.setColor(0.2f, 0.3f, 1.0f);
        }
        this.setSprite(provider.get(level.getRandom()));
        this.alpha = ModConfig.CONFIG.streak.opacity;
        this.hasPhysics = true;
        this.roll = (float)direction2D * 1.5707964f;
        this.direction = Direction.from2DDataValue((int)direction2D);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.onGround) {
            this.doCollisionAnim = true;
        }
        if (this.age % 10 == 0) {
            this.gravity = this.random.nextBoolean() ? this.random.nextFloat() / 10.0f : 0.0f;
        }
    }

    @Override
    public void onPositionUpdate() {
        Vec3 start = new Vec3(this.x, this.y, this.z);
        Vec3 end = start.relative(this.direction.getOpposite(), (double)0.06f);
        BlockHitResult hit = this.level.clip(StonecutterUtil.getClipContext(start, end));
        BlockState stateBehind = this.level.getBlockState(hit.getBlockPos());
        FluidState fluidState = this.level.getFluidState((BlockPos)this.pos);
        if (hit.getType().equals((Object)HitResult.Type.MISS)) {
            Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, this.x, this.y - 0.05, this.z, 0.0, 0.0, 0.0);
            this.doCollisionAnim = true;
        } else if (!WeatherParticleManager.canHostStreaks(stateBehind) || !fluidState.isEmpty()) {
            this.doCollisionAnim = true;
        }
    }

    @Override
    public void tickCollisionAnim() {
        this.gravity = 0.0f;
        this.yd = 0.0;
        this.alpha -= 0.1f;
        if (this.alpha <= 0.0f) {
            this.remove();
        }
    }

    @Override
    public void tickDistanceFade() {
        if (!this.doCollisionAnim) {
            super.tickDistanceFade();
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
        Vec3 camPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)f, (double)this.xo, (double)this.x) - camPos.x());
        float y = (float)(Mth.lerp((double)f, (double)this.yo, (double)this.y) - camPos.y());
        float z = (float)(Mth.lerp((double)f, (double)this.zo, (double)this.z) - camPos.z());
        Quaternionf quaternion = new Quaternionf(new AxisAngle4d((double)this.roll, 0.0, 1.0, 0.0));
        this.turnBackfaceFlipways(quaternion, new Vector3f(x, y, z));
        this.renderRotatedQuad(vertexConsumer, quaternion, x, y + this.quadSize, z, f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public DefaultFactory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new StreakParticle(level, x, y, z, (int)velocityX, this.provider);
        }
    }
}

