/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4d;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ModConfig;
import pigcart.particlerain.particle.WeatherParticle;
import pigcart.particlerain.particle.render.BlendedParticleRenderType;

public class MistParticle
extends WeatherParticle {
    float xdxd;
    float zdzd;

    private MistParticle(ClientLevel level, double x, double y, double z, SpriteSet provider) {
        super(level, x, y, z, 0.0f, ModConfig.CONFIG.mist.opacity, ModConfig.CONFIG.mist.size, ModConfig.CONFIG.mist.windStrength, ModConfig.CONFIG.mist.stormWindStrength);
        ++WeatherParticleManager.fogCount;
        this.setSprite(provider.get(level.getRandom()));
        this.setSize(ModConfig.CONFIG.mist.size + 1.0f, ModConfig.CONFIG.mist.size + 1.0f);
        Color color = new Color(((Biome)this.level.getBiome((BlockPos)this.pos).value()).getFogColor());
        this.rCol = (float)color.getRed() / 255.0f;
        this.gCol = (float)color.getGreen() / 255.0f;
        this.bCol = (float)color.getBlue() / 255.0f;
        this.oRoll = this.roll = 1.5707964f * (float)level.random.nextInt(4);
        this.xdxd = (this.random.nextFloat() - 0.5f) / 100.0f;
        this.zdzd = (this.random.nextFloat() - 0.5f) / 100.0f;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.getBlockState((BlockPos)this.pos).isSolid()) {
            this.remove();
        }
        this.xd = this.xdxd;
        this.zd = this.zdzd;
    }

    public void remove() {
        if (this.isAlive()) {
            --WeatherParticleManager.fogCount;
        }
        super.remove();
    }

    public ParticleRenderType getRenderType() {
        if (this.targetOpacity == 1.0f) {
            return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
        }
        return BlendedParticleRenderType.INSTANCE;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickPercent) {
        Vec3 camPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)tickPercent, (double)this.xo, (double)this.x) - camPos.x());
        float y = (float)(Mth.lerp((double)tickPercent, (double)this.yo, (double)this.y) - camPos.y());
        float z = (float)(Mth.lerp((double)tickPercent, (double)this.zo, (double)this.z) - camPos.z());
        Quaternionf quaternion = new Quaternionf(new AxisAngle4d(1.5707963705062866, -1.0, 0.0, 0.0));
        quaternion.rotateZ(Mth.lerp((float)tickPercent, (float)this.oRoll, (float)this.roll));
        this.turnBackfaceFlipways(quaternion, new Vector3f(x, y, z));
        this.renderRotatedQuad(vertexConsumer, quaternion, x, y, z, tickPercent);
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public DefaultFactory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new MistParticle(level, x, y, z, this.provider);
        }
    }
}

