/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.mixin.render;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.TextureUtil;
import pigcart.particlerain.config.ModConfig;

@Mixin(value={SpriteLoader.class})
public abstract class SpriteLoaderMixin {
    @Shadow
    @Final
    private ResourceLocation location;
    @Unique
    List<SpriteContents> spriteContentsList;

    @Inject(method={"stitch"}, at={@At(value="HEAD")})
    public void stitch(List<SpriteContents> list, int i, Executor executor, CallbackInfoReturnable<SpriteLoader.Preparations> cir) {
        if (this.location.equals((Object)StonecutterUtil.getResourceLocation("textures/atlas/particles.png"))) {
            this.spriteContentsList = list;
        }
    }

    @ModifyExpressionValue(method={"stitch"}, at={@At(value="NEW", args={"class=net/minecraft/client/renderer/texture/Stitcher"})})
    private Stitcher<SpriteContents> registerWeatherParticleSprites(Stitcher<SpriteContents> stitcher) {
        if (this.location.equals((Object)StonecutterUtil.getResourceLocation("textures/atlas/particles.png"))) {
            int i;
            int i2;
            NativeImage rainImage = null;
            NativeImage snowImage = null;
            try {
                rainImage = TextureUtil.loadTexture(StonecutterUtil.getResourceLocation("textures/environment/rain.png"));
                snowImage = TextureUtil.loadTexture(StonecutterUtil.getResourceLocation("textures/environment/snow.png"));
                if (ModConfig.CONFIG.compat.waterTint) {
                    TextureUtil.applyToAllPixels((IntUnaryOperator)TextureUtil.desaturateOperation, rainImage);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (i2 = 0; i2 < 4; ++i2) {
                stitcher.registerSprite((Stitcher.Entry)TextureUtil.splitImage(rainImage, i2, "rain_"));
            }
            for (i2 = 0; i2 < 4; ++i2) {
                stitcher.registerSprite((Stitcher.Entry)TextureUtil.splitImage(snowImage, i2, "snow_"));
            }
            int rippleResolution = TextureUtil.getRippleResolution(this.spriteContentsList);
            for (i = 0; i < 8; ++i) {
                stitcher.registerSprite((Stitcher.Entry)TextureUtil.generateRipple(i, rippleResolution));
            }
            if (ModConfig.CONFIG.compat.waterTint) {
                for (i = 0; i < 4; ++i) {
                    NativeImage splashImage = null;
                    try {
                        splashImage = TextureUtil.loadTexture(StonecutterUtil.getResourceLocation("textures/particle/splash_" + i + ".png"));
                        TextureUtil.applyToAllPixels((IntUnaryOperator)TextureUtil.desaturateOperation, splashImage);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    stitcher.registerSprite((Stitcher.Entry)new SpriteContents(StonecutterUtil.getResourceLocation("particlerain", "splash_" + i), new FrameSize(splashImage.getWidth(), splashImage.getHeight()), splashImage, StonecutterUtil.getSpriteMetadata()));
                }
            }
        }
        return stitcher;
    }
}

