/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.loaders.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.config.ConfigScreens;
import pigcart.particlerain.particle.MistParticle;
import pigcart.particlerain.particle.RippleParticle;
import pigcart.particlerain.particle.ShrubParticle;
import pigcart.particlerain.particle.StreakParticle;

@Mod(value="particlerain")
public class NeoforgeEntrypoint {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.PARTICLE_TYPE, (String)"particlerain");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> SHRUB = NeoforgeEntrypoint.registerParticle("shrub");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> MIST = NeoforgeEntrypoint.registerParticle("mist");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> RIPPLE = NeoforgeEntrypoint.registerParticle("ripple");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> STREAK = NeoforgeEntrypoint.registerParticle("streak");

    private static DeferredHolder<ParticleType<?>, SimpleParticleType> registerParticle(String name) {
        return PARTICLE_TYPES.register(name, () -> new SimpleParticleType(true));
    }

    public static void onTick(ClientTickEvent.Post event) {
        ParticleRain.onTick(Minecraft.getInstance());
    }

    public static void onRegisterCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register(ParticleRain.getCommands());
    }

    public static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)SHRUB.get(), ShrubParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)MIST.get(), MistParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)RIPPLE.get(), RippleParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)STREAK.get(), StreakParticle.DefaultFactory::new);
        ParticleRain.SHRUB = (SimpleParticleType)SHRUB.get();
        ParticleRain.MIST = (SimpleParticleType)MIST.get();
        ParticleRain.RIPPLE = (SimpleParticleType)RIPPLE.get();
        ParticleRain.STREAK = (SimpleParticleType)STREAK.get();
    }

    public NeoforgeEntrypoint(IEventBus eventBus) {
        NeoForge.EVENT_BUS.addListener(NeoforgeEntrypoint::onTick);
        NeoForge.EVENT_BUS.addListener(NeoforgeEntrypoint::onRegisterCommands);
        PARTICLE_TYPES.register(eventBus);
        eventBus.addListener(NeoforgeEntrypoint::onRegisterParticleProviders);
        ParticleRain.onInitializeClient();
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (modContainer, parent) -> ConfigScreens.generateMainConfigScreen(parent));
    }
}

