/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pigcart.particlerain.StonecutterUtil;
import pigcart.particlerain.TaskScheduler;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ConfigScreens;
import pigcart.particlerain.config.ModConfig;

public class ParticleRain {
    public static int clientTicks = 0;
    public static final String MOD_ID = "particlerain";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"particlerain");
    public static final TagKey<Block> GLASS_PANES = ParticleRain.commonBlockTag("glass_panes");
    public static SimpleParticleType MIST;
    public static SimpleParticleType SHRUB;
    public static SimpleParticleType RIPPLE;
    public static SimpleParticleType STREAK;
    public static SoundEvent WEATHER_SNOW;
    public static SoundEvent WEATHER_SNOW_ABOVE;
    public static SoundEvent WEATHER_SANDSTORM;
    public static SoundEvent WEATHER_SANDSTORM_ABOVE;

    public static TagKey<Block> commonBlockTag(String tagId) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)StonecutterUtil.getResourceLocation("c", tagId));
    }

    public static void onInitializeClient() {
        ModConfig.loadConfig();
        WEATHER_SNOW = ParticleRain.createSoundEvent("weather.snow");
        WEATHER_SNOW_ABOVE = ParticleRain.createSoundEvent("weather.snow.above");
        WEATHER_SANDSTORM = ParticleRain.createSoundEvent("weather.sandstorm");
        WEATHER_SANDSTORM_ABOVE = ParticleRain.createSoundEvent("weather.sandstorm.above");
    }

    public static void onTick(Minecraft client) {
        if (!client.isPaused() && client.level != null && client.gameRenderer.getMainCamera().isInitialized()) {
            ++clientTicks;
            WeatherParticleManager.tick(client.level, client.gameRenderer.getMainCamera().getPosition());
            TaskScheduler.tick();
        }
    }

    private static SoundEvent createSoundEvent(String name) {
        ResourceLocation id = StonecutterUtil.getResourceLocation(MOD_ID, name);
        return SoundEvent.createVariableRangeEvent((ResourceLocation)id);
    }

    public static <S> LiteralArgumentBuilder<S> getCommands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MOD_ID).executes(ctx -> {
            TaskScheduler.scheduleDelayed(1, () -> Minecraft.getInstance().setScreen(ConfigScreens.generateMainConfigScreen(null)));
            return 0;
        })).then(LiteralArgumentBuilder.literal((String)"debug").executes(ctx -> {
            ClientLevel level = Minecraft.getInstance().level;
            ParticleRain.addChatMsg(String.format("Particle count: %d/%d", WeatherParticleManager.getParticleCount(), WeatherParticleManager.particleGroup.getLimit()));
            ParticleRain.addChatMsg(String.format("Fog density: %d/%f", WeatherParticleManager.fogCount, Float.valueOf(ModConfig.CONFIG.mist.density)));
            BlockPos blockPos = BlockPos.containing((Position)Minecraft.getInstance().player.position());
            Holder holder = level.getBiome(blockPos);
            String biomeStr = (String)holder.unwrap().map(resourceKey -> resourceKey.location().toString(), biome -> "[unregistered " + String.valueOf(biome) + "]");
            ParticleRain.addChatMsg("Biome: " + biomeStr);
            Biome.Precipitation precipitation = StonecutterUtil.getPrecipitationAt((Level)level, (Biome)holder.value(), blockPos);
            ParticleRain.addChatMsg("Precipitation: " + String.valueOf(precipitation));
            ParticleRain.addChatMsg("Base Temp: " + ((Biome)holder.value()).getBaseTemperature());
            ParticleRain.addChatMsg("Cloud height: " + StonecutterUtil.getCloudHeight(level));
            return 0;
        }));
    }

    private static void addChatMsg(String message) {
        Minecraft.getInstance().gui.getChat().addMessage((Component)Component.literal((String)message));
    }

    public static void debugValue(float value) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        Minecraft.getInstance().gui.setOverlayMessage((Component)Component.literal((String)df.format(value)), true);
    }
}

